/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.hyperlink;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class ApisupportHyperlinkProvider
implements HyperlinkProviderExt {
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.STRING_LITERAL);

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document document, int n, HyperlinkType hyperlinkType) {
        return this.getHyperlinkSpan(document, n, hyperlinkType) != null;
    }

    public int[] getHyperlinkSpan(Document document, int n, HyperlinkType hyperlinkType) {
        return ApisupportHyperlinkProvider.getIdentifierSpan(document, n, null);
    }

    public void performClickAction(Document document, int n, HyperlinkType hyperlinkType) {
        Line line = this.getLine(document, n);
        if (line != null) {
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getTooltipText(Document document, int n, HyperlinkType hyperlinkType) {
        Line line = this.getLine(document, n);
        if (line != null) {
            return line.getText();
        }
        return null;
    }

    private Line getLine(Document document, int n) {
        FileObject fileObject;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)tokenHierarchy, (int)n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return null;
        }
        Token token = tokenSequence.token();
        FileObject fileObject2 = ApisupportHyperlinkProvider.getFileObject(document);
        String string = token.toString();
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((fileObject = this.findBundle(fileObject2)) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                try {
                    editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
                if (lineCookie != null) {
                    Line.Set set = lineCookie.getLineSet();
                    for (Line line : set.getLines()) {
                        if (!line.getText().contains(string + "=")) continue;
                        return line;
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        return null;
    }

    private FileObject findBundle(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        String string = classPath.getResourceName(fileObject);
        if (string != null) {
            int n = string.lastIndexOf(47);
            string = string.substring(0, n) + "/Bundle.properties";
            return classPath.findResource(string);
        }
        return null;
    }

    public static int[] getIdentifierSpan(Document document, int n, Token<JavaTokenId>[] tokenArray) {
        FileObject fileObject = ApisupportHyperlinkProvider.getFileObject(document);
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (nbModuleProvider == null) {
            return null;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)tokenHierarchy, (int)n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return null;
        }
        Token token = tokenSequence.token();
        boolean bl = false;
        boolean bl2 = false;
        if (USABLE_TOKEN_IDS.contains(token.id())) {
            for (int i = 0; i < 10 && tokenSequence.movePrevious(); ++i) {
                Token token2 = tokenSequence.token();
                if (TokenUtilities.equals((CharSequence)"getMessage", (Object)token2.text())) {
                    bl = true;
                    continue;
                }
                if (!TokenUtilities.equals((CharSequence)"NbBundle", (Object)token2.text())) continue;
                bl2 = true;
            }
            if (bl2 && bl) {
                tokenSequence.move(n);
                tokenSequence.moveNext();
                return new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
            }
        }
        return null;
    }

    private static FileObject getFileObject(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }
}

