/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.util.LinkedList;

public class Filter {
    private IncludeExclude[] inc = new IncludeExclude[0];
    private IncludeExclude[] exc = new IncludeExclude[0];

    public void setIncludes(IncludeExclude[] includes) {
        this.inc = this.arrayCopy(includes);
    }

    public void setExcludes(IncludeExclude[] excludes) {
        this.exc = this.arrayCopy(excludes);
    }

    public IncludeExclude[] getIncludes() {
        return this.arrayCopy(this.inc);
    }

    public IncludeExclude[] getExcludes() {
        return this.arrayCopy(this.exc);
    }

    public boolean isIncluded(String name) {
        int i;
        for (i = 0; i < this.inc.length && this.inc[i].getName() != null && !Filter.match(this.inc[i].getName(), name); ++i) {
        }
        if (0 < this.inc.length && i == this.inc.length) {
            return false;
        }
        for (i = 0; i < this.exc.length && !Filter.match(this.exc[i].getName(), name); ++i) {
        }
        return i == this.exc.length;
    }

    public String getExpectedFail(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.inc.length; ++i) {
            if (this.inc[i].getName() != null && !Filter.match(this.inc[i].getName(), name) || this.inc[i].getExpectedFail() == null) continue;
            if (sb.length() != 0) {
                sb.append("; ");
            }
            sb.append(this.inc[i].getExpectedFail());
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static boolean match(String pattern, String str) {
        char ch;
        int i;
        if (null == pattern && null == str) {
            return true;
        }
        if (null == pattern || null == str) {
            return false;
        }
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || ch2 == strArr[i]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i3 + j]) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer b = new StringBuffer();
        if (0 < this.inc.length) {
            b.append("-i ");
            for (i = 0; i < this.inc.length; ++i) {
                b.append(this.inc[i]);
                b.append(' ');
            }
        }
        if (0 < this.exc.length) {
            b.append("-e ");
            for (i = 0; i < this.exc.length; ++i) {
                b.append(this.exc[i]);
                b.append(' ');
            }
        }
        return b.toString();
    }

    private IncludeExclude[] arrayCopy(IncludeExclude[] orig) {
        LinkedList<IncludeExclude> lst = new LinkedList<IncludeExclude>();
        for (int i = 0; i < orig.length; ++i) {
            if (null == orig[i] || orig[i].getName() == null && orig[i].getExpectedFail() == null) continue;
            lst.add(orig[i]);
        }
        return lst.toArray(new IncludeExclude[0]);
    }

    public static class IncludeExclude {
        private String name;
        private String expectedFail;

        public IncludeExclude() {
        }

        public IncludeExclude(String name, String expectedFail) {
            this.name = name;
            this.expectedFail = expectedFail;
        }

        public String getName() {
            return this.name;
        }

        public String getExpectedFail() {
            return this.expectedFail;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setExpectedFail(String expectedFail) {
            this.expectedFail = expectedFail;
        }

        public String toString() {
            return this.name + ":" + this.expectedFail;
        }
    }
}

