/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.nodes;

import javax.swing.Action;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.actions.ConnectAction;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

class DatabaseNode
extends AbstractNode
implements Comparable {
    private static final String ICON_BASE = "org/netbeans/modules/db/mysql/resources/database.gif";
    private final Database model;

    public DatabaseNode(Database model) {
        super(Children.LEAF);
        this.model = model;
        this.setDisplayName(model.getDisplayName());
        this.setShortDescription(model.getShortDescription());
        this.setIconBaseWithExtension(ICON_BASE);
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return super.getActions(context);
        }
        return new SystemAction[]{SystemAction.get(ConnectAction.class), SystemAction.get(DeleteAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        DatabaseServer server = this.model.getServer();
        String dbname = this.model.getDbName();
        server.dropDatabase(dbname);
    }

    public Node.Cookie getCookie(Class cls) {
        if (cls == Database.class) {
            return this.model;
        }
        return super.getCookie(cls);
    }

    public int compareTo(Object other) {
        Node othernode = (Node)other;
        return this.getDisplayName().compareTo(othernode.getDisplayName());
    }
}

