/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXPanel;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;

class DataViewTablePanel
extends JXPanel {
    private final DataViewTableUI tableUI;
    private DataViewUI dataViewUI;
    private DataView dataView;
    private boolean isDirty = false;
    private UpdatedRowContext updatedRowCtx;
    private JXTableRowHeader rowHeader;
    private boolean editable;

    public DataViewTablePanel(DataView dataView, DataViewUI dataViewUI, DataViewActionHandler actionHandler) {
        this.setLayout(new BorderLayout());
        this.dataView = dataView;
        this.dataViewUI = dataViewUI;
        this.tableUI = new DataViewTableUI(this, actionHandler, dataView);
        this.updatedRowCtx = new UpdatedRowContext();
        this.rowHeader = new JXTableRowHeader((JTable)((Object)this.tableUI));
        JScrollPane sp = new JScrollPane((Component)((Object)this.tableUI));
        sp.setRowHeaderView(this.rowHeader);
        sp.setCorner("UPPER_LEFT_CORNER", this.rowHeader.getTableHeader());
        this.add(sp, "Center");
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    protected boolean isEditable() {
        return this.editable;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
        if (!this.isDirty) {
            this.updatedRowCtx.removeAllUpdates();
        }
    }

    DataViewTableUI getDataViewTableUI() {
        return this.tableUI;
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.updatedRowCtx;
    }

    boolean isCommitEnabled() {
        return this.dataViewUI.isCommitEnabled();
    }

    public void createTableModel(List<Object[]> rows) {
        this.setDirty(false);
        this.tableUI.createTableModel(rows, this.rowHeader);
    }

    void handleColumnUpdated() {
        this.isDirty = true;
        this.dataViewUI.setCommitEnabled(true);
        this.dataViewUI.setCancelEnabled(true);
    }

    List<Object[]> getPageDataFromTable() {
        DefaultTableModel dtm = (DefaultTableModel)this.tableUI.getModel();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int colCnt = dtm.getColumnCount();
        for (Vector row : dtm.getDataVector()) {
            Object[] rowObj = new Object[colCnt];
            int i = 0;
            for (Object colVal : row) {
                rowObj[i++] = colVal;
            }
            rows.add(rowObj);
        }
        return rows;
    }

    public void enableDeleteBtn(boolean value) {
        this.dataViewUI.enableDeleteBtn(value);
    }

    void setValueAt(Object val, int row, int col) {
        DefaultTableModel dtm = (DefaultTableModel)this.tableUI.getModel();
        dtm.setValueAt(val, row, col);
    }
}

