/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

public class JavadocRegistry
implements GlobalPathRegistryListener,
ChangeListener,
PropertyChangeListener {
    private static JavadocRegistry INSTANCE;
    private GlobalPathRegistry regs;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private Set<JavadocForBinaryQuery.Result> results;
    private ClassPath docRoots;
    private Set<ClassPath> classpaths;

    private JavadocRegistry() {
        this.regs = GlobalPathRegistry.getDefault();
        this.regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)this);
    }

    public static synchronized JavadocRegistry getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JavadocRegistry();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getDocRoots() {
        JavadocRegistry javadocRegistry = this;
        synchronized (javadocRegistry) {
            if (this.docRoots != null) {
                return this.docRoots.getRoots();
            }
        }
        HashSet<ClassPath> _classpaths = new HashSet<ClassPath>();
        HashSet<JavadocForBinaryQuery.Result> _results = new HashSet<JavadocForBinaryQuery.Result>();
        Set<URL> s = JavadocRegistry.readRoots(this, _classpaths, _results);
        JavadocRegistry javadocRegistry2 = this;
        synchronized (javadocRegistry2) {
            if (this.docRoots == null) {
                this.docRoots = ClassPathSupport.createClassPath((URL[])s.toArray(new URL[s.size()]));
                this.classpaths = _classpaths;
                this.results = _results;
                JavadocRegistry.registerListeners(this, _classpaths, _results, this.docRoots);
            }
            return this.docRoots.getRoots();
        }
    }

    public JavadocSearchType findSearchType(FileObject apidocRoot) {
        String encoding = this.getDocEncoding(apidocRoot);
        for (JavadocSearchType jdst : Lookup.getDefault().lookupAll(JavadocSearchType.class)) {
            if (!jdst.accepts(apidocRoot, encoding)) continue;
            return jdst;
        }
        return null;
    }

    private static Set<URL> readRoots(JavadocRegistry jdr, Set<ClassPath> classpaths, Set<JavadocForBinaryQuery.Result> results) {
        HashSet<URL> roots = new HashSet<URL>();
        LinkedList paths = new LinkedList();
        paths.addAll(jdr.regs.getPaths("classpath/compile"));
        paths.addAll(jdr.regs.getPaths("classpath/boot"));
        for (ClassPath ccp : paths) {
            classpaths.add(ccp);
            for (ClassPath.Entry ccpRoot : ccp.entries()) {
                JavadocForBinaryQuery.Result result = JavadocForBinaryQuery.findJavadoc((URL)ccpRoot.getURL());
                results.add(result);
                URL[] jdRoots = result.getRoots();
                roots.addAll(Arrays.asList(jdRoots));
            }
        }
        return roots;
    }

    private static void registerListeners(JavadocRegistry jdr, Set<ClassPath> classpaths, Set<JavadocForBinaryQuery.Result> results, ClassPath docRoots) {
        for (ClassPath cpath : classpaths) {
            cpath.addPropertyChangeListener((PropertyChangeListener)jdr);
        }
        for (JavadocForBinaryQuery.Result result : results) {
            result.addChangeListener((ChangeListener)jdr);
        }
        docRoots.addPropertyChangeListener((PropertyChangeListener)jdr);
    }

    public void pathsAdded(GlobalPathRegistryEvent event) {
        this.throwCache();
        this.cs.fireChange();
    }

    public void pathsRemoved(GlobalPathRegistryEvent event) {
        this.throwCache();
        this.cs.fireChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName()) || event.getSource() == this.docRoots) {
            this.throwCache();
            this.cs.fireChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.throwCache();
        this.cs.fireChange();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private synchronized void throwCache() {
        if (this.classpaths != null) {
            for (ClassPath cp : this.classpaths) {
                cp.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.classpaths.clear();
        }
        if (this.results != null) {
            for (JavadocForBinaryQuery.Result result : this.results) {
                result.removeChangeListener((ChangeListener)this);
            }
            this.results.clear();
        }
        if (this.docRoots != null) {
            this.docRoots.removePropertyChangeListener((PropertyChangeListener)this);
            this.docRoots = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDocEncoding(FileObject root) {
        FileObject fo;
        if (!$assertionsDisabled) {
            if (root == null) throw new AssertionError();
            if (!root.isFolder()) {
                throw new AssertionError();
            }
        }
        if ((fo = root.getFileObject("index-all.html")) == null) {
            fo = root.getFileObject("index-files");
            if (fo == null) {
                return null;
            }
            if ((fo = fo.getFileObject("index-1.html")) == null) {
                return null;
            }
        }
        ParserDelegator pd = new ParserDelegator();
        try {
            InputStream is = fo.getInputStream();
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                EncodingCallback ecb = new EncodingCallback(in);
                pd.parse(in, ecb, true);
                String string = ecb.getEncoding();
                return string;
            }
            catch (IOException ioe) {
                return null;
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe2) {
            ErrorManager.getDefault().annotate((Throwable)ioe2, fo.toString());
            ErrorManager.getDefault().notify((Throwable)ioe2);
        }
        return null;
    }

    private static class EncodingCallback
    extends HTMLEditorKit.ParserCallback {
        private Reader in;
        private String encoding;

        public EncodingCallback(Reader in) {
            this.in = in;
        }

        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            String value;
            if (t == HTML.Tag.META && (value = (String)a.getAttribute(HTML.Attribute.CONTENT)) != null) {
                StringTokenizer tk = new StringTokenizer(value, ";");
                while (tk.hasMoreTokens()) {
                    String str = tk.nextToken().trim();
                    if (!str.startsWith("charset") || (str = str.substring(7).trim()).charAt(0) != '=') continue;
                    this.encoding = str.substring(1).trim();
                    try {
                        this.in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
            }
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.BODY) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }
}

