/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.javadoc.hints.JavadocHintProvider;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

final class RemoveTagFix
implements Fix,
CancellableTask<WorkingCopy> {
    private String tagName;
    private final JavadocUtilities.TagHandle tagHandle;
    private final ElementHandle handle;
    private final FileObject file;
    private final SourceVersion spec;
    private Position[] tagBounds;
    private boolean isFormattingTouched = false;
    private Document doc;

    RemoveTagFix(String string, JavadocUtilities.TagHandle tagHandle, ElementHandle elementHandle, FileObject fileObject, SourceVersion sourceVersion) {
        this.tagName = string;
        this.tagHandle = tagHandle;
        this.handle = elementHandle;
        this.file = fileObject;
        this.spec = sourceVersion;
    }

    public String getText() {
        return NbBundle.getMessage(JavadocHintProvider.class, (String)"REMOVE_TAG_HINT", (Object)this.tagName);
    }

    public ChangeInfo implement() {
        return this.implement(true);
    }

    private void prepareRemoveTag(final CompilationInfo compilationInfo, Element element) throws IOException, BadLocationException {
        final Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
        if (doc != null) {
            final Tag tag = this.tagHandle.resolve(doc);
            if (tag == null) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoveTagFix.access$002(RemoveTagFix.this, JavadocUtilities.findTagBounds(compilationInfo, RemoveTagFix.this.doc, tag));
                        Position[] positionArray = JavadocUtilities.findDocBounds(compilationInfo, RemoveTagFix.this.doc, doc);
                        RemoveTagFix.access$002(RemoveTagFix.this, RemoveTagFix.this.expand2LineBounds(RemoveTagFix.this.doc, RemoveTagFix.this.tagBounds, positionArray));
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                    }
                }
            });
        }
    }

    private void removeTag(final Indent indent) throws BadLocationException {
        if (this.tagBounds == null || this.doc == null) {
            return;
        }
        NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RemoveTagFix.this.doc.remove(RemoveTagFix.this.tagBounds[0].getOffset(), RemoveTagFix.this.tagBounds[1].getOffset() - RemoveTagFix.this.tagBounds[0].getOffset());
                    if (indent != null) {
                        indent.reindent(RemoveTagFix.this.tagBounds[1].getOffset());
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement(boolean bl) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        Indent indent = null;
        try {
            javaSource.runModificationTask((Task)this).commit();
            Indent indent2 = indent = this.isFormattingTouched ? Indent.get((Document)this.doc) : null;
            if (indent != null) {
                indent.lock();
            }
            this.removeTag(indent);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
        }
        catch (IOException iOException) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        finally {
            if (indent != null) {
                indent.unlock();
            }
        }
        return null;
    }

    public void cancel() {
    }

    public void run(WorkingCopy workingCopy) throws Exception {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        Element element = this.handle.resolve((CompilationInfo)workingCopy);
        Tree tree = null;
        if (element != null) {
            tree = workingCopy.getTrees().getTree(element);
        }
        this.doc = workingCopy.getDocument();
        if (tree != null && this.doc != null) {
            this.prepareRemoveTag((CompilationInfo)workingCopy, element);
        }
    }

    private static CharSequence getCharSequence(Document document, int n, int n2) throws BadLocationException {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            charSequence = document.getText(n, n2 - n + 1);
        }
        return charSequence;
    }

    private Position[] expand2LineBounds(Document document, Position[] positionArray, Position[] positionArray2) throws BadLocationException {
        int n;
        int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)positionArray2[0].getOffset());
        int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)positionArray2[1].getOffset());
        int n4 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)positionArray[0].getOffset());
        int n5 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)positionArray[0].getOffset());
        CharSequence charSequence = RemoveTagFix.getCharSequence(document, positionArray2[0].getOffset(), positionArray2[1].getOffset());
        if (n2 != n4 && (n = RemoveTagFix.findLineHead(charSequence, positionArray[0].getOffset(), positionArray2[0].getOffset())) != positionArray[0].getOffset()) {
            positionArray[0] = document.createPosition(n);
            boolean bl = this.isFormattingTouched = n4 == n3;
        }
        if (n3 != n5 && n2 != n4 && (n = RemoveTagFix.findLineTail(charSequence, positionArray[0].getOffset(), positionArray[1].getOffset(), positionArray2[1].getOffset())) != positionArray[1].getOffset()) {
            positionArray[1] = document.createPosition(n);
        }
        return positionArray;
    }

    private static int findLineHead(CharSequence charSequence, int n, int n2) {
        for (int i = n; i > n2; --i) {
            char c = charSequence.charAt(i);
            if (c != '\n') continue;
            return i + 1;
        }
        return n;
    }

    private static int findLineTail(CharSequence charSequence, int n, int n2, int n3) {
        if (charSequence.charAt(n2) != '@') {
            for (int i = n2; i < n3; ++i) {
                char c = charSequence.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
        } else {
            for (int i = n2 - 1; i > n; --i) {
                char c = charSequence.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
        }
        return n2;
    }

    static /* synthetic */ Position[] access$002(RemoveTagFix removeTagFix, Position[] positionArray) {
        removeTagFix.tagBounds = positionArray;
        return positionArray;
    }
}

