/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.tree.ConfigurationFactory;
import org.netbeans.modules.cnd.discovery.wizard.tree.FileConfigurationNode;
import org.netbeans.modules.cnd.discovery.wizard.tree.FolderConfigurationNode;
import org.netbeans.modules.cnd.discovery.wizard.tree.IncludesListModel;
import org.netbeans.modules.cnd.discovery.wizard.tree.MacrosListModel;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationImpl;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationNode;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SelectConfigurationPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(SelectConfigurationPanel.class.getName(), 1);
    private SelectConfigurationWizard wizard;
    private String oldConsolidation;
    private boolean showResulting;
    private boolean wasTerminated = false;
    private boolean isStoped = false;
    private JTree configurationTree;
    private JCheckBox includeInherate;
    private JList includesList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JCheckBox macroInherate;
    private JList macrosList;
    private JCheckBox showInherited;

    public SelectConfigurationPanel(SelectConfigurationWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.configurationTree.getSelectionModel().setSelectionMode(1);
        this.addListeners();
        this.clearListModels();
    }

    private void addListeners() {
        this.configurationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SelectConfigurationPanel.this.updateListModels();
            }
        });
        this.showInherited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectConfigurationPanel.this.showResulting = SelectConfigurationPanel.this.showInherited.isSelected();
                SelectConfigurationPanel.this.updateListModels();
            }
        });
    }

    private void updateListModels() {
        TreePath path = this.configurationTree.getSelectionPath();
        if (path != null) {
            Object selected = path.getLastPathComponent();
            if (selected instanceof ProjectConfigurationNode) {
                ProjectConfigurationNode node = (ProjectConfigurationNode)selected;
                this.includesList.setModel(new IncludesListModel(node.getProject(), this.showResulting));
                this.macrosList.setModel(new MacrosListModel(node.getProject(), this.showResulting));
                this.includeInherate.setSelected(false);
                this.macroInherate.setSelected(false);
            } else if (selected instanceof FolderConfigurationNode) {
                FolderConfigurationNode node = (FolderConfigurationNode)selected;
                this.includesList.setModel(new IncludesListModel(node.getFolder(), this.showResulting));
                this.macrosList.setModel(new MacrosListModel(node.getFolder(), this.showResulting));
                this.includeInherate.setSelected(node.isCheckedInclude());
                this.macroInherate.setSelected(node.isCheckedMacro());
            } else if (selected instanceof FileConfigurationNode) {
                FileConfigurationNode node = (FileConfigurationNode)selected;
                this.includesList.setModel(new IncludesListModel(node.getFile(), this.showResulting));
                this.macrosList.setModel(new MacrosListModel(node.getFile(), this.showResulting));
                this.includeInherate.setSelected(node.isCheckedInclude());
                this.macroInherate.setSelected(node.isCheckedMacro());
            } else {
                this.clearListModels();
            }
        } else {
            this.clearListModels();
        }
    }

    private void clearListModels() {
        this.includesList.setModel(new EmptyListModel());
        this.macrosList.setModel(new EmptyListModel());
        this.includeInherate.setSelected(false);
        this.macroInherate.setSelected(false);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.configurationTree = new JTree();
        this.jPanel2 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.includesList = new JList();
        this.includeInherate = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.macrosList = new JList();
        this.macroInherate = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.showInherited = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 400));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.configurationTree);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("TreeConfigurationTitle"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.configurationTree.setRootVisible(false);
        this.configurationTree.setShowsRootHandles(true);
        this.jScrollPane1.setViewportView(this.configurationTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setOrientation(0);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.includesList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("InludePathsListTitle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.includesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.includeInherate, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("InheriteParentIncludePathsText"));
        this.includeInherate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.includeInherate.setEnabled(false);
        this.includeInherate.setFocusable(false);
        this.includeInherate.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.includeInherate, gridBagConstraints);
        this.jSplitPane2.setTopComponent(this.jPanel3);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.macrosList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("UserMacrosListTitle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.macrosList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.macroInherate, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("InheriteParentMacrosText"));
        this.macroInherate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.macroInherate.setEnabled(false);
        this.macroInherate.setFocusable(false);
        this.macroInherate.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.macroInherate, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel4);
        this.jPanel2.add((Component)this.jSplitPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.add((Component)this.jSplitPane1, "Center");
        this.jPanel5.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.showInherited, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("ShowInheritedConfigurationName"));
        this.showInherited.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showInherited.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel5.add((Component)this.showInherited, gridBagConstraints);
        this.add((Component)this.jPanel5, "South");
    }

    private static String getString(String key) {
        return NbBundle.getBundle(SelectConfigurationPanel.class).getString(key);
    }

    private Icon getLoadingIcon() {
        String path = "org/netbeans/modules/cnd/discovery/wizard/resources/waitNode.gif";
        Image image = ImageUtilities.loadImage((String)path);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    void read(DiscoveryDescriptor wizardDescriptor) {
        String consolidation = wizardDescriptor.getLevel();
        boolean changedConsolidation = false;
        if (!consolidation.equals(this.oldConsolidation)) {
            this.oldConsolidation = consolidation;
            changedConsolidation = true;
        }
        if (wizardDescriptor.isInvokeProvider() || this.wasTerminated) {
            wizardDescriptor.setConfigurations(null);
            ConfigurationTreeModel model = new ConfigurationTreeModel();
            DefaultMutableTreeNode loading = new DefaultMutableTreeNode(SelectConfigurationPanel.getString("LoadingRootText"));
            ((DefaultMutableTreeNode)model.getRoot()).add(loading);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            this.configurationTree.setCellRenderer(renderer);
            renderer.setLeafIcon(this.getLoadingIcon());
            this.configurationTree.setModel(model);
            AnalyzingTask task = new AnalyzingTask(wizardDescriptor);
            RP.post((Runnable)task);
            this.isStoped = false;
            this.wasTerminated = true;
        } else if (changedConsolidation) {
            List<ProjectConfiguration> projectConfigurations = wizardDescriptor.getConfigurations();
            if (projectConfigurations != null) {
                for (ProjectConfiguration project : projectConfigurations) {
                    SelectConfigurationPanel.consolidateModel(project, consolidation);
                }
            }
            this.updateListModels();
        }
    }

    public static void consolidateModel(ProjectConfiguration project, String level) {
        if ("project".equals(level)) {
            ConfigurationFactory.consolidateProject((ProjectConfigurationImpl)project);
        } else if ("folder".equals(level)) {
            ConfigurationFactory.consolidateFolder((ProjectConfigurationImpl)project);
        } else if ("file".equals(level)) {
            ConfigurationFactory.consolidateFile((ProjectConfigurationImpl)project);
        }
    }

    public static void buildModel(final DiscoveryDescriptor wizardDescriptor) {
        String rootFolder = wizardDescriptor.getRootFolder();
        DiscoveryProvider provider = wizardDescriptor.getProvider();
        String consolidation = wizardDescriptor.getLevel();
        assert (consolidation != null);
        List<Configuration> configs = provider.analyze(new ProjectProxy(){

            @Override
            public boolean createSubProjects() {
                return false;
            }

            @Override
            public Project getProject() {
                return wizardDescriptor.getProject();
            }

            @Override
            public String getMakefile() {
                return null;
            }

            @Override
            public String getSourceRoot() {
                return wizardDescriptor.getRootFolder();
            }

            @Override
            public String getExecutable() {
                return wizardDescriptor.getBuildResult();
            }

            @Override
            public String getWorkingFolder() {
                return null;
            }
        }, new MyProgress());
        ArrayList<ProjectConfiguration> projectConfigurations = new ArrayList<ProjectConfiguration>();
        ArrayList<String> includedFiles = new ArrayList<String>();
        wizardDescriptor.setIncludedFiles(includedFiles);
        HashMap<String, AtomicInteger> compilers = new HashMap<String, AtomicInteger>();
        for (Configuration conf : configs) {
            includedFiles.addAll(conf.getIncludedFiles());
            List<ProjectProperties> langList = conf.getProjectConfiguration();
            Iterator<ProjectProperties> it2 = langList.iterator();
            while (it2.hasNext()) {
                ProjectConfigurationImpl project = ConfigurationFactory.makeRoot(it2.next(), rootFolder);
                SelectConfigurationPanel.consolidateModel(project, consolidation);
                projectConfigurations.add(project);
            }
            for (SourceFileProperties source : conf.getSourcesConfiguration()) {
                String compiler = source.getCompilerName();
                if (compiler == null) continue;
                AtomicInteger count = (AtomicInteger)compilers.get(compiler);
                if (count == null) {
                    count = new AtomicInteger();
                    compilers.put(compiler, count);
                }
                count.incrementAndGet();
            }
        }
        wizardDescriptor.setInvokeProvider(false);
        wizardDescriptor.setConfigurations(projectConfigurations);
        int max = 0;
        String top = "";
        for (Map.Entry entry : compilers.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= max) continue;
            max = ((AtomicInteger)entry.getValue()).get();
            top = (String)entry.getKey();
        }
        wizardDescriptor.setCompilerName(top);
    }

    private void creteTreeModel(DiscoveryDescriptor wizardDescriptor) {
        ConfigurationTreeModel model = new ConfigurationTreeModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        List<ProjectConfiguration> projectConfigurations = wizardDescriptor.getConfigurations();
        if (projectConfigurations != null) {
            for (ProjectConfiguration project : projectConfigurations) {
                root.add(new ProjectConfigurationNode((ProjectConfigurationImpl)project));
            }
        }
        this.configurationTree.setCellRenderer(new DefaultTreeCellRenderer());
        this.configurationTree.setModel(model);
    }

    void store(DiscoveryDescriptor wizardDescriptor) {
        DiscoveryProvider provider = wizardDescriptor.getProvider();
        List<ProjectConfiguration> projectConfigurations = wizardDescriptor.getConfigurations();
        if (provider != null && this.wasTerminated) {
            this.isStoped = true;
            provider.stop();
        }
    }

    boolean isValid(DiscoveryDescriptor settings) {
        List<ProjectConfiguration> projectConfigurations = settings.getConfigurations();
        if (projectConfigurations == null || projectConfigurations.isEmpty()) {
            return false;
        }
        return projectConfigurations.get(0).getFiles().size() > 0;
    }

    public static class MyProgress
    implements Progress {
        private ProgressHandle handle;
        private int done;

        @Override
        public void start() {
            this.start(0);
        }

        @Override
        public void start(int length) {
            if (this.handle != null) {
                this.handle.finish();
            }
            this.handle = ProgressHandleFactory.createHandle((String)SelectConfigurationPanel.getString("AnalyzingProjectProgress"));
            this.handle.start(length);
            this.done = 0;
        }

        @Override
        public void increment() {
            if (this.handle != null) {
                ++this.done;
                this.handle.progress(this.done);
            }
        }

        @Override
        public void done() {
            if (this.handle != null) {
                this.handle.finish();
                this.handle = null;
            }
        }
    }

    private class AnalyzingTask
    extends Thread {
        private DiscoveryDescriptor wizardDescriptor;

        public AnalyzingTask(DiscoveryDescriptor wizardDescriptor) {
            this.wizardDescriptor = wizardDescriptor;
        }

        @Override
        public void run() {
            SelectConfigurationPanel.buildModel(this.wizardDescriptor);
            SelectConfigurationPanel.this.creteTreeModel(this.wizardDescriptor);
            SelectConfigurationPanel.this.wizard.stateChanged(null);
            if (!SelectConfigurationPanel.this.isStoped) {
                SelectConfigurationPanel.this.wasTerminated = false;
            }
        }
    }

    public static class EmptyListModel
    extends AbstractListModel {
        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Object getElementAt(int i) {
            return null;
        }
    }

    private static class ConfigurationTreeModel
    extends DefaultTreeModel {
        public ConfigurationTreeModel() {
            super(new DefaultMutableTreeNode("Root"));
        }
    }
}

