/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfpath.api.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsfpath.api.classpath.ClassLoaderSupport;
import org.netbeans.modules.gsfpath.classpath.ClassPathAccessor;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathProvider;
import org.netbeans.modules.gsfpath.spi.classpath.FilteringPathResourceImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class ClassPath {
    public static final String EXECUTE = "classpath/execute";
    @Deprecated
    public static final String DEBUG = "classpath/debug";
    public static final String COMPILE = "classpath/compile";
    public static final String SOURCE = "classpath/source";
    public static final String BOOT = "classpath/boot";
    public static final String PROP_ROOTS = "roots";
    public static final String PROP_ENTRIES = "entries";
    public static final String PROP_INCLUDES = "includes";
    private static final Logger LOG;
    private static final Lookup.Result<? extends ClassPathProvider> implementations;
    private final ClassPathImplementation impl;
    private FileObject[] rootsCache;
    private Map<FileObject, FilteringPathResourceImplementation> root2Filter = new WeakHashMap<FileObject, FilteringPathResourceImplementation>();
    private PropertyChangeListener pListener;
    private PropertyChangeListener weakPListener;
    private RootsListener rootsListener;
    private List<Entry> entriesCache;
    private long invalidEntries;
    private long invalidRoots;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private static final Reference<ClassLoader> EMPTY_REF;
    private Reference<ClassLoader> refClassLoader = EMPTY_REF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getRoots() {
        FileObject[] ret;
        long current;
        ClassPath classPath = this;
        synchronized (classPath) {
            if (this.rootsCache != null) {
                return this.rootsCache;
            }
            current = this.invalidRoots;
        }
        List<Entry> entries = this.entries();
        ClassPath classPath2 = this;
        synchronized (classPath2) {
            if (this.invalidRoots == current) {
                if (this.rootsCache == null || this.rootsListener == null) {
                    this.attachRootsListener();
                    this.rootsCache = this.createRoots(entries);
                }
                ret = this.rootsCache;
            } else {
                ret = this.createRoots(entries);
            }
        }
        assert (ret != null);
        return ret;
    }

    private FileObject[] createRoots(List<Entry> entries) {
        ArrayList<FileObject> l = new ArrayList<FileObject>();
        for (Entry entry : entries) {
            FileObject fo;
            RootsListener rootsListener = this.getRootsListener();
            if (rootsListener != null) {
                rootsListener.addRoot(entry.getURL());
            }
            if ((fo = entry.getRoot()) == null) continue;
            l.add(fo);
            this.root2Filter.put(fo, entry.filter);
        }
        return l.toArray(new FileObject[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> entries() {
        List<Entry> result;
        long current;
        ClassPath classPath = this;
        synchronized (classPath) {
            if (this.entriesCache != null) {
                return this.entriesCache;
            }
            current = this.invalidEntries;
        }
        List<? extends PathResourceImplementation> resources = this.impl.getResources();
        ClassPath classPath2 = this;
        synchronized (classPath2) {
            if (this.invalidEntries == current) {
                if (this.entriesCache == null) {
                    this.entriesCache = this.createEntries(resources);
                }
                result = this.entriesCache;
            } else {
                result = this.createEntries(resources);
            }
        }
        assert (result != null);
        return result;
    }

    private List<Entry> createEntries(List<? extends PathResourceImplementation> resources) {
        if (resources == null) {
            return Collections.emptyList();
        }
        ArrayList<Entry> cache = new ArrayList<Entry>();
        for (PathResourceImplementation pathResourceImplementation : resources) {
            pathResourceImplementation.removePropertyChangeListener(this.weakPListener);
            this.weakPListener = WeakListeners.propertyChange((PropertyChangeListener)this.pListener, (Object)pathResourceImplementation);
            pathResourceImplementation.addPropertyChangeListener(this.weakPListener);
            for (URL root : pathResourceImplementation.getRoots()) {
                cache.add(new Entry(root, pathResourceImplementation instanceof FilteringPathResourceImplementation ? (FilteringPathResourceImplementation)pathResourceImplementation : null));
            }
        }
        return Collections.unmodifiableList(cache);
    }

    private ClassPath(ClassPathImplementation impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
        this.pListener = new SPIListener();
        this.weakPListener = WeakListeners.propertyChange((PropertyChangeListener)this.pListener, (Object)this.impl);
        this.impl.addPropertyChangeListener(this.weakPListener);
    }

    public final FileObject findResource(String resourceName) {
        return this.findResourceImpl(this.getRoots(), new int[]{0}, ClassPath.parseResourceName(resourceName));
    }

    public final List<FileObject> findAllResources(String resourceName) {
        FileObject[] roots = this.getRoots();
        ArrayList<FileObject> l = new ArrayList<FileObject>(roots.length);
        int[] idx = new int[]{0};
        String[] namec = ClassPath.parseResourceName(resourceName);
        while (idx[0] < roots.length) {
            FileObject f = this.findResourceImpl(roots, idx, namec);
            if (f == null) continue;
            l.add(f);
        }
        return l;
    }

    public final String getResourceName(FileObject f) {
        return this.getResourceName(f, '/', true);
    }

    public final String getResourceName(FileObject f, char dirSep, boolean includeExt) {
        int index;
        FileObject owner = this.findOwnerRoot(f);
        if (owner == null) {
            return null;
        }
        String partName = FileUtil.getRelativePath((FileObject)owner, (FileObject)f);
        assert (partName != null);
        if (!includeExt && (index = partName.lastIndexOf(46)) >= 0 && index > partName.lastIndexOf(47)) {
            partName = partName.substring(0, index);
        }
        if (dirSep != '/') {
            partName = partName.replace('/', dirSep);
        }
        return partName;
    }

    public final FileObject findOwnerRoot(FileObject resource) {
        FileObject[] roots = this.getRoots();
        HashSet<FileObject> rootsSet = new HashSet<FileObject>(Arrays.asList(roots));
        for (FileObject f = resource; f != null; f = f.getParent()) {
            if (!rootsSet.contains(f)) continue;
            return f;
        }
        return null;
    }

    public final boolean contains(FileObject f) {
        FileObject root = this.findOwnerRoot(f);
        if (root == null) {
            return false;
        }
        FilteringPathResourceImplementation filter = this.root2Filter.get(root);
        if (filter == null) {
            return true;
        }
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)f);
        assert (path != null) : "could not find " + f + " in " + root;
        if (f.isFolder()) {
            path = path + "/";
        }
        try {
            return filter.includes(root.getURL(), path);
        }
        catch (FileStateInvalidException x) {
            throw new AssertionError((Object)x);
        }
    }

    public final boolean isResourceVisible(FileObject resource) {
        String resourceName = this.getResourceName(resource);
        if (resourceName == null) {
            return false;
        }
        return this.findResource(resourceName) == resource;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.attachRootsListener();
        this.propSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    public static ClassPath getClassPath(FileObject f, String id) {
        if (f == null) {
            Thread.dumpStack();
            return null;
        }
        for (ClassPathProvider impl : implementations.allInstances()) {
            ClassPath cp = impl.findClassPath(f, id);
            if (cp == null) continue;
            LOG.log(Level.FINE, "getClassPath({0}, {1}) -> {2} from {3}", new Object[]{f, id, cp, impl});
            return cp;
        }
        LOG.log(Level.FINE, "getClassPath({0}, {1}) -> nil", new Object[]{f, id});
        return null;
    }

    final void firePropertyChange(String what, Object oldV, Object newV, Object propagationId) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, what, oldV, newV);
        event.setPropagationId(propagationId);
        this.propSupport.firePropertyChange(event);
    }

    public String toString() {
        return "ClassPath" + this.entries();
    }

    private void attachRootsListener() {
        if (this.rootsListener == null) {
            assert (this.rootsCache == null);
            this.rootsListener = new RootsListener(this);
        }
    }

    private static String[] parseResourceName(String name) {
        int pos;
        ArrayList<String> parsed = new ArrayList<String>(name.length() / 4);
        char[] chars = name.toCharArray();
        int dotPos = -1;
        int startPos = 0;
        block4: for (pos = 0; pos < chars.length; ++pos) {
            char ch = chars[pos];
            switch (ch) {
                case '.': {
                    dotPos = pos;
                    continue block4;
                }
                case '/': {
                    if (dotPos != -1) {
                        parsed.add(name.substring(startPos, dotPos));
                        parsed.add(name.substring(dotPos + 1, pos));
                    } else {
                        parsed.add(name.substring(startPos, pos));
                        parsed.add(null);
                    }
                    startPos = pos + 1;
                    dotPos = -1;
                }
            }
        }
        if (pos > startPos) {
            if (dotPos != -1) {
                parsed.add(name.substring(startPos, dotPos));
                parsed.add(name.substring(dotPos + 1, pos));
            } else {
                parsed.add(name.substring(startPos, pos));
                parsed.add(null);
            }
        }
        if (parsed.size() % 2 != 0) {
            System.err.println("parsed size is not even!!");
            System.err.println("input = " + name);
        }
        return parsed.toArray(new String[parsed.size()]);
    }

    private static FileObject findPath(FileObject parent, String[] nameParts) {
        for (int i = 0; i < nameParts.length && parent != null; i += 2) {
            FileObject child = parent.getFileObject(nameParts[i], nameParts[i + 1]);
            parent = child;
        }
        return parent;
    }

    private FileObject findResourceImpl(FileObject[] roots, int[] rootIndex, String[] nameComponents) {
        int ridx;
        FileObject f = null;
        for (ridx = rootIndex[0]; ridx < roots.length && f == null; ++ridx) {
            f = ClassPath.findPath(roots[ridx], nameComponents);
            FilteringPathResourceImplementation filter = this.root2Filter.get(roots[ridx]);
            if (filter == null) continue;
            try {
                if (f == null) continue;
                String path = FileUtil.getRelativePath((FileObject)roots[ridx], (FileObject)f);
                assert (path != null);
                if (f.isFolder()) {
                    path = path + "/";
                }
                if (filter.includes(roots[ridx].getURL(), path)) continue;
                f = null;
                continue;
            }
            catch (FileStateInvalidException x) {
                throw new AssertionError((Object)x);
            }
        }
        rootIndex[0] = ridx;
        return f;
    }

    synchronized void resetClassLoader(ClassLoader cl) {
        if (this.refClassLoader.get() == cl) {
            this.refClassLoader = EMPTY_REF;
        }
    }

    public final synchronized ClassLoader getClassLoader(boolean cache) {
        ClassLoader o = this.refClassLoader.get();
        if (!cache || o == null) {
            o = ClassLoaderSupport.create(this);
            this.refClassLoader = new SoftReference<ClassLoader>(o);
        }
        return o;
    }

    private synchronized RootsListener getRootsListener() {
        return this.rootsListener;
    }

    static /* synthetic */ FileObject[] access$702(ClassPath x0, FileObject[] x1) {
        x0.rootsCache = x1;
        return x1;
    }

    static {
        ClassPathAccessor.DEFAULT = new ClassPathAccessor(){

            @Override
            public ClassPath createClassPath(ClassPathImplementation spiClasspath) {
                return new ClassPath(spiClasspath);
            }

            @Override
            public ClassPathImplementation getClassPathImpl(ClassPath cp) {
                return cp == null ? null : cp.impl;
            }
        };
        LOG = Logger.getLogger(ClassPath.class.getName());
        implementations = Lookup.getDefault().lookupResult(ClassPathProvider.class);
        EMPTY_REF = new SoftReference<Object>(null);
    }

    private static class RootsListener
    extends WeakReference<ClassPath>
    implements FileChangeListener,
    Runnable {
        private boolean initialized;
        private Set<String> roots = new HashSet<String>();

        private RootsListener(ClassPath owner) {
            super(owner, Utilities.activeReferenceQueue());
        }

        public void addRoot(URL url) {
            String path;
            if (!this.isInitialized()) {
                FileUtil.addFileChangeListener((FileChangeListener)this);
                this.setInitialized(true);
            }
            if ("jar".equals(url.getProtocol())) {
                url = FileUtil.getArchiveFile((URL)url);
            }
            if ((path = url.getPath()).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.roots.add(path);
        }

        public void removeRoot(URL url) {
            String path;
            if ("jar".equals(url.getProtocol())) {
                url = FileUtil.getArchiveFile((URL)url);
            }
            if ((path = url.getPath()).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.roots.remove(path);
        }

        public void removeAllRoots() {
            this.roots.clear();
            FileUtil.removeFileChangeListener((FileChangeListener)this);
            this.initialized = false;
        }

        public void fileFolderCreated(FileEvent fe) {
            this.processEvent(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.processEvent(fe);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fe) {
            ClassPath cp;
            if (!this.isInitialized()) {
                return;
            }
            String path = RootsListener.getPath(fe.getFile());
            if (this.roots.contains(path) && (cp = (ClassPath)this.get()) != null) {
                ClassPath classPath = cp;
                synchronized (classPath) {
                    ClassPath.access$702(cp, null);
                    cp.invalidRoots++;
                    this.removeAllRoots();
                }
                cp.firePropertyChange(ClassPath.PROP_ROOTS, null, null, null);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.processEvent(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.processEvent((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        public void run() {
            if (this.isInitialized()) {
                FileUtil.removeFileChangeListener((FileChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvent(FileEvent fe) {
            if (!this.isInitialized()) {
                return;
            }
            String path = RootsListener.getPath(fe.getFile());
            if (path == null) {
                return;
            }
            ClassPath cp = (ClassPath)this.get();
            if (cp == null) {
                return;
            }
            boolean fire = false;
            ClassPath classPath = cp;
            synchronized (classPath) {
                for (String rootPath : this.roots) {
                    if (!rootPath.startsWith(path)) continue;
                    ClassPath.access$702(cp, null);
                    cp.invalidRoots++;
                    this.removeAllRoots();
                    fire = true;
                    break;
                }
            }
            if (fire) {
                cp.firePropertyChange(ClassPath.PROP_ROOTS, null, null, null);
            }
        }

        private static String getPath(FileObject fo) {
            if (fo == null) {
                return null;
            }
            try {
                URL url = fo.getURL();
                String path = url.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                return path;
            }
            catch (FileStateInvalidException e) {
                Exceptions.printStackTrace((Throwable)e);
                return null;
            }
        }

        private synchronized boolean isInitialized() {
            return this.initialized;
        }

        private synchronized void setInitialized(boolean newValue) {
            this.initialized = newValue;
        }
    }

    private class SPIListener
    implements PropertyChangeListener {
        private Object propIncludesPropagationId;

        private SPIListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("resources".equals(prop) || ClassPath.PROP_ROOTS.equals(prop)) {
                ClassPath classPath = ClassPath.this;
                synchronized (classPath) {
                    if (ClassPath.this.rootsListener != null) {
                        ClassPath.this.rootsListener.removeAllRoots();
                    }
                    ClassPath.this.entriesCache = null;
                    ClassPath.access$702(ClassPath.this, null);
                    ClassPath.this.invalidEntries++;
                    ClassPath.this.invalidRoots++;
                }
                ClassPath.this.firePropertyChange(ClassPath.PROP_ENTRIES, null, null, null);
                ClassPath.this.firePropertyChange(ClassPath.PROP_ROOTS, null, null, null);
            } else if (ClassPath.PROP_INCLUDES.equals(prop)) {
                boolean fire;
                SPIListener sPIListener = this;
                synchronized (sPIListener) {
                    Object object = evt.getPropagationId();
                    fire = this.propIncludesPropagationId == null || !this.propIncludesPropagationId.equals(object);
                    this.propIncludesPropagationId = object;
                }
                if (fire) {
                    ClassPath.this.firePropertyChange(ClassPath.PROP_INCLUDES, null, null, evt.getPropagationId());
                }
            }
            if ("resources".equals(prop)) {
                List<? extends PathResourceImplementation> resources = ClassPath.this.impl.getResources();
                if (resources == null) {
                    LOG.warning("ClassPathImplementation.getResources cannot return null; impl class: " + ClassPath.this.impl.getClass().getName());
                    return;
                }
                for (PathResourceImplementation pathResourceImplementation : resources) {
                    pathResourceImplementation.removePropertyChangeListener(ClassPath.this.weakPListener);
                    pathResourceImplementation.addPropertyChangeListener(ClassPath.this.weakPListener = WeakListeners.propertyChange((PropertyChangeListener)ClassPath.this.pListener, (Object)pathResourceImplementation));
                }
            }
        }
    }

    public final class Entry {
        private final URL url;
        private FileObject root;
        private IOException lastError;
        private FilteringPathResourceImplementation filter;

        public ClassPath getDefiningClassPath() {
            return ClassPath.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject getRoot() {
            Entry entry = this;
            synchronized (entry) {
                if (this.root != null && this.root.isValid()) {
                    return this.root;
                }
            }
            FileObject _root = URLMapper.findFileObject((URL)this.url);
            Entry entry2 = this;
            synchronized (entry2) {
                if (this.root == null || !this.root.isValid()) {
                    if (_root == null) {
                        this.lastError = new IOException(MessageFormat.format("The package root {0} does not exist or can not be read.", this.url));
                        return null;
                    }
                    if (_root.isData()) {
                        throw new IllegalArgumentException("Invalid ClassPath root: " + this.url + ". The root must be a folder.");
                    }
                    this.root = _root;
                }
                return this.root;
            }
        }

        public boolean isValid() {
            FileObject root = this.getRoot();
            return root != null && root.isValid();
        }

        public IOException getError() {
            IOException error = this.lastError;
            this.lastError = null;
            return error;
        }

        public URL getURL() {
            return this.url;
        }

        public boolean includes(String resource) {
            return this.filter == null || this.filter.includes(this.url, resource);
        }

        public boolean includes(URL file) {
            URI relative;
            if (!file.toExternalForm().startsWith(this.url.toExternalForm())) {
                throw new IllegalArgumentException(file + " not in " + this.url);
            }
            try {
                relative = this.url.toURI().relativize(file.toURI());
            }
            catch (URISyntaxException x) {
                throw new AssertionError((Object)x);
            }
            assert (!relative.isAbsolute()) : "could not locate " + file + " in " + this.url;
            return this.filter == null || this.filter.includes(this.url, relative.toString());
        }

        public boolean includes(FileObject file) {
            FileObject root = this.getRoot();
            if (root == null) {
                throw new IllegalArgumentException("no root in " + this.url);
            }
            String path = FileUtil.getRelativePath((FileObject)root, (FileObject)file);
            if (path == null) {
                throw new IllegalArgumentException(file + " not in " + root);
            }
            if (file.isFolder()) {
                path = path + "/";
            }
            return this.filter == null || this.filter.includes(this.url, path);
        }

        Entry(URL url, FilteringPathResourceImplementation filter) {
            if (url == null) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            this.filter = filter;
        }

        public String toString() {
            return "Entry[" + this.url + "]";
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                return Utilities.compareObjects((Object)((Entry)other).url, (Object)this.url);
            }
            return false;
        }

        public int hashCode() {
            return this.url == null ? 0 : this.url.hashCode();
        }
    }
}

