/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BuildExtension {
    private BuildExtension() {
    }

    static void copyTemplate(Project proj) throws IOException {
        FileObject templateFO;
        FileObject projDir = proj.getProjectDirectory();
        FileObject jnlpBuildFile = projDir.getFileObject("nbproject/extendArchiveGF.xml");
        if (jnlpBuildFile == null && (templateFO = FileUtil.getConfigFile((String)"Templates/SunResources/extendArchiveGF.xml")) != null) {
            FileUtil.copyFile((FileObject)templateFO, (FileObject)projDir.getFileObject("nbproject"), (String)"extendArchiveGF");
        }
    }

    static void removeTemplate(Project proj) throws IOException {
        FileObject projDir = proj.getProjectDirectory();
        FileObject jnlpBuildFile = projDir.getFileObject("nbproject/extendArchiveGF.xml");
        if (jnlpBuildFile != null) {
            jnlpBuildFile.delete();
        }
    }

    static void extendBuildXml(Project proj, String target) throws IOException {
        FileObject projDir = proj.getProjectDirectory();
        FileObject buildXmlFO = projDir.getFileObject("build.xml");
        if (null == buildXmlFO) {
            return;
        }
        File buildXmlFile = FileUtil.toFile((FileObject)buildXmlFO);
        try {
            XMLUtil.parse((InputSource)new InputSource(buildXmlFile.toURI().toString()), (boolean)false, (boolean)true, null, null);
        }
        catch (SAXException ex) {
            Logger.getLogger(BuildExtension.class.getName()).log(Level.FINER, null, ex);
            return;
        }
        FileObject jnlpBuildFile = projDir.getFileObject("nbproject/extendArchiveGF.xml");
        AntBuildExtender extender = (AntBuildExtender)proj.getLookup().lookup(AntBuildExtender.class);
        if (extender != null) {
            if (extender.getExtension("gfarchiveextend") == null) {
                AntBuildExtender.Extension ext = extender.addExtension("gfarchiveextend", jnlpBuildFile);
                ext.addDependency(target, "-extend-archive");
            }
            ProjectManager.getDefault().saveProject(proj);
        } else {
            Logger.getLogger(BuildExtension.class.getName()).log(Level.FINER, "Trying to include GF build snippet in project type that doesn't support AntBuildExtender API contract.");
        }
    }

    static void abbreviateBuildXml(Project proj, String target) throws IOException {
        FileObject projDir = proj.getProjectDirectory();
        FileObject buildXmlFO = projDir.getFileObject("build.xml");
        if (null == buildXmlFO) {
            return;
        }
        File buildXmlFile = FileUtil.toFile((FileObject)buildXmlFO);
        try {
            XMLUtil.parse((InputSource)new InputSource(buildXmlFile.toURI().toString()), (boolean)false, (boolean)true, null, null);
        }
        catch (SAXException ex) {
            Logger.getLogger(BuildExtension.class.getName()).log(Level.FINER, null, ex);
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(BuildExtension.class.getName()).log(Level.FINER, null, ex);
            return;
        }
        AntBuildExtender extender = (AntBuildExtender)proj.getLookup().lookup(AntBuildExtender.class);
        if (extender != null) {
            AntBuildExtender.Extension ext = extender.getExtension("gfarchiveextend");
            if (ext != null) {
                try {
                    ext.removeDependency(target, "-extend-archive");
                }
                catch (IllegalArgumentException iae) {
                    Logger.getLogger(BuildExtension.class.getName()).log(Level.FINER, null, iae);
                }
                extender.removeExtension("gfarchiveextend");
            }
            ProjectManager.getDefault().saveProject(proj);
        } else if (null == extender) {
            Logger.getLogger(BuildExtension.class.getName()).log(Level.FINER, "Trying to remove GF build snippet in project type that doesn't support AntBuildExtender API contract.");
        }
    }
}

