/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubySourceRootsUi;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerSources
extends JPanel
implements HelpCtx.Provider {
    private String originalEncoding;
    private boolean notified;
    private final RubyProjectProperties uiProperties;
    private JButton addSourceRoot;
    private JButton addTestRoot;
    private JButton downSourceRoot;
    private JButton downTestRoot;
    private JComboBox encoding;
    private JLabel encodingLabel;
    private JPanel encodingPanel;
    private JLabel prjFolderLabel;
    private JTextField projectLocation;
    private JButton removeSourceRoot;
    private JButton removeTestRoot;
    private JLabel sourceFolderLabel;
    private JTable sourceRoots;
    private JScrollPane sourceSP;
    private JLabel testFolderLabel;
    private JTable testRoots;
    private JScrollPane testSP;
    private JButton upSourceRoot;
    private JButton upTestRoot;

    public CustomizerSources(RubyProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.sourceSP.getViewport().setBackground(this.sourceRoots.getBackground());
        this.testSP.getViewport().setBackground(this.testRoots.getBackground());
        this.sourceRoots.setModel(uiProperties.sourceRootsModel);
        this.testRoots.setModel(uiProperties.testRootsModel);
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        this.testRoots.getTableHeader().setReorderingAllowed(false);
        RubyProject project = uiProperties.getRubyProject();
        FileObject projectFolder = project.getProjectDirectory();
        File pf = FileUtil.toFile((FileObject)projectFolder);
        this.projectLocation.setText(pf == null ? "" : pf.getPath());
        RubySourceRootsUi.EditMediator emSR = RubySourceRootsUi.registerEditMediator(project, project.getSourceRoots(), this.sourceRoots, this.addSourceRoot, this.removeSourceRoot, this.upSourceRoot, this.downSourceRoot);
        RubySourceRootsUi.EditMediator emTSR = RubySourceRootsUi.registerEditMediator(project, project.getTestSourceRoots(), this.testRoots, this.addTestRoot, this.removeTestRoot, this.upTestRoot, this.downTestRoot);
        emSR.setRelatedEditMediator(emTSR);
        emTSR.setRelatedEditMediator(emSR);
        this.originalEncoding = project.evaluator().getProperty("source.encoding");
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(ProjectCustomizer.encodingModel((String)this.originalEncoding));
        this.encoding.setRenderer(ProjectCustomizer.encodingRenderer());
        String lafid = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(lafid)) {
            this.encoding.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encoding.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    combo.setPopupVisible(false);
                }
            });
        }
        this.encoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CustomizerSources.this.handleEncodingChange();
            }
        });
    }

    private void handleEncodingChange() {
        Charset enc = (Charset)this.encoding.getSelectedItem();
        String encName = enc != null ? enc.name() : this.originalEncoding;
        if (!this.notified && encName != null && !encName.equals(this.originalEncoding)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSources.class, (String)"MSG_EncodingWarning"), 2));
            this.notified = true;
        }
        this.uiProperties.putAdditionalProperty("source.encoding", encName);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerSources.class);
    }

    private void initComponents() {
        this.prjFolderLabel = new JLabel();
        this.projectLocation = new JTextField();
        this.encodingPanel = new JPanel();
        this.encodingLabel = new JLabel();
        this.encoding = new JComboBox();
        this.sourceFolderLabel = new JLabel();
        this.sourceSP = new JScrollPane();
        this.sourceRoots = new JTable();
        this.addSourceRoot = new JButton();
        this.removeSourceRoot = new JButton();
        this.upSourceRoot = new JButton();
        this.downSourceRoot = new JButton();
        this.testFolderLabel = new JLabel();
        this.addTestRoot = new JButton();
        this.removeTestRoot = new JButton();
        this.upTestRoot = new JButton();
        this.downTestRoot = new JButton();
        this.testSP = new JScrollPane();
        this.testRoots = new JTable();
        this.prjFolderLabel.setLabelFor(this.projectLocation);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/ruby/rubyproject/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.prjFolderLabel, (String)bundle.getString("CTL_ProjectFolder"));
        this.projectLocation.setEditable(false);
        this.encodingLabel.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(CustomizerSources.class, (String)"TXT_Encoding"));
        GroupLayout encodingPanelLayout = new GroupLayout((Container)this.encodingPanel);
        this.encodingPanel.setLayout((LayoutManager)encodingPanelLayout);
        encodingPanelLayout.setHorizontalGroup((GroupLayout.Group)encodingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)encodingPanelLayout.createSequentialGroup().add((Component)this.encodingLabel).addPreferredGap(0).add((Component)this.encoding, -2, 137, -2).addContainerGap(427, Short.MAX_VALUE)));
        encodingPanelLayout.setVerticalGroup((GroupLayout.Group)encodingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)encodingPanelLayout.createParallelGroup(3).add((Component)this.encodingLabel).add((Component)this.encoding, -2, -1, -2)));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.encodingLabel.AccessibleContext.accessibleDescription"));
        this.sourceFolderLabel.setLabelFor(this.sourceRoots);
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderLabel, (String)bundle.getString("CTL_SourceRoots"));
        this.sourceRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.sourceSP.setViewportView(this.sourceRoots);
        this.sourceRoots.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_sourceRoots"));
        Mnemonics.setLocalizedText((AbstractButton)this.addSourceRoot, (String)bundle.getString("CTL_AddSourceRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeSourceRoot, (String)bundle.getString("CTL_RemoveSourceRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.upSourceRoot, (String)bundle.getString("CTL_UpSourceRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.downSourceRoot, (String)bundle.getString("CTL_DownSourceRoot"));
        this.testFolderLabel.setLabelFor(this.testRoots);
        Mnemonics.setLocalizedText((JLabel)this.testFolderLabel, (String)bundle.getString("CTL_TestRoots"));
        Mnemonics.setLocalizedText((AbstractButton)this.addTestRoot, (String)bundle.getString("CTL_AddTestRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeTestRoot, (String)bundle.getString("CTL_RemoveTestRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.upTestRoot, (String)bundle.getString("CTL_UpTestRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.downTestRoot, (String)bundle.getString("CTL_DownTestRoot"));
        this.testRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.testSP.setViewportView(this.testRoots);
        this.testRoots.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_testRoots"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.encodingPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.prjFolderLabel).addPreferredGap(0).add((Component)this.projectLocation, -1, 536, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.testSP, -1, 516, Short.MAX_VALUE).add((Component)this.sourceSP, -1, 516, Short.MAX_VALUE).add(1, (Component)this.sourceFolderLabel, -1, 516, Short.MAX_VALUE).add(1, (Component)this.testFolderLabel, -1, 516, Short.MAX_VALUE)).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.addSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.removeSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.upSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.downSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.addTestRoot, -1, -1, Short.MAX_VALUE).add((Component)this.removeTestRoot, -1, -1, Short.MAX_VALUE).add((Component)this.upTestRoot, -1, -1, Short.MAX_VALUE).add((Component)this.downTestRoot, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.prjFolderLabel).add((Component)this.projectLocation, -2, -1, -2)).add(2, 2, 2).add((Component)this.sourceFolderLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addSourceRoot).addPreferredGap(0).add((Component)this.removeSourceRoot).addPreferredGap(0).add((Component)this.upSourceRoot).addPreferredGap(0).add((Component)this.downSourceRoot)).add((Component)this.sourceSP, -2, 169, -2)).addPreferredGap(0).add((Component)this.testFolderLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addTestRoot).addPreferredGap(0).add((Component)this.removeTestRoot).addPreferredGap(0).add((Component)this.upTestRoot).addPreferredGap(0).add((Component)this.downTestRoot)).add((Component)this.testSP, -1, 182, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.encodingPanel, -2, -1, -2)));
        this.projectLocation.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_projectLocation"));
        this.addSourceRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_addSourceRoot"));
        this.removeSourceRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_removeSourceRoot"));
        this.upSourceRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_upSourceRoot"));
        this.downSourceRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_downSourceRoot"));
        this.addTestRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_addTestRoot"));
        this.removeTestRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_removeTestRoot"));
        this.upTestRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_upTestRoot"));
        this.downTestRoot.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizerSources_downTestRoot"));
    }
}

