/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;

public class ProjectPropertyExtender {
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private RakeProjectHelper antProjectHelper;
    private Set<String> wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String antArtifactPrefix;

    public ProjectPropertyExtender(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, RakeProjectHelper antProjectHelper, String[] wellKnownPaths, String libraryPrefix, String librarySuffix, String antArtifactPrefix) {
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = wellKnownPaths == null ? null : new HashSet<String>(Arrays.asList(wellKnownPaths));
        this.libraryPrefix = libraryPrefix;
        this.librarySuffix = librarySuffix;
        this.antArtifactPrefix = antArtifactPrefix;
    }

    public Iterator<Item> itemsIterator(String propertyValue) {
        return this.itemsList(propertyValue).iterator();
    }

    private boolean isWellKnownPath(String property) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(property);
    }

    public List<Item> itemsList(String propertyValue) {
        String[] pe = PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue));
        ArrayList<Item> items = new ArrayList<Item>(pe.length);
        for (int i = 0; i < pe.length; ++i) {
            Item item;
            if (this.isWellKnownPath(pe[i])) {
                item = Item.create(pe[i]);
            } else {
                String eval = this.evaluator.evaluate(pe[i]);
                File f = null;
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                item = f == null || !f.exists() ? Item.createBroken(0, pe[i]) : Item.create(f, pe[i]);
            }
            items.add(item);
        }
        return items;
    }

    public String[] encodeToStrings(Iterator<Item> classpath) {
        ArrayList<String> result = new ArrayList<String>();
        while (classpath.hasNext()) {
            Item item = classpath.next();
            String reference = null;
            switch (item.getType()) {
                case 0: {
                    reference = item.getReference();
                    if (item.isBroken() || reference != null) break;
                    File file = item.getFile();
                    reference = this.referenceHelper.createForeignFileReference(file, null);
                    break;
                }
                case 3: {
                    reference = item.getReference();
                }
            }
            if (reference == null) continue;
            result.add(reference);
        }
        String[] items = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            items[i] = i < result.size() - 1 ? (String)result.get(i) + System.getProperty("path.separator") : (String)result.get(i);
        }
        return items;
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;

        private Item(int type, Object object, String property) {
            this.type = type;
            this.object = object;
            this.property = property;
        }

        private Item(int type, Object object, URI artifactURI, String property) {
            this(type, object, property);
            this.artifactURI = artifactURI;
        }

        public static Item create(File file, String property) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(0, file, property);
        }

        public static Item create(String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, property);
        }

        public static Item createBroken(int type, String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(type, BROKEN, property);
        }

        public int getType() {
            return this.type;
        }

        public File getFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return (File)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public int hashCode() {
            int hash = this.getType();
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            switch (this.getType()) {
                case 3: {
                    hash += this.property.hashCode();
                    break;
                }
                default: {
                    hash += this.object.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object itemObject) {
            if (!(itemObject instanceof Item)) {
                return false;
            }
            Item item = (Item)itemObject;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }
    }
}

