/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;

public abstract class AbstractJasperReportsSingleFormatView
extends AbstractJasperReportsView {
    protected boolean generatesDownloadContent() {
        return !this.useWriter();
    }

    protected void renderReport(JasperPrint populatedReport, Map model, HttpServletResponse response) throws Exception {
        JRExporter exporter = this.createExporter();
        Map mergedExporterParameters = this.mergeExporterParameters(model);
        if (!CollectionUtils.isEmpty((Map)mergedExporterParameters)) {
            exporter.setParameters(mergedExporterParameters);
        }
        if (this.useWriter()) {
            this.renderReportUsingWriter(exporter, populatedReport, response);
        } else {
            this.renderReportUsingOutputStream(exporter, populatedReport, response);
        }
    }

    protected Map mergeExporterParameters(Map model) {
        HashMap mergedParameters = new HashMap();
        Map convertedExporterParameters = this.getConvertedExporterParameters();
        if (!CollectionUtils.isEmpty((Map)convertedExporterParameters)) {
            mergedParameters.putAll(convertedExporterParameters);
        }
        Iterator it = model.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!(key instanceof JRExporterParameter)) continue;
            Object value = model.get(key);
            Object convertedValue = this.convertParameterValue((JRExporterParameter)key, value);
            mergedParameters.put(key, convertedValue);
        }
        return mergedParameters;
    }

    protected void renderReportUsingWriter(JRExporter exporter, JasperPrint populatedReport, HttpServletResponse response) throws Exception {
        String contentType = this.getContentType();
        String encoding = (String)exporter.getParameter(JRExporterParameter.CHARACTER_ENCODING);
        if (encoding != null && contentType != null && contentType.toLowerCase().indexOf(";charset=") == -1) {
            contentType = contentType + ";charset=" + encoding;
        }
        response.setContentType(contentType);
        JasperReportsUtils.render((JRExporter)exporter, (JasperPrint)populatedReport, (Writer)response.getWriter());
    }

    protected void renderReportUsingOutputStream(JRExporter exporter, JasperPrint populatedReport, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream baos = this.createTemporaryOutputStream();
        JasperReportsUtils.render((JRExporter)exporter, (JasperPrint)populatedReport, (OutputStream)baos);
        this.writeToResponse(response, baos);
    }

    protected abstract JRExporter createExporter();

    protected abstract boolean useWriter();
}

