/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import org.netbeans.modules.profiler.MonitoringGraphsPanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TelemetryOverviewPanel
extends TopComponent {
    private static final String TELEMETRY_OVERVIEW_ACCESS_DESCR = NbBundle.getMessage(TelemetryOverviewPanel.class, (String)"TelemetryOverviewPanel_TelemetryOverviewAccessDescr");
    private static final String HELP_CTX_KEY = "TelemetryOverviewPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TelemetryOverviewPanel.HelpCtx");
    private static TelemetryOverviewPanel defaultInstance;
    private static final Image windowIcon;
    private static final String ID = "profiler_to";
    private static final Dimension PREFFERED_SIZE;
    private final MonitoringGraphsPanel graphsPanel;
    private Component lastFocusOwner;

    public TelemetryOverviewPanel() {
        this.setName(NbBundle.getMessage(TelemetryOverviewPanel.class, (String)"LAB_TelemetryOverviewPanelName"));
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(TELEMETRY_OVERVIEW_ACCESS_DESCR);
        this.graphsPanel = new MonitoringGraphsPanel();
        JScrollPane graphsPanelScroll = new JScrollPane(this.graphsPanel, 20, 30);
        graphsPanelScroll.setBorder(BorderFactory.createEmptyBorder());
        graphsPanelScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        graphsPanelScroll.getHorizontalScrollBar().setUnitIncrement(20);
        graphsPanelScroll.getHorizontalScrollBar().setBlockIncrement(20);
        this.setLayout(new BorderLayout());
        this.add(graphsPanelScroll, "Center");
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    public static synchronized TelemetryOverviewPanel getDefault() {
        if (defaultInstance == null) {
            IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

                @Override
                public void run() {
                    defaultInstance = (TelemetryOverviewPanel)WindowManager.getDefault().findTopComponent(TelemetryOverviewPanel.ID);
                    if (defaultInstance == null) {
                        defaultInstance = new TelemetryOverviewPanel();
                    }
                }
            });
        }
        return defaultInstance;
    }

    public static synchronized void closeIfOpened() {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (defaultInstance != null && defaultInstance.isOpened()) {
                    defaultInstance.close();
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 0;
    }

    public Dimension getPrefferedSize() {
        return PREFFERED_SIZE;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.graphsPanel != null) {
            this.graphsPanel.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public boolean needsDocking() {
        return WindowManager.getDefault().findMode((TopComponent)this) == null;
    }

    public void open() {
        Mode mode;
        if (this.needsDocking() && (mode = WindowManager.getDefault().findMode("output")) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected String preferredID() {
        return ID;
    }

    static {
        windowIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/telemetryOverviewWindow.png");
        PREFFERED_SIZE = new Dimension(580, 430);
    }
}

