#if !defined(__msp430_cc430)
#define __msp430_cc430

/* cc430_.h
 *
 * mspgcc project: MSP430 device headers
 * CC430 family header
 * Data from CC430 User's Guide (SLAU259) and the CC430F[56]1[23]x data sheet
 *
 * 2009-12-20 - Peter Bigot (pab@peoplepowerco.com)
 * Originally based in part on work by Texas Instruments Inc.
 *
 * This file supports all CC430 chips, but should not be included
 * directly.  Access it through one of the standard TI header names
 * (cc430x513x.h, cc430x612x.h, ...)
 */

#include <iomacros.h>

#define __MSP430_SFR_BASE__     0x0100
#define __MSP430_PMM_BASE__     0x0120
#define __MSP430_FLASH_BASE__   0x140
#define __MSP430_CRC16_BASE__   0x0150
// RAM Control: not supported
#define __MSP430_WDT_A_BASE__   0x0150 /* NB: Subtract 0x0C for compatibility with 1xx architecture */
#define __MSP430_UCS_BASE__	0x0160
#define __MSP430_SYS_BASE__     0x0180

#define __MSP430_HAS_REF__
#define __MSP430_REF_BASE__     0x01b0

#define __MSP430_PORT_MAPPING_BASE__  0x01c0
#define __MSP430_PORT1_MAPPING_BASE__ 0x01c8
#define __MSP430_PORT2_MAPPING_BASE__ 0x01d0
#define __MSP430_PORT3_MAPPING_BASE__ 0x01d8

#define __MSP430_PORT1_BASE__   0x0200
#define __MSP430_HAS_PORT1_R__
#define __MSP430_PORT2_BASE__   0x0200
#define __MSP430_HAS_PORT2_R__
#define __MSP430_PORT3_BASE__   0x0220
#define __MSP430_HAS_PORT3_R__
#if ! defined(__cc430x513x)
#define __MSP430_PORT4_BASE__   0x0220
#define __MSP430_HAS_PORT4_R__
#endif // ! __cc430x513x
#define __MSP430_PORT5_BASE__   0x0240
#define __MSP430_HAS_PORT5_R__
#define __MSP430_PORTJ_BASE__   0x0320
#define __MSP430_HAS_PORTJ_R__

#define __MSP430_HAS_T0A5__
#define __MSP430_T0A_BASE__	0x0340
#define __MSP430_HAS_T1A3__
#define __MSP430_T1A_BASE__	0x0380

#define __MSP430_HAS_RTC__
#define __MSP430_RTC_BASE__     0x04a0

#define __MSP430_MPY32_BASE__   0x04C0

#define __MSP430_HAS_DMAX_3__
#define __MSP430_DMA_BASE__     0x0500

#define __MSP430_HAS_USCI_A0__
#define __MSP430_HAS_USCI_B0__
#define __MSP430_USCI0_BASE__	0x05c0

#if defined(__CC430_6135__) \
    || defined(__CC430_5137__) || defined(__CC430_6137__)
#define __MSP430_HAS_ADC12_PLUS__
#define __MSP430_ADC12_PLUS_BASE__  0x0700
#endif // CC430F513x and CC430F613x only

#define __MSP430_HAS_COMPB__
#define __MSP430_COMPB_BASE__	0x08c0

#define __MSP430_AES_BASE__	0x09c0

#if defined(__cc430x612x) || defined(__cc430x613x)
#define __MSP430_HAS_LCD_B__
#define __MSP430_LCD_B_BASE__	0x0a00
#endif // CC430F612x and CC430F613x only
// Radio interface: not supported
#define __MSP430_CC1101_BASE__	0x0f00

/* Interrupt vectors */
#define AES_VECTOR          0x5a    /* 0xFFDA AES */
#define RTC_VECTOR          0x5c    /* 0xFFDC RTC */
#define LCD_B_VECTOR        0x5e    /* 0xFFDE LCD B */
#define PORT2_VECTOR        0x60    /* 0xFFE0 Port 2 */
#define PORT1_VECTOR        0x62    /* 0xFFE2 Port 1 */
#define TIMER1_A1_VECTOR    0x64    /* 0xFFE4 Timer1_A3 CC1-2, TA1 */
#define TIMER1_A0_VECTOR    0x66    /* 0xFFE6 Timer1_A3 CC0 */
#define DMA_VECTOR          0x68    /* 0xFFE8 DMA */
#define CC1101_VECTOR       0x6a    /* 0xFFEA CC1101 Radio Interface */
#define TIMER0_A1_VECTOR    0x6c    /* 0xFFEC Timer0_A5 CC1-4, TA */
#define TIMER0_A0_VECTOR    0x6e    /* 0xFFEE Timer0_A5 CC0 */
#define ADC12_VECTOR        0x70    /* 0xFFF0 ADC */
#define USCI_B0_VECTOR      0x72    /* 0xFFF2 USCI B0 Receive/Transmit */
#define USCI_A0_VECTOR      0x74    /* 0xFFF4 USCI A0 Receive/Transmit */
#define WDT_VECTOR          0x76    /* 0xFFF6 Watchdog Timer */
#define COMP_B_VECTOR       0x78    /* 0xFFF8 Comparator B */
#define UNMI_VECTOR         0x7a    /* 0xFFFA User Non-maskable */
#define SYSNMI_VECTOR       0x7c    /* 0xFFFC System Non-maskable */
#define RESET_VECTOR        0x7e    /* 0xFFFE Reset [Highest Priority] */

#include <msp430/common.h>
#include <msp430/sfr.h>
#include <msp430/pmm.h>
#include <msp430/flash_5xx.h>
#include <msp430/crc16.h>
#include <msp430/wdt_a.h>
#include <msp430/unified_clock_system.h>
#include <msp430/sys.h>
#include <msp430/ref.h>
#include <msp430/pmcontrol.h>
#include <msp430/gpio_5xxx.h>
#include <msp430/timera.h>
#include <msp430/rtc.h>
#include <msp430/mpy32.h>
#include <msp430/dmax.h>
#include <msp430/usci_5xx.h>
#include <msp430/adc12_plus.h>
#include <msp430/compb.h>
#include <msp430/aes.h>
#include <msp430/lcd_b.h>
#include <msp430/rf1a.h>


/* SYSRSTIV Definitions.  Not added to <msp430/sys.h> because the
 * values are device-dependent. */
#define SYSRSTIV_NONE          (0x0000)       /* No Interrupt pending */
#define SYSRSTIV_BOR           (0x0002)       /* SYSRSTIV : BOR */
#define SYSRSTIV_RSTNMI        (0x0004)       /* SYSRSTIV : RST/NMI */
#define SYSRSTIV_DOBOR         (0x0006)       /* SYSRSTIV : Do BOR */
#define SYSRSTIV_LPM5WU        (0x0008)       /* SYSRSTIV : Port LPM5 Wake Up */
#define SYSRSTIV_SECYV         (0x000A)       /* SYSRSTIV : Security violation */
#define SYSRSTIV_SVSL          (0x000C)       /* SYSRSTIV : SVSL */
#define SYSRSTIV_SVSH          (0x000E)       /* SYSRSTIV : SVSH */
#define SYSRSTIV_SVML_OVP      (0x0010)       /* SYSRSTIV : SVML_OVP */
#define SYSRSTIV_SVMH_OVP      (0x0012)       /* SYSRSTIV : SVMH_OVP */
#define SYSRSTIV_DOPOR         (0x0014)       /* SYSRSTIV : Do POR */
#define SYSRSTIV_WDTTO         (0x0016)       /* SYSRSTIV : WDT Time out */
#define SYSRSTIV_WDTKEY        (0x0018)       /* SYSRSTIV : WDTKEY violation */
#define SYSRSTIV_KEYV          (0x001A)       /* SYSRSTIV : Flash Key violation */
#define SYSRSTIV_PLLUL         (0x001C)       /* SYSRSTIV : PLL unlock */
#define SYSRSTIV_PERF          (0x001E)       /* SYSRSTIV : peripheral/config area fetch */
#define SYSRSTIV_PSSKEY        (0x0020)       /* SYSRSTIV : PSSKEY violation */

/* Port mapping controller functions for chips */
#define PM_NONE                0
#define PM_CBOUT0              1
#define PM_TA0CLK              1
#define PM_CBOUT1              2
#define PM_TA1CLK              2
#define PM_ACLK                3
#define PM_MCLK                4
#define PM_SMCLK               5
#define PM_RTCCLK              6
#define PM_ADC12CLK            7 // added per data sheet, not in TI
#define PM_MODCLK              7
#define PM_DMAE0               7
#define PM_SVMOUT              8
#define PM_TA0CCR0A            9
#define PM_TA0CCR1A            10
#define PM_TA0CCR2A            11
#define PM_TA0CCR3A            12
#define PM_TA0CCR4A            13
#define PM_TA1CCR0A            14
#define PM_TA1CCR1A            15
#define PM_TA1CCR2A            16
#define PM_UCA0RXD             17
#define PM_UCA0SOMI            17
#define PM_UCA0TXD             18
#define PM_UCA0SIMO            18
#define PM_UCA0CLK             19
#define PM_UCB0STE             19
#define PM_UCB0SOMI            20
#define PM_UCB0SCL             20
#define PM_UCB0SIMO            21
#define PM_UCB0SDA             21
#define PM_UCB0CLK             22
#define PM_UCA0STE             22
#define PM_RFGDO0              23
#define PM_RFGDO1              24
#define PM_RFGDO2              25
#define PM_ANALOG              31

#endif /* __msp430_cc430 */
