# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, build_po


packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)


setup(name='elisa-plugin-flickr',
    version='0.11',
    description='Flickr photo sharing',
    long_description='Browse and view your pictures on Flickr.',
    license='GPLv3',
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-poblesec'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.conf', 'icons/*'],
                  'elisa.plugins.flickr.i18n': ['*.po', '*/LC_MESSAGES/*.mo', '*.pot'],
                  },
    entry_points="""\
    [elisa.core.components.resource_provider]
    FlickrResourceProvider = elisa.plugins.flickr.resource_provider:FlickrResourceProvider

    [elisa.core.plugin_registry]
    use = elisa.plugins.flickr.controller:use_me_hook
    """,
    controller_mappings=[('/poblesec/flickr/account',
                          'elisa.plugins.flickr.controller:FlickrAccountListSwitcherController'),
                         ('/poblesec/flickr/settings',
                          'elisa.plugins.flickr.settings:SettingsController'),
                         ('/poblesec/flickr/home',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherPreviewController'),
                         ('/poblesec/flickr/folder',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherPreviewController'),
                         ('/poblesec/flickr',
                          'elisa.plugins.flickr.controller:FlickrListSwitcherController'),

                         ('/poblesec/flickr/login',
                          'elisa.plugins.flickr.settings:FlickrLoginController'),
                         ],
    decorator_mappings=[('/poblesec/settings/plugins',
                         'elisa.plugins.flickr.settings:flickr_settings_decorator'),
                        ('/poblesec/pictures/internet',
                         'elisa.plugins.flickr.controller:flickr_decorator')],
    cmdclass=cmdclass)
