# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
Constants and helpers to query the discogs REST API.
A complete documentation can be found at http://www.discogs.com/help/api.
"""

from elisa.core.media_uri import MediaUri


SERVER = 'http://www.discogs.com'
API_KEY = '2d1c349d44'


def generate_api_request(path):
    """
    Generate a URI suitable to query the discogs REST API.

    @param path: path to an API method with its parameters, starting with a
                 forward slash (e.g. C{'/artist/Dream%20Theater'})
    @type path:  C{str}

    @return: a URI targetting the discogs API
    @rtype:  L{elisa.core.media_uri.MediaUri}
    """
    uri = MediaUri('%s%s' % (SERVER, path))
    # Set mandatory parameters to the query
    uri.set_param('f', 'xml')
    uri.set_param('api_key', API_KEY)
    return uri
