/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.webdav;

import hidden.org.apache.commons.httpclient.HttpException;
import hidden.org.apache.commons.httpclient.HttpMethodBase;
import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.MultiStatus;
import hidden.org.apache.jackrabbit.webdav.MultiStatusResponse;
import hidden.org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import hidden.org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import hidden.org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import hidden.org.apache.jackrabbit.webdav.property.DavProperty;
import hidden.org.apache.jackrabbit.webdav.property.DavPropertyName;
import hidden.org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import hidden.org.apache.jackrabbit.webdav.property.DavPropertySet;
import hidden.org.codehaus.plexus.util.FileUtils;
import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.webdav.PathNavigator;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.w3c.dom.Node;

public class WebDavWagon
extends AbstractHttpClientWagon {
    private static final String[][] protocolMap = new String[][]{{"dav:http://", "http://"}, {"dav:https://", "https://"}, {"dav+http://", "http://"}, {"dav+https://", "https://"}, {"dav://", "http://"}, {"davs://", "https://"}};

    public boolean supportsDirectoryCopy() {
        return true;
    }

    protected void mkdirs(String dir) throws HttpException, IOException {
        String url;
        Repository repository = this.getRepository();
        String basedir = repository.getBasedir();
        String baseUrl = repository.getProtocol() + "://" + repository.getHost();
        if (repository.getPort() != -1) {
            baseUrl = baseUrl + ":" + repository.getPort();
        }
        String relpath = FileUtils.normalize(WebDavWagon.getPath(basedir, dir) + "/");
        PathNavigator navigator = new PathNavigator(relpath);
        int status = -1;
        while ((status = this.doMkCol(url = baseUrl + "/" + navigator.getPath())) != 200 && status != 201 && status != 405 && navigator.backward()) {
        }
        while (navigator.forward()) {
            url = baseUrl + "/" + navigator.getPath();
            status = this.doMkCol(url);
            if (status == 200 || status == 201) continue;
            throw new IOException("Unable to create collection: " + url + "; status code = " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doMkCol(String url) throws HttpException, IOException {
        MkColMethod method = null;
        try {
            method = new MkColMethod(url);
            int n = this.execute(method);
            return n;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File[] listFiles = sourceDirectory.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            if (listFiles[i].isDirectory()) {
                this.putDirectory(listFiles[i], destinationDirectory + "/" + listFiles[i].getName());
                continue;
            }
            String target = destinationDirectory + "/" + listFiles[i].getName();
            this.put(listFiles[i], target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirectory(String url) throws IOException, DavException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.create("resourcetype"));
        HttpMethodBase method = null;
        try {
            MultiStatus multiStatus;
            MultiStatusResponse response;
            DavPropertySet propertySet;
            DavProperty property;
            method = new PropFindMethod(url, nameSet, 0);
            this.execute(method);
            if (((DavMethodBase)method).succeeded() && (property = (propertySet = (response = (multiStatus = ((DavMethodBase)method).getResponseBodyAsMultiStatus()).getResponses()[0]).getProperties(200)).get("resourcetype")) != null) {
                Node node = (Node)property.getValue();
                boolean bl = node.getLocalName().equals("collection");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String url = this.getRepository().getUrl() + '/' + destinationDirectory;
        HttpMethodBase method = null;
        try {
            if (this.isDirectory(url)) {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DavPropertyName.create("displayname"));
                method = new PropFindMethod(url, nameSet, 1);
                int status = this.execute(method);
                if (((DavMethodBase)method).succeeded()) {
                    ArrayList<String> dirs = new ArrayList<String>();
                    MultiStatus multiStatus = ((DavMethodBase)method).getResponseBodyAsMultiStatus();
                    for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                        MultiStatusResponse response = multiStatus.getResponses()[i];
                        String entryUrl = response.getHref();
                        String fileName = PathUtils.filename(URLDecoder.decode(entryUrl));
                        if (entryUrl.endsWith("/")) {
                            if (i == 0) continue;
                            fileName = PathUtils.filename(PathUtils.dirname(URLDecoder.decode(entryUrl))) + "/";
                        }
                        if (StringUtils.isEmpty(fileName)) continue;
                        dirs.add(fileName);
                    }
                    ArrayList<String> arrayList = dirs;
                    return arrayList;
                }
                if (status == 404) {
                    throw new ResourceDoesNotExistException("Destination directory does not exist: " + url);
                }
            }
        }
        catch (DavException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        throw new ResourceDoesNotExistException("Destination path exists but is not a WebDAV collection (directory): " + url);
    }

    public String getURL(Repository repository) {
        String url = repository.getUrl();
        for (int i = 0; i < protocolMap.length; ++i) {
            String protocol = protocolMap[i][0];
            if (!url.startsWith(protocol)) continue;
            return protocolMap[i][1] + url.substring(protocol.length());
        }
        return url;
    }
}

