/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer.methods;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class GeneralPathSerializer
implements SerializeMethod {
    public Class getObjectClass() {
        return GeneralPath.class;
    }

    public Object readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        GeneralPath generalPath = new GeneralPath(n);
        int n2 = objectInputStream.readInt();
        while (n2 >= 0) {
            switch (n2) {
                case 0: {
                    float f = objectInputStream.readFloat();
                    float f2 = objectInputStream.readFloat();
                    generalPath.moveTo(f, f2);
                    break;
                }
                case 1: {
                    float f = objectInputStream.readFloat();
                    float f2 = objectInputStream.readFloat();
                    generalPath.lineTo(f, f2);
                    break;
                }
                case 2: {
                    float f = objectInputStream.readFloat();
                    float f2 = objectInputStream.readFloat();
                    float f3 = objectInputStream.readFloat();
                    float f4 = objectInputStream.readFloat();
                    generalPath.quadTo(f, f2, f3, f4);
                    break;
                }
                case 3: {
                    float f = objectInputStream.readFloat();
                    float f2 = objectInputStream.readFloat();
                    float f3 = objectInputStream.readFloat();
                    float f4 = objectInputStream.readFloat();
                    float f5 = objectInputStream.readFloat();
                    float f6 = objectInputStream.readFloat();
                    generalPath.curveTo(f, f2, f3, f4, f5, f6);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new IOException("Unexpected type encountered: " + n2);
                }
            }
            n2 = objectInputStream.readInt();
        }
        return generalPath;
    }

    public void writeObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        GeneralPath generalPath = (GeneralPath)object;
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        objectOutputStream.writeInt(pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            int n = pathIterator.currentSegment(fArray);
            objectOutputStream.writeInt(n);
            switch (n) {
                case 0: {
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    break;
                }
                case 1: {
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    break;
                }
                case 2: {
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    objectOutputStream.writeFloat(fArray[2]);
                    objectOutputStream.writeFloat(fArray[3]);
                    break;
                }
                case 3: {
                    objectOutputStream.writeFloat(fArray[0]);
                    objectOutputStream.writeFloat(fArray[1]);
                    objectOutputStream.writeFloat(fArray[2]);
                    objectOutputStream.writeFloat(fArray[3]);
                    objectOutputStream.writeFloat(fArray[4]);
                    objectOutputStream.writeFloat(fArray[5]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new IOException("Unexpected type encountered: " + n);
                }
            }
            pathIterator.next();
        }
        objectOutputStream.writeInt(-1);
    }
}

