/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.logical;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class AndFunction
implements Function {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = -3737884974501253814L;

    public String getCanonicalName() {
        return "AND";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        for (int i = 0; i < n; ++i) {
            Object object = parameterCallback.getValue(i);
            Type type = parameterCallback.getType(i);
            Boolean bl = formulaContext.getTypeRegistry().convertToLogical(type, object);
            if (bl == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            if (!Boolean.FALSE.equals(bl)) continue;
            return RETURN_FALSE;
        }
        return RETURN_TRUE;
    }
}

