/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IsNaFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final Log logger = LogFactory.getLog(IsNaFunction.class);
    private static final long serialVersionUID = 1205462839536368718L;

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        block7: {
            if (parameterCallback.getParameterCount() != 1) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
            }
            try {
                Type type = parameterCallback.getType(0);
                Object object = parameterCallback.getValue(0);
                if (ErrorType.TYPE.equals(type) && object instanceof ErrorValue) {
                    logger.warn((Object)"Passing errors around is deprecated. Throw exceptions instead.");
                    ErrorValue errorValue = (ErrorValue)object;
                    if (errorValue.getErrorCode() == 522) {
                        return RETURN_TRUE;
                    }
                } else if (object == null) {
                    return RETURN_TRUE;
                }
            }
            catch (EvaluationException evaluationException) {
                if (evaluationException.getErrorValue().getErrorCode() != 522) break block7;
                return RETURN_TRUE;
            }
        }
        return RETURN_FALSE;
    }

    public String getCanonicalName() {
        return "ISNA";
    }
}

