/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.resource;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;
import org.pentaho.reporting.libraries.resourceloader.loader.resource.ClassloaderResourceData;

public class ClassloaderResourceLoader
implements ResourceLoader {
    public boolean isSupportedKey(ResourceKey resourceKey) {
        return ClassloaderResourceLoader.class.getName().equals(resourceKey.getSchema());
    }

    public ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        String string;
        if (object instanceof String && (string = (String)object).startsWith("res://")) {
            return new ResourceKey(ClassloaderResourceLoader.class.getName(), object, map);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        HashMap hashMap;
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String string2 = string.startsWith("res://") ? string : (string.length() > 0 && string.charAt(0) == '/' ? "res:/" + string : LoaderUtils.mergePaths((String)resourceKey.getIdentifier(), string));
        if (map != null) {
            hashMap = new HashMap();
            hashMap.putAll(resourceKey.getFactoryParameters());
            hashMap.putAll(map);
        } else {
            hashMap = resourceKey.getFactoryParameters();
        }
        return new ResourceKey(resourceKey.getSchema(), string2, hashMap);
    }

    public URL toURL(ResourceKey resourceKey) {
        return null;
    }

    public ResourceData load(ResourceKey resourceKey) throws ResourceLoadingException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new ClassloaderResourceData(resourceKey);
    }

    public static String createResourceKey(Class clazz, String string) {
        if (clazz == null) {
            return "res://" + string;
        }
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return "res://" + string;
        }
        String string3 = string2.substring(0, n);
        String string4 = string3.replace('.', '/');
        return "res://" + string3 + '/' + string4;
    }
}

