/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.file;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.file.FileResourceData;

public class FileResourceLoader
implements ResourceLoader {
    public boolean isSupportedKey(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        return FileResourceLoader.class.getName().equals(resourceKey.getSchema());
    }

    public ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        File file;
        if (object instanceof File) {
            File file2 = (File)object;
            if (file2.exists() && file2.isFile()) {
                return new ResourceKey(FileResourceLoader.class.getName(), file2, map);
            }
        } else if (object instanceof String && (file = new File(String.valueOf(object))).exists() && file.isFile()) {
            return new ResourceKey(FileResourceLoader.class.getName(), file, map);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        try {
            File file;
            Serializable serializable;
            if (string != null) {
                serializable = (File)resourceKey.getIdentifier();
                file = new File(((File)serializable).getCanonicalFile().getParentFile(), string);
                if (!file.exists() || !file.isFile()) {
                    throw new ResourceKeyCreationException("Malformed value: " + string + " (" + file + ')');
                }
            } else {
                file = (File)resourceKey.getIdentifier();
            }
            if (map != null) {
                serializable = new HashMap();
                serializable.putAll(resourceKey.getFactoryParameters());
                serializable.putAll(map);
            } else {
                serializable = resourceKey.getFactoryParameters();
            }
            return new ResourceKey(resourceKey.getSchema(), file, (Map)((Object)serializable));
        }
        catch (IOException iOException) {
            throw new ResourceKeyCreationException("Failed to create key", iOException);
        }
    }

    public URL toURL(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        if (!this.isSupportedKey(resourceKey)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        File file = (File)resourceKey.getIdentifier();
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ResourceData load(ResourceKey resourceKey) throws ResourceLoadingException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new FileResourceData(resourceKey);
    }
}

