/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ContentNotRecognizedException;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;

public class DefaultResourceManagerBackend
implements ResourceManagerBackend {
    private static Log logger = LogFactory.getLog(DefaultResourceManagerBackend.class);
    private ArrayList resourceLoaders = new ArrayList();
    private ArrayList resourceBundleLoaders = new ArrayList();
    private ArrayList resourceFactories = new ArrayList();

    public synchronized ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        if (object == null) {
            throw new NullPointerException("Key data must not be null.");
        }
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            try {
                ResourceKey resourceKey = resourceLoader.createKey(object, map);
                if (resourceKey == null) continue;
                return resourceKey;
            }
            catch (ResourceKeyCreationException resourceKeyCreationException) {
            }
        }
        throw new ResourceKeyCreationException("Unable to create key: No loader was able to handle the given key data: " + object);
    }

    public synchronized ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        ResourceKey resourceKey2;
        Object object;
        Object object2;
        int n;
        if (resourceKey == null) {
            if (string == null) {
                throw new NullPointerException();
            }
            return this.createKey(string, map);
        }
        ResourceKeyCreationException resourceKeyCreationException = null;
        for (n = 0; n < this.resourceBundleLoaders.size(); ++n) {
            object2 = (ResourceBundleLoader)this.resourceBundleLoaders.get(n);
            if (!object2.isSupportedKey(resourceKey)) continue;
            try {
                object = object2.deriveKey(resourceKey, string, map);
                if (object == null) continue;
                return object;
            }
            catch (ResourceKeyCreationException resourceKeyCreationException2) {
                resourceKeyCreationException = resourceKeyCreationException2;
            }
        }
        for (n = 0; n < this.resourceLoaders.size(); ++n) {
            object2 = (ResourceLoader)this.resourceLoaders.get(n);
            if (!object2.isSupportedKey(resourceKey)) continue;
            try {
                object = object2.deriveKey(resourceKey, string, map);
                if (object == null) continue;
                return object;
            }
            catch (ResourceKeyCreationException resourceKeyCreationException3) {
                resourceKeyCreationException = resourceKeyCreationException3;
            }
        }
        if (string != null) {
            for (n = 0; n < this.resourceLoaders.size(); ++n) {
                object2 = (ResourceLoader)this.resourceLoaders.get(n);
                object = object2.createKey(string, map);
                if (object == null) continue;
                return object;
            }
        }
        if ((resourceKey2 = resourceKey.getParent()) != null) {
            for (int i = 0; i < this.resourceLoaders.size(); ++i) {
                object = (ResourceLoader)this.resourceLoaders.get(i);
                if (!object.isSupportedKey(resourceKey)) continue;
                try {
                    ResourceKey resourceKey3 = object.deriveKey(resourceKey, string, map);
                    if (resourceKey3 != null) {
                        return resourceKey3;
                    }
                    continue;
                }
                catch (ResourceKeyCreationException resourceKeyCreationException4) {
                    resourceKeyCreationException = resourceKeyCreationException4;
                }
            }
        }
        if (resourceKeyCreationException != null) {
            throw resourceKeyCreationException;
        }
        throw new ResourceKeyCreationException("Unable to create key: No such schema or the key was not recognized.");
    }

    private ResourceLoader findBySchema(ResourceKey resourceKey) {
        for (int i = 0; i < this.resourceLoaders.size(); ++i) {
            ResourceLoader resourceLoader = (ResourceLoader)this.resourceLoaders.get(i);
            if (!resourceLoader.isSupportedKey(resourceKey)) continue;
            return resourceLoader;
        }
        return null;
    }

    public synchronized URL toURL(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        ResourceLoader resourceLoader = this.findBySchema(resourceKey);
        if (resourceLoader == null) {
            return null;
        }
        return resourceLoader.toURL(resourceKey);
    }

    public synchronized Resource create(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey, Class[] classArray) throws ResourceLoadingException, ResourceCreationException {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (resourceData == null) {
            throw new NullPointerException("Data must not be null.");
        }
        if (classArray == null) {
            return this.autoCreateResource(resourceManager, resourceData, resourceKey);
        }
        ResourceCreationException resourceCreationException = null;
        int n = this.resourceFactories.size();
        ResourceFactory[] resourceFactoryArray = this.resourceFactories.toArray(new ResourceFactory[n]);
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            for (int j = 0; j < n; ++j) {
                ResourceFactory resourceFactory = resourceFactoryArray[j];
                if (!this.isSupportedTarget(clazz, resourceFactory)) continue;
                try {
                    return resourceFactory.create(resourceManager, resourceData, resourceKey);
                }
                catch (ContentNotRecognizedException contentNotRecognizedException) {
                    continue;
                }
                catch (ResourceCreationException resourceCreationException2) {
                    resourceCreationException = resourceCreationException2;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Failed at " + resourceFactory.getClass() + ": "), (Throwable)((Object)resourceCreationException2));
                }
            }
        }
        if (resourceCreationException != null) {
            throw resourceCreationException;
        }
        throw new ContentNotRecognizedException("None of the selected factories was able to handle the given data: " + resourceData.getKey());
    }

    private boolean isSupportedTarget(Class clazz, ResourceFactory resourceFactory) {
        Class clazz2 = resourceFactory.getFactoryType();
        return clazz != null && clazz.isAssignableFrom(clazz2);
    }

    private Resource autoCreateResource(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceLoadingException, ResourceCreationException {
        for (ResourceFactory resourceFactory : this.resourceFactories) {
            try {
                Resource resource = resourceFactory.create(resourceManager, resourceData, resourceKey);
                if (resource == null) continue;
                return resource;
            }
            catch (ResourceCreationException resourceCreationException) {
            }
        }
        throw new ResourceCreationException("No known factory was able to handle the given data.");
    }

    public boolean isResourceUnchanged(ResourceManager resourceManager, Resource resource) throws ResourceLoadingException {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        ResourceKey[] resourceKeyArray = resource.getDependencies();
        for (int i = 0; i < resourceKeyArray.length; ++i) {
            ResourceData resourceData;
            ResourceKey resourceKey = resourceKeyArray[i];
            long l = resource.getVersion(resourceKey);
            if (l == -1L || (resourceData = resourceManager.load(resourceKey)).getVersion(resourceManager) == l) continue;
            return false;
        }
        return true;
    }

    public synchronized ResourceBundleData loadResourceBundle(ResourceManager resourceManager, ResourceKey resourceKey) throws ResourceLoadingException {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.resourceBundleLoaders.size(); ++i) {
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)this.resourceBundleLoaders.get(i);
            ResourceBundleData resourceBundleData = resourceBundleLoader.loadBundle(resourceManager, resourceKey);
            if (resourceBundleData == null) continue;
            return resourceBundleData;
        }
        return null;
    }

    public ResourceData loadRawData(ResourceManager resourceManager, ResourceKey resourceKey) throws ResourceLoadingException, UnrecognizedLoaderException {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        ResourceLoader resourceLoader = this.findBySchema(resourceKey);
        if (resourceLoader == null) {
            throw new UnrecognizedLoaderException("Invalid key: No resource-loader registered for schema: " + resourceKey.getSchema());
        }
        logger.debug((Object)("Loaded " + resourceKey));
        return resourceLoader.load(resourceKey);
    }

    public void registerDefaultFactories() {
        Configuration configuration = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys("org.pentaho.reporting.libraries.resourceloader.factory.type.");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = configuration.getConfigProperty(string);
            Object object = ObjectUtilities.loadAndInstantiate((String)string2, ResourceManager.class, ResourceFactory.class);
            if (!(object instanceof ResourceFactory)) continue;
            ResourceFactory resourceFactory = (ResourceFactory)object;
            resourceFactory.initializeDefaults();
            this.registerFactory(resourceFactory);
        }
    }

    public void registerDefaultLoaders() {
        Object object;
        String string;
        Object object2;
        Configuration configuration = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys("org.pentaho.reporting.libraries.resourceloader.loader.");
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            string = configuration.getConfigProperty((String)object2);
            object = (ResourceLoader)ObjectUtilities.loadAndInstantiate((String)string, ResourceManager.class, ResourceLoader.class);
            if (object == null) continue;
            this.registerLoader((ResourceLoader)object);
        }
        object2 = configuration.findPropertyKeys("org.pentaho.reporting.libraries.resourceloader.bundle.loader.");
        while (object2.hasNext()) {
            string = (String)object2.next();
            object = configuration.getConfigProperty(string);
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)ObjectUtilities.loadAndInstantiate((String)object, ResourceManager.class, ResourceBundleLoader.class);
            if (resourceBundleLoader == null) continue;
            this.registerBundleLoader(resourceBundleLoader);
        }
    }

    public void registerBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        if (resourceBundleLoader == null) {
            throw new NullPointerException("ResourceLoader must not be null.");
        }
        this.resourceBundleLoaders.add(resourceBundleLoader);
    }

    public void registerLoader(ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new NullPointerException("ResourceLoader must not be null.");
        }
        this.resourceLoaders.add(resourceLoader);
    }

    public void registerFactory(ResourceFactory resourceFactory) {
        if (resourceFactory == null) {
            throw new NullPointerException("ResourceFactory must not be null.");
        }
        this.resourceFactories.add(resourceFactory);
    }
}

