/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.font;

import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.text.font.FontSizeProducer;
import org.pentaho.reporting.libraries.fonts.text.font.GlyphMetrics;

public class VariableFontSizeProducer
implements FontSizeProducer {
    private FontMetrics fontMetrics;
    private int maxHeight;
    private int baseLine;

    public VariableFontSizeProducer(FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new NullPointerException();
        }
        this.fontMetrics = fontMetrics;
        this.maxHeight = (int)(Integer.MAX_VALUE & fontMetrics.getMaxHeight());
        this.baseLine = (int)(Integer.MAX_VALUE & fontMetrics.getMaxHeight() - fontMetrics.getMaxDescent());
    }

    public GlyphMetrics getCharacterSize(int n, GlyphMetrics glyphMetrics) {
        int n2 = n == Integer.MIN_VALUE || n == Integer.MAX_VALUE ? 0 : (int)(Integer.MAX_VALUE & this.fontMetrics.getCharWidth(n));
        if (glyphMetrics == null) {
            glyphMetrics = new GlyphMetrics();
        }
        glyphMetrics.setWidth(n2);
        glyphMetrics.setHeight(this.maxHeight);
        glyphMetrics.setBaselinePosition(this.baseLine);
        return glyphMetrics;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

