/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import java.util.HashMap;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontFamily;
import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public class MonospaceFontRegistry
implements FontRegistry {
    private static FontCache secondLevelCache;
    private HashMap fontFamilies;
    private float lpi;
    private float cpi;
    private MonospaceFontFamily fallback;

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    public MonospaceFontRegistry(float f, float f2) {
        this.lpi = f;
        this.cpi = f2;
        this.fontFamilies = new HashMap();
        this.fallback = new MonospaceFontFamily("Monospace");
    }

    public FontCache getSecondLevelCache() {
        return MonospaceFontRegistry.internalGetSecondLevelCache();
    }

    public void add(MonospaceFontFamily monospaceFontFamily) {
        this.fontFamilies.put(monospaceFontFamily.getFamilyName(), monospaceFontFamily);
    }

    public MonospaceFontFamily getFallback() {
        return this.fallback;
    }

    public void setFallback(MonospaceFontFamily monospaceFontFamily) {
        this.fallback = monospaceFontFamily;
    }

    public void initialize() {
    }

    public FontFamily getFontFamily(String string) {
        FontFamily fontFamily = (FontFamily)this.fontFamilies.get(string);
        if (fontFamily != null) {
            return fontFamily;
        }
        return this.fallback;
    }

    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public FontMetricsFactory createMetricsFactory() {
        return new MonospaceFontMetricsFactory(this.lpi, this.cpi);
    }
}

