/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.merge;

import java.util.ArrayList;
import java.util.HashSet;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public class CompoundFontRegistry
implements FontRegistry {
    private static FontCache secondLevelCache;
    private ArrayList registries = new ArrayList();

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    public FontCache getSecondLevelCache() {
        return CompoundFontRegistry.internalGetSecondLevelCache();
    }

    public void addRegistry(FontRegistry fontRegistry) {
        if (fontRegistry == null) {
            throw new NullPointerException();
        }
        this.registries.add(fontRegistry);
    }

    public void initialize() {
        for (int i = 0; i < this.registries.size(); ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            fontRegistry.initialize();
        }
    }

    public FontFamily getFontFamily(String string) {
        for (int i = 0; i < this.registries.size(); ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            FontFamily fontFamily = fontRegistry.getFontFamily(string);
            if (fontFamily == null) continue;
            return new CompoundFontFamily(fontFamily, fontRegistry);
        }
        return null;
    }

    public String[] getRegisteredFamilies() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.registries.size(); ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            for (String string : fontRegistry.getRegisteredFamilies()) {
                hashSet.add(string);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.registries.size();
        for (int i = 0; i < n; ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            for (String string : fontRegistry.getAllRegisteredFamilies()) {
                hashSet.add(string);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public FontMetricsFactory createMetricsFactory() {
        throw new UnsupportedOperationException("The CompoundFontRegistry cannot provide font-metrics directly.");
    }
}

