/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingCore;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingFactory;
import org.pentaho.reporting.libraries.fonts.encoding.ExternalEncoding;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Ascii;
import org.pentaho.reporting.libraries.fonts.encoding.manual.BuiltInJavaEncoding;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.property.PropertiesResourceFactory;

public final class EncodingRegistry {
    private static Log logger = LogFactory.getLog(EncodingRegistry.class);
    private static final String TEST_STRING = " ";
    private HashMap encodingsMapping;
    private HashMap generatedMapping;
    private HashMap fallbackMapping;
    private HashMap aliases;
    private ResourceManager manager = new ResourceManager();
    private static EncodingRegistry instance;
    public static final String ENCODING_ALIAS_PREFIX = "org.pentaho.reporting.libraries.fonts.encoding.alias.";

    public static synchronized EncodingRegistry getInstance() {
        if (instance == null) {
            instance = new EncodingRegistry();
            instance.registerDefaults();
        }
        return instance;
    }

    private EncodingRegistry() {
        this.manager.registerFactoryCache();
        this.manager.registerDataCache();
        this.manager.registerDefaultLoaders();
        this.manager.registerFactory((ResourceFactory)new EncodingFactory());
        this.manager.registerFactory((ResourceFactory)new PropertiesResourceFactory());
        this.encodingsMapping = new HashMap();
        this.generatedMapping = new HashMap();
        this.fallbackMapping = new HashMap();
        this.aliases = new HashMap();
    }

    private void registerDefaults() {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Configuration configuration = LibFontBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys("org.pentaho.reporting.libraries.fonts.encoding.manual.");
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = configuration.getConfigProperty((String)object4);
            object2 = ObjectUtilities.loadAndInstantiate((String)object3, EncodingRegistry.class, Encoding.class);
            if (object2 == null) continue;
            object = (Encoding)object2;
            string = object.getName();
            this.encodingsMapping.put(this.normalizeEncodingName(string), object3);
        }
        object4 = configuration.findPropertyKeys("org.pentaho.reporting.libraries.fonts.encoding.generated.");
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            object2 = configuration.getConfigProperty((String)object3);
            try {
                object = this.manager.createKey(object2);
                string = this.manager.create((ResourceKey)object, null, Properties.class);
                Properties properties = (Properties)string.getResource();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String string2 = (String)entry.getKey();
                    String string3 = (String)entry.getValue();
                    ResourceKey resourceKey = this.manager.deriveKey((ResourceKey)object, string3);
                    this.generatedMapping.put(this.normalizeEncodingName(string2), resourceKey);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object3 = configuration.findPropertyKeys(ENCODING_ALIAS_PREFIX);
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = ((String)object2).substring(ENCODING_ALIAS_PREFIX.length());
            string = configuration.getConfigProperty((String)object2);
            this.aliases.put(this.normalizeEncodingName((String)object), this.normalizeEncodingName(string));
        }
    }

    public boolean isSupportedEncoding(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.normalizeEncodingName(string);
        if (this.encodingsMapping.containsKey(string2)) {
            return true;
        }
        if (this.generatedMapping.containsKey(string2)) {
            return true;
        }
        if (this.fallbackMapping.containsKey(string2)) {
            return true;
        }
        return this.isEncodingSupportedJVM(string);
    }

    private String normalizeEncodingName(String string) {
        String string2 = string.toLowerCase();
        String string3 = string2.replace('_', '-');
        String string4 = (String)this.aliases.get(string3);
        if (string4 != null) {
            return string4;
        }
        return string3;
    }

    private boolean isEncodingSupportedJVM(String string) {
        try {
            TEST_STRING.getBytes(string);
            this.fallbackMapping.put(string, Boolean.TRUE);
            return true;
        }
        catch (Exception exception) {
            logger.info((Object)("Encoding " + string + " is not supported."));
            return false;
        }
    }

    public static String getPlatformDefaultEncoding() {
        return LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("file.encoding", "Cp1252");
    }

    public Encoding getEncoding(String string) {
        String string2 = this.normalizeEncodingName(string);
        String string3 = (String)this.encodingsMapping.get(string2);
        if (string3 != null) {
            return (Encoding)ObjectUtilities.loadAndInstantiate((String)string3, EncodingRegistry.class, Encoding.class);
        }
        ResourceKey resourceKey = (ResourceKey)this.generatedMapping.get(string2);
        if (resourceKey != null) {
            try {
                Resource resource = this.manager.create(resourceKey, null, Encoding.class);
                Object object = resource.getResource();
                if (object instanceof EncodingCore) {
                    return new ExternalEncoding(string, (EncodingCore)object, resource);
                }
            }
            catch (Exception exception) {
                logger.warn((Object)("Failed to create external-encoding instance for key " + string2), (Throwable)exception);
            }
        }
        if (this.isEncodingSupportedJVM(string)) {
            return new BuiltInJavaEncoding(string, true);
        }
        if (this.isEncodingSupportedJVM(string2)) {
            return new BuiltInJavaEncoding(string2, true);
        }
        return new Ascii();
    }
}

