/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;

public class EncodedOutputStreamWriter
extends Writer {
    private OutputStream outputStream;
    private EncodingErrorType errorType;
    private Encoding encoding;
    private ByteBuffer buffer;
    private CodePointBuffer text;

    public EncodedOutputStreamWriter(OutputStream outputStream, Encoding encoding, EncodingErrorType encodingErrorType) {
        this.encoding = encoding;
        this.outputStream = outputStream;
        this.errorType = encodingErrorType;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.text = Utf16LE.getInstance().decode(cArray, n, n2, this.text);
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = this.errorType == null ? this.encoding.encode(this.text, this.buffer) : this.encoding.encode(this.text, this.buffer, this.errorType);
        this.outputStream.write(this.buffer.getData(), this.buffer.getOffset(), this.buffer.getLength());
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        this.outputStream.close();
    }
}

