/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.io.Serializable;

public class ByteBuffer
implements Serializable {
    private byte[] data;
    private int offset;
    private int cursor;

    public ByteBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new byte[n];
        this.offset = 0;
        this.cursor = 0;
    }

    public ByteBuffer(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.data = byArray;
        this.offset = 0;
        this.cursor = byArray.length;
    }

    public ByteBuffer(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 + n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.data = byArray;
        this.offset = n;
        this.cursor = n + n2;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Length < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Offset < 0");
        }
        if (n + n2 >= byArray.length) {
            throw new IllegalArgumentException("Length + Offset");
        }
        this.data = byArray;
        this.cursor = n + n2;
        this.offset = n2;
    }

    public int getLength() {
        return this.cursor - this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void ensureSize(int n) {
        if (this.data.length < this.offset + n) {
            byte[] byArray = new byte[this.offset + n];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
        }
    }

    public void setCursor(int n) {
        if (n < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (n > this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        this.cursor = n;
    }
}

