/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;

public class DefaultPageGrid
implements PageGrid {
    private int rows;
    private int columns;
    private PhysicalPageBox[] pages;

    public DefaultPageGrid(PageContext pageContext, OutputProcessorMetaData outputProcessorMetaData) {
        LayoutStyle layoutStyle = pageContext.getAreaDefinition(PageAreaType.CONTENT);
        CSSValue cSSValue = layoutStyle.getValue(PageStyleKeys.HORIZONTAL_PAGE_SPAN);
        CSSValue cSSValue2 = layoutStyle.getValue(PageStyleKeys.VERTICAL_PAGE_SPAN);
        this.columns = Math.max(1, (int)CSSValueResolverUtility.getNumericValue(cSSValue, outputProcessorMetaData.getHorizontalPageSpan()));
        this.rows = Math.max(1, (int)CSSValueResolverUtility.getNumericValue(cSSValue2, outputProcessorMetaData.getVerticalPageSpan()));
        this.pages = new PhysicalPageBox[this.rows * this.columns];
        long l = 0L;
        for (int i = 0; i < this.rows; ++i) {
            long l2 = 0L;
            long l3 = 0L;
            for (int j = 0; j < this.columns; ++j) {
                PhysicalPageBox physicalPageBox;
                this.pages[i * this.columns + j] = physicalPageBox = new PhysicalPageBox(pageContext, outputProcessorMetaData, l2, l);
                l2 += physicalPageBox.getImageableWidth();
                l3 = physicalPageBox.getImageableHeight();
            }
            l += l3;
        }
    }

    public PhysicalPageBox getPage(int n, int n2) {
        return this.pages[n * this.rows + n2];
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public Object clone() {
        try {
            DefaultPageGrid defaultPageGrid = (DefaultPageGrid)super.clone();
            defaultPageGrid.pages = (PhysicalPageBox[])this.pages.clone();
            for (int i = 0; i < this.pages.length; ++i) {
                PhysicalPageBox physicalPageBox = this.pages[i];
                defaultPageGrid.pages[i] = (PhysicalPageBox)physicalPageBox.clone();
            }
            return defaultPageGrid;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }
}

