/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractXmlReadHandler
implements XmlReadHandler {
    private static final Log logger = LogFactory.getLog(AbstractXmlReadHandler.class);
    private RootXmlReadHandler rootHandler;
    private String tagName;
    private String uri;
    private boolean firstCall;

    protected AbstractXmlReadHandler() {
    }

    public void init(RootXmlReadHandler rootXmlReadHandler, String string, String string2) {
        if (rootXmlReadHandler == null) {
            throw new NullPointerException("Root handler must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Tag name must not be null");
        }
        this.uri = string;
        this.rootHandler = rootXmlReadHandler;
        this.tagName = string2;
        this.firstCall = true;
    }

    public final void startElement(String string, String string2, Attributes attributes) throws SAXException {
        if (this.firstCall) {
            if (!this.tagName.equals(string2) || !this.uri.equals(string)) {
                throw new ParseException("Expected <" + this.tagName + ">, found <" + string2 + '>', this.getLocator());
            }
            this.firstCall = false;
            this.startParsing(attributes);
        } else {
            XmlReadHandler xmlReadHandler = this.getHandlerForChild(string, string2, attributes);
            if (xmlReadHandler == null) {
                logger.warn((Object)("Unknown tag <" + string + ':' + string2 + ">: Start to ignore this element and all of its childs. " + this.getLocatorString()));
                logger.debug(this.getClass());
                IgnoreAnyChildReadHandler ignoreAnyChildReadHandler = new IgnoreAnyChildReadHandler();
                ignoreAnyChildReadHandler.init(this.getRootHandler(), string, string2);
                this.rootHandler.recurse(ignoreAnyChildReadHandler, string, string2, attributes);
            } else {
                xmlReadHandler.init(this.getRootHandler(), string, string2);
                this.rootHandler.recurse(xmlReadHandler, string, string2, attributes);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public final void endElement(String string, String string2) throws SAXException {
        if (!this.tagName.equals(string2) || !this.uri.equals(string)) {
            throw new ParseException("Illegal Parser State." + this.toString(), this.getLocator());
        }
        this.doneParsing();
        this.rootHandler.unwind(string, string2);
    }

    private String getLocatorString() {
        Locator locator = this.getLocator();
        if (locator == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(" [Location: Line=");
        stringBuffer.append(locator.getLineNumber());
        stringBuffer.append(" Column=");
        stringBuffer.append(locator.getColumnNumber());
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    protected void startParsing(Attributes attributes) throws SAXException {
    }

    protected void doneParsing() throws SAXException {
    }

    protected boolean isSameNamespace(String string) {
        return ObjectUtilities.equal((Object)string, (Object)this.getUri());
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getUri() {
        return this.uri;
    }

    public RootXmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public Locator getLocator() {
        return this.rootHandler.getDocumentLocator();
    }

    protected Object performExternalParsing(String string, Class clazz) throws ParseException, ResourceLoadingException {
        return this.performExternalParsing(string, clazz, this.deriveParseParameters());
    }

    protected Object performExternalParsing(String string, Class clazz, Map map) throws ParseException, ResourceLoadingException {
        try {
            ResourceManager resourceManager = this.rootHandler.getResourceManager();
            ResourceKey resourceKey = this.rootHandler.getSource();
            ResourceKey resourceKey2 = resourceManager.deriveKey(resourceKey, string, map);
            DependencyCollector dependencyCollector = this.rootHandler.getDependencyCollector();
            Resource resource = resourceManager.create(resourceKey2, this.rootHandler.getContext(), clazz);
            dependencyCollector.add(resource);
            return resource.getResource();
        }
        catch (ResourceLoadingException resourceLoadingException) {
            throw resourceLoadingException;
        }
        catch (ResourceException resourceException) {
            throw new ParseException("Failure while loading data: " + string, (Exception)((Object)resourceException), this.getLocator());
        }
    }

    protected Map deriveParseParameters() {
        RootXmlReadHandler rootXmlReadHandler = this.getRootHandler();
        HashMap<FactoryParameterKey, Object> hashMap = new HashMap<FactoryParameterKey, Object>();
        for (String string : rootXmlReadHandler.getHelperObjectNames()) {
            FactoryParameterKey factoryParameterKey = new FactoryParameterKey(string);
            hashMap.put(factoryParameterKey, rootXmlReadHandler.getHelperObject(string));
        }
        return hashMap;
    }
}

