/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ParserUtil {
    private ParserUtil() {
    }

    public static int parseInt(String string, String string2, Locator locator) throws SAXException {
        if (string == null) {
            throw new SAXException(string2);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("NumberFormatError: " + string2, locator);
        }
    }

    public static int parseInt(String string, String string2) throws SAXException {
        if (string == null) {
            throw new SAXException(string2);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("NumberFormatError: " + string2);
        }
    }

    public static int parseInt(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static float parseFloat(String string, String string2, Locator locator) throws ParseException {
        if (string == null) {
            throw new ParseException(string2, locator);
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("NumberFormatError: " + string2, locator);
        }
    }

    public static float parseFloat(String string, String string2) throws SAXException {
        if (string == null) {
            throw new SAXException(string2);
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("NumberFormatError: " + string2);
        }
    }

    public static float parseFloat(String string, float f) {
        if (string == null) {
            return f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static boolean parseBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        return "true".equalsIgnoreCase(string);
    }

    public static Boolean parseBoolean(String string, Locator locator) throws ParseException {
        if (string == null) {
            return null;
        }
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        throw new ParseException("Failed to parse value: Expected 'true' or 'false'", locator);
    }

    public static String parseString(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }
}

