/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipreader;

import java.util.Date;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadContentItem;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadRepository;

public class ZipReadContentLocation
implements ContentLocation {
    private static final Log logger = LogFactory.getLog(ZipReadContentLocation.class);
    private ZipReadRepository repository;
    private ZipReadContentLocation parent;
    private String comment;
    private String name;
    private long size;
    private long time;
    private String entryName;
    private HashMap entries;

    public ZipReadContentLocation(ZipReadRepository zipReadRepository, ZipReadContentLocation zipReadContentLocation, String string) {
        if (zipReadRepository == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.repository = zipReadRepository;
        this.parent = zipReadContentLocation;
        this.entryName = string;
        this.entries = new HashMap();
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
    }

    public ZipReadContentLocation(ZipReadRepository zipReadRepository, ZipReadContentLocation zipReadContentLocation, ZipEntry zipEntry) {
        if (zipReadRepository == null) {
            throw new NullPointerException();
        }
        if (zipReadContentLocation == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        this.repository = zipReadRepository;
        this.parent = zipReadContentLocation;
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
        this.entries = new HashMap();
        this.entryName = IOUtils.getInstance().getFileName(zipEntry.getName());
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
    }

    private void updateMetaData(ZipEntry zipEntry) {
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
    }

    public void updateDirectoryEntry(String[] stringArray, int n, ZipEntry zipEntry) {
        ZipReadContentLocation zipReadContentLocation;
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        String string = stringArray[n];
        Object v = this.entries.get(string);
        if (v instanceof ContentItem) {
            logger.warn((Object)("Directory-Entry with the same name as a Content-Entry encountered: " + string));
            return;
        }
        if (v == null) {
            zipReadContentLocation = new ZipReadContentLocation(this.repository, this, string);
            this.entries.put(string, zipReadContentLocation);
        } else {
            zipReadContentLocation = (ZipReadContentLocation)v;
        }
        int n2 = n + 1;
        if (n2 < stringArray.length) {
            zipReadContentLocation.updateDirectoryEntry(stringArray, n2, zipEntry);
        } else if (n2 == stringArray.length) {
            zipReadContentLocation.updateMetaData(zipEntry);
        }
    }

    public void updateEntry(String[] stringArray, int n, ZipEntry zipEntry, byte[] byArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        String string = stringArray[n];
        Object v = this.entries.get(string);
        int n2 = n + 1;
        if (n2 < stringArray.length) {
            ZipReadContentLocation zipReadContentLocation;
            if (v instanceof ContentItem) {
                logger.warn((Object)("Directory-Entry with the same name as a Content-Entry encountered: " + string));
                return;
            }
            if (v == null) {
                zipReadContentLocation = new ZipReadContentLocation(this.repository, this, string);
                this.entries.put(string, zipReadContentLocation);
            } else {
                zipReadContentLocation = (ZipReadContentLocation)v;
            }
            if (n2 < stringArray.length) {
                zipReadContentLocation.updateEntry(stringArray, n2, zipEntry, byArray);
            }
        } else if (n2 == stringArray.length) {
            if (v instanceof ContentItem) {
                logger.warn((Object)("Duplicate Content-Entry encountered: " + string));
                return;
            }
            if (v != null) {
                logger.warn((Object)("Replacing Directory-Entry with the same name as a Content-Entry: " + string));
            }
            ZipReadContentItem zipReadContentItem = new ZipReadContentItem(this.repository, this, zipEntry, byArray);
            this.entries.put(string, zipReadContentItem);
        }
    }

    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    public ContentEntity getEntry(String string) throws ContentIOException {
        ContentEntity contentEntity = (ContentEntity)this.entries.get(string);
        if (contentEntity == null) {
            throw new ContentIOException("Not found:" + string);
        }
        return contentEntity;
    }

    public boolean exists(String string) {
        return this.entries.containsKey(string);
    }

    public ContentItem createItem(String string) throws ContentCreationException {
        throw new ContentCreationException();
    }

    public ContentLocation createLocation(String string) throws ContentCreationException {
        throw new ContentCreationException();
    }

    public String getName() {
        return this.entryName;
    }

    public Object getContentId() {
        return this.name;
    }

    public Object getAttribute(String string, String string2) {
        if ("org.jfree.repository".equals(string)) {
            if ("size".equals(string2)) {
                return new Long(this.size);
            }
            if ("version".equals(string2)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(string) && "comment".equals(string2)) {
            return this.comment;
        }
        return null;
    }

    public boolean setAttribute(String string, String string2, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }
}

