/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Enum;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.MemoryUtil;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"StructLayout"}, parent="Object")
public final class StructLayout
extends Type {
    static final Storage nullStorage = new NullStorage();
    static final String CLASS_NAME = "StructLayout";
    private final Map<IRubyObject, Member> fieldMap;
    private final List<RubySymbol> fieldNames;
    private final List<Field> fields;
    private final List<Member> members;
    private final int cacheableFieldCount;
    private final int referenceFieldCount;

    public static RubyClass createStructLayoutClass(Ruby runtime2, RubyModule module) {
        RubyClass layoutClass = runtime2.defineClassUnder(CLASS_NAME, module.fastGetClass("Type"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, module);
        layoutClass.defineAnnotatedMethods(StructLayout.class);
        layoutClass.defineAnnotatedConstants(StructLayout.class);
        RubyClass arrayClass = runtime2.defineClassUnder("ArrayProxy", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        arrayClass.includeModule(runtime2.getEnumerable());
        arrayClass.defineAnnotatedMethods(ArrayProxy.class);
        RubyClass charArrayClass = runtime2.defineClassUnder("CharArrayProxy", arrayClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        charArrayClass.defineAnnotatedMethods(CharArrayProxy.class);
        RubyClass fieldClass = runtime2.defineClassUnder("Field", runtime2.getObject(), FieldAllocator.INSTANCE, layoutClass);
        fieldClass.defineAnnotatedMethods(Field.class);
        RubyClass scalarFieldClass = runtime2.defineClassUnder("Scalar", fieldClass, ScalarFieldAllocator.INSTANCE, layoutClass);
        scalarFieldClass.defineAnnotatedMethods(ScalarField.class);
        RubyClass enumFieldClass = runtime2.defineClassUnder("Enum", fieldClass, EnumFieldAllocator.INSTANCE, layoutClass);
        enumFieldClass.defineAnnotatedMethods(EnumField.class);
        RubyClass stringFieldClass = runtime2.defineClassUnder("String", fieldClass, StringFieldAllocator.INSTANCE, layoutClass);
        stringFieldClass.defineAnnotatedMethods(StringField.class);
        RubyClass pointerFieldClass = runtime2.defineClassUnder("Pointer", fieldClass, PointerFieldAllocator.INSTANCE, layoutClass);
        pointerFieldClass.defineAnnotatedMethods(PointerField.class);
        RubyClass functionFieldClass = runtime2.defineClassUnder("Function", fieldClass, FunctionFieldAllocator.INSTANCE, layoutClass);
        functionFieldClass.defineAnnotatedMethods(FunctionField.class);
        RubyClass innerStructFieldClass = runtime2.defineClassUnder("InnerStruct", fieldClass, InnerStructFieldAllocator.INSTANCE, layoutClass);
        innerStructFieldClass.defineAnnotatedMethods(InnerStructField.class);
        RubyClass arrayFieldClass = runtime2.defineClassUnder("Array", fieldClass, ArrayFieldAllocator.INSTANCE, layoutClass);
        arrayFieldClass.defineAnnotatedMethods(ArrayField.class);
        return layoutClass;
    }

    StructLayout(Ruby runtime2, Collection<RubySymbol> fieldNames, Map<IRubyObject, Field> fields2, int size2, int alignment2) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME), fieldNames, fields2, size2, alignment2);
    }

    StructLayout(Ruby runtime2, RubyClass klass, Collection<RubySymbol> fieldNames, Map<IRubyObject, Field> fields2, int size2, int alignment2) {
        super(runtime2, klass, NativeType.STRUCT, size2, alignment2);
        int cfCount = 0;
        int refCount = 0;
        ArrayList<Field> fieldList = new ArrayList<Field>(fieldNames.size());
        LinkedHashMap<RubySymbol, Member> memberMap = new LinkedHashMap<RubySymbol, Member>(fieldNames.size());
        int index2 = 0;
        for (RubySymbol fieldName : fieldNames) {
            Field f = fields2.get(fieldName);
            fieldList.add(f);
            int cfIndex = f.isCacheable() ? cfCount++ : -1;
            int refIndex = f.isValueReferenceNeeded() ? refCount++ : -1;
            memberMap.put(fieldName, new Member(f, index2, cfIndex, refIndex));
            fieldList.add(f);
        }
        this.cacheableFieldCount = cfCount;
        this.referenceFieldCount = refCount;
        this.fieldNames = Collections.unmodifiableList(new ArrayList<RubySymbol>(fieldNames));
        this.fields = Collections.unmodifiableList(fieldList);
        this.fieldMap = Collections.unmodifiableMap(memberMap);
        this.members = Collections.unmodifiableList(new ArrayList(memberMap.values()));
    }

    @JRubyMethod(name={"get"}, required=2)
    public IRubyObject get(ThreadContext context, IRubyObject ptr, IRubyObject name2) {
        return this.getValue(context, name2, nullStorage, ptr);
    }

    @JRubyMethod(name={"put"}, required=3)
    public IRubyObject put(ThreadContext context, IRubyObject ptr, IRubyObject name2, IRubyObject value2) {
        this.putValue(context, name2, nullStorage, ptr, value2);
        return value2;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        RubyArray mbrs = RubyArray.newArray(context.getRuntime());
        for (RubySymbol name2 : this.fieldNames) {
            mbrs.append(name2);
        }
        return mbrs;
    }

    @JRubyMethod(name={"offsets"})
    public IRubyObject offsets(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray offsets2 = RubyArray.newArray(runtime2);
        for (RubySymbol name2 : this.fieldNames) {
            RubyArray offset2 = RubyArray.newArray(runtime2);
            offset2.append(name2);
            offset2.append(runtime2.newFixnum(this.fieldMap.get((Object)name2).offset));
            offsets2.append(offset2);
        }
        return offsets2;
    }

    @Override
    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.getNativeSize());
    }

    @Override
    @JRubyMethod(name={"alignment"})
    public IRubyObject alignment(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.getNativeAlignment());
    }

    @JRubyMethod(name={"offset_of"})
    public IRubyObject offset_of(ThreadContext context, IRubyObject fieldName) {
        Member member = this.getMember(context.getRuntime(), fieldName);
        return RubyFixnum.newFixnum(context.getRuntime(), member.offset);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(ThreadContext context, IRubyObject fieldName) {
        return this.getField(context.getRuntime(), fieldName);
    }

    @JRubyMethod
    public IRubyObject fields(ThreadContext context) {
        return RubyArray.newArray(context.getRuntime(), this.fields);
    }

    final IRubyObject getValue(ThreadContext context, IRubyObject name2, Storage cache, IRubyObject ptr) {
        return this.getMember(context.getRuntime(), name2).get(context, cache, ptr);
    }

    final void putValue(ThreadContext context, IRubyObject name2, Storage cache, IRubyObject ptr, IRubyObject value2) {
        this.getMember(context.getRuntime(), name2).put(context, cache, ptr, value2);
    }

    final Member getMember(Ruby runtime2, IRubyObject name2) {
        Member f = this.fieldMap.get(name2);
        if (f != null) {
            return f;
        }
        throw runtime2.newArgumentError("Unknown field: " + name2);
    }

    final Field getField(Ruby runtime2, IRubyObject name2) {
        return this.getMember((Ruby)runtime2, (IRubyObject)name2).field;
    }

    public final int getMinimumAlignment() {
        return this.getNativeAlignment();
    }

    public final int getSize() {
        return this.getNativeSize();
    }

    final int getReferenceFieldCount() {
        return this.referenceFieldCount;
    }

    final int getReferenceFieldIndex(Member member) {
        return member.referenceIndex;
    }

    final int getCacheableFieldCount() {
        return this.cacheableFieldCount;
    }

    final int getCacheableFieldIndex(Member member) {
        return member.cacheIndex;
    }

    public final int getFieldCount() {
        return this.fields.size();
    }

    public final Collection<Field> getFields() {
        return this.fields;
    }

    public final Collection<Member> getMembers() {
        return this.members;
    }

    static final class ArrayFieldIO
    implements FieldIO {
        private final Type.Array arrayType;
        private final MemoryOp op;

        public ArrayFieldIO(Type.Array arrayType) {
            this.arrayType = arrayType;
            this.op = MemoryOp.getMemoryOp(arrayType.getComponentType());
            if (this.op == null) {
                throw arrayType.getRuntime().newNotImplementedError("unsupported array field type: " + arrayType);
            }
        }

        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            if (!this.isCharArray() || !(value2 instanceof RubyString)) {
                throw context.getRuntime().newNotImplementedError("cannot set array field");
            }
            ByteList bl = value2.convertToString().getByteList();
            m.getMemoryIO(ptr).putZeroTerminatedByteArray(m.offset, bl.getUnsafeBytes(), bl.begin(), Math.min(bl.length(), this.arrayType.length() - 1));
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            IRubyObject s = cache.getCachedValue(m);
            if (s == null) {
                s = this.isCharArray() ? new CharArrayProxy(context.getRuntime(), ptr, m.offset, this.arrayType, this.op) : new ArrayProxy(context.getRuntime(), ptr, m.offset, this.arrayType, this.op);
                cache.putCachedValue(m, s);
            }
            return s;
        }

        private final boolean isCharArray() {
            return this.arrayType.getComponentType().nativeType == NativeType.CHAR || this.arrayType.getComponentType().nativeType == NativeType.UCHAR;
        }

        public final boolean isCacheable() {
            return true;
        }

        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static final class InnerStructFieldIO
    implements FieldIO {
        private final StructByValue sbv;

        public InnerStructFieldIO(StructByValue sbv) {
            this.sbv = sbv;
        }

        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            throw context.getRuntime().newNotImplementedError("Cannot set Struct fields");
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            IRubyObject s = cache.getCachedValue(m);
            if (s == null) {
                s = this.sbv.getStructClass().newInstance(context, new IRubyObject[]{((AbstractMemory)ptr).slice(context.getRuntime(), m.getOffset(ptr))}, Block.NULL_BLOCK);
                cache.putCachedValue(m, s);
            }
            return s;
        }

        public final boolean isCacheable() {
            return true;
        }

        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static final class FunctionFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new FunctionFieldIO();

        FunctionFieldIO() {
        }

        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            if (value2.isNil()) {
                m.getMemoryIO(ptr).putAddress(m.getOffset(ptr), 0L);
            } else {
                Pointer cb = Factory.getInstance().getCallbackManager().getCallback(context.getRuntime(), (CallbackInfo)m.type, value2);
                m.getMemoryIO(ptr).putMemoryIO(m.getOffset(ptr), cb.getMemoryIO());
                cache.putCachedValue(m, cb);
                cache.putReference(m, cb);
            }
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            return Factory.getInstance().newFunction(context.getRuntime(), ((Pointer)ptr).getPointer(context.getRuntime(), m.getOffset(ptr)), (CallbackInfo)m.type);
        }

        public final boolean isCacheable() {
            return true;
        }

        public final boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class StringFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new StringFieldIO();

        StringFieldIO() {
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            DirectMemoryIO io2 = m.getMemoryIO(ptr).getMemoryIO(m.getOffset(ptr));
            if (io2 == null || io2.isNull()) {
                return context.getRuntime().getNil();
            }
            return RubyString.newStringNoCopy(context.getRuntime(), io2.getZeroTerminatedByteArray(0L));
        }

        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            ByteList bl = value2.convertToString().getByteList();
            MemoryPointer mem = MemoryPointer.allocate(context.getRuntime(), 1, bl.length() + 1, false);
            cache.putReference(m, mem);
            MemoryIO io2 = mem.getMemoryIO();
            io2.put(0L, bl.getUnsafeBytes(), bl.begin(), bl.length());
            io2.putByte(bl.length(), (byte)0);
            m.getMemoryIO(ptr).putMemoryIO(m.getOffset(ptr), io2);
        }

        public final boolean isCacheable() {
            return false;
        }

        public final boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class PointerFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new PointerFieldIO();

        PointerFieldIO() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            if (value2 instanceof Pointer) {
                m.getMemoryIO(ptr).putMemoryIO(m.offset, ((Pointer)value2).getMemoryIO());
            } else if (value2 instanceof Struct) {
                MemoryIO mem = ((Struct)value2).getMemoryIO();
                if (!(mem instanceof DirectMemoryIO)) {
                    throw context.getRuntime().newArgumentError("Struct memory not backed by a native pointer");
                }
                m.getMemoryIO(ptr).putMemoryIO(m.offset, mem);
            } else if (value2 instanceof RubyInteger) {
                m.getMemoryIO(ptr).putAddress(m.offset, Util.int64Value(ptr));
            } else if (value2.respondsTo("to_ptr")) {
                IRubyObject addr2 = value2.callMethod(context, "to_ptr");
                if (!(addr2 instanceof Pointer)) throw context.getRuntime().newArgumentError("Invalid pointer value");
                m.getMemoryIO(ptr).putMemoryIO(m.offset, ((Pointer)addr2).getMemoryIO());
            } else {
                if (!value2.isNil()) throw context.getRuntime().newArgumentError("Invalid pointer value");
                m.getMemoryIO(ptr).putAddress(m.offset, 0L);
            }
            cache.putReference(m, value2);
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            MemoryIO oldMemory;
            DirectMemoryIO memory = ((AbstractMemory)ptr).getMemoryIO().getMemoryIO(m.getOffset(ptr));
            IRubyObject old = cache.getCachedValue(m);
            if (old instanceof Pointer && memory.equals(oldMemory = ((Pointer)old).getMemoryIO())) {
                return old;
            }
            Pointer retval = new Pointer(context.getRuntime(), memory);
            cache.putCachedValue(m, retval);
            return retval;
        }

        public final boolean isCacheable() {
            return true;
        }

        public final boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class EnumFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new EnumFieldIO();

        EnumFieldIO() {
        }

        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            m.getMemoryIO(ptr).putInt(m.offset, RubyNumeric.num2int(m.type.callMethod(context, "find", value2)));
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            return m.type.callMethod(context, "find", (IRubyObject)context.getRuntime().newFixnum(m.getMemoryIO(ptr).getInt(m.offset)));
        }

        public final boolean isCacheable() {
            return false;
        }

        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static final class ScalarFieldIO
    implements FieldIO {
        private final MemoryOp op;

        ScalarFieldIO(Type type2) {
            this.op = MemoryOp.getMemoryOp(type2);
        }

        ScalarFieldIO(MemoryOp op) {
            this.op = op;
        }

        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            this.op.put(context.getRuntime(), m.getMemoryIO(ptr), (long)m.offset, value2);
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            return this.op.get(context.getRuntime(), m.getMemoryIO(ptr), (long)m.offset);
        }

        public final boolean isCacheable() {
            return false;
        }

        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    @JRubyClass(name={"FFI::StructLayout::CharArrayProxy"}, parent="FFI::StructLayout::ArrayProxy")
    public static final class CharArrayProxy
    extends ArrayProxy {
        CharArrayProxy(Ruby runtime2, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("CharArrayProxy"), ptr, offset2, type2, aio);
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject to_s(ThreadContext context) {
            return MemoryUtil.getTaintedString(context.getRuntime(), this.ptr.getMemoryIO(), 0L, this.arrayType.length());
        }
    }

    @JRubyClass(name={"FFI::StructLayout::ArrayProxy"}, parent="Object")
    public static class ArrayProxy
    extends RubyObject {
        protected final AbstractMemory ptr;
        final MemoryOp aio;
        protected final Type.Array arrayType;

        ArrayProxy(Ruby runtime2, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            this(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("ArrayProxy"), ptr, offset2, type2, aio);
        }

        ArrayProxy(Ruby runtime2, RubyClass klass, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            super(runtime2, klass);
            this.ptr = ((AbstractMemory)ptr).slice(runtime2, offset2, type2.getNativeSize());
            this.arrayType = type2;
            this.aio = aio;
        }

        private final long getOffset(IRubyObject index2) {
            return this.getOffset(Util.int32Value(index2));
        }

        private final long getOffset(int index2) {
            if (index2 < 0 || index2 >= this.arrayType.length()) {
                throw this.getRuntime().newIndexError("index " + index2 + " out of bounds");
            }
            return index2 * this.arrayType.getComponentType().getNativeSize();
        }

        private IRubyObject get(Ruby runtime2, int index2) {
            return this.aio.get(runtime2, this.ptr, this.getOffset(index2));
        }

        @JRubyMethod(name={"[]"})
        public IRubyObject get(ThreadContext context, IRubyObject index2) {
            return this.aio.get(context.getRuntime(), this.ptr, this.getOffset(index2));
        }

        @JRubyMethod(name={"[]="})
        public IRubyObject put(ThreadContext context, IRubyObject index2, IRubyObject value2) {
            this.aio.put(context.getRuntime(), this.ptr, this.getOffset(index2), value2);
            return value2;
        }

        @JRubyMethod(name={"to_a", "to_ary"})
        public IRubyObject get(ThreadContext context) {
            Ruby runtime2 = context.getRuntime();
            IRubyObject[] elems = new IRubyObject[this.arrayType.length()];
            for (int i = 0; i < elems.length; ++i) {
                elems[i] = this.get(runtime2, i);
            }
            return RubyArray.newArrayNoCopy(runtime2, elems);
        }

        @JRubyMethod(name={"to_ptr"})
        public IRubyObject to_ptr(ThreadContext context) {
            return this.ptr;
        }

        @JRubyMethod(name={"size"})
        public IRubyObject size(ThreadContext context) {
            return context.getRuntime().newFixnum(this.arrayType.getNativeSize());
        }

        @JRubyMethod(name={"each"}, frame=true)
        public IRubyObject each(ThreadContext context, Block block) {
            if (!block.isGiven()) {
                throw context.getRuntime().newLocalJumpErrorNoBlock();
            }
            for (int i = 0; i < this.arrayType.length(); ++i) {
                block.yield(context, this.get(context.getRuntime(), i));
            }
            return this;
        }
    }

    static class NullStorage
    implements Storage {
        NullStorage() {
        }

        public IRubyObject getCachedValue(Member member) {
            return null;
        }

        public void putCachedValue(Member member, IRubyObject value2) {
        }

        public void putReference(Member member, IRubyObject value2) {
        }
    }

    public static interface Storage {
        public IRubyObject getCachedValue(Member var1);

        public void putCachedValue(Member var1, IRubyObject var2);

        public void putReference(Member var1, IRubyObject var2);
    }

    @JRubyClass(name={"FFI::StructLayout::Array"}, parent="FFI::StructLayout::Field")
    public static final class ArrayField
    extends Field {
        public ArrayField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        public ArrayField(Ruby runtime2, Type.Array arrayType, int offset2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Array"), arrayType, offset2, new ArrayFieldIO(arrayType));
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject offset2) {
            if (!(type2 instanceof Type.Array)) {
                throw context.getRuntime().newTypeError(type2, context.getRuntime().fastGetModule("FFI").fastGetClass("Type").fastGetClass("Array"));
            }
            this.init(type2, offset2, new ArrayFieldIO((Type.Array)type2));
            return this;
        }
    }

    private static final class ArrayFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new ArrayFieldAllocator();

        private ArrayFieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new ArrayField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::InnerStruct"}, parent="FFI::StructLayout::Field")
    public static final class InnerStructField
    extends Field {
        public InnerStructField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        public InnerStructField(Ruby runtime2, StructByValue sbv, int offset2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("InnerStruct"), sbv, offset2, new InnerStructFieldIO(sbv));
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject offset2) {
            if (!(type2 instanceof StructByValue)) {
                throw context.getRuntime().newTypeError(type2, context.getRuntime().fastGetModule("FFI").fastGetClass("Type").fastGetClass("Struct"));
            }
            this.init(type2, offset2, new InnerStructFieldIO((StructByValue)type2));
            return this;
        }
    }

    private static final class InnerStructFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new InnerStructFieldAllocator();

        private InnerStructFieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new InnerStructField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Function"}, parent="FFI::StructLayout::Field")
    public static final class FunctionField
    extends Field {
        public FunctionField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        public FunctionField(Ruby runtime2, CallbackInfo sbv, int offset2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Function"), sbv, offset2, FunctionFieldIO.INSTANCE);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject offset2) {
            if (!(type2 instanceof CallbackInfo)) {
                throw context.getRuntime().newTypeError(type2, context.getRuntime().fastGetModule("FFI").fastGetClass("Type").fastGetClass("Function"));
            }
            this.init(type2, offset2, new FunctionFieldIO());
            return this;
        }
    }

    private static final class FunctionFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new FunctionFieldAllocator();

        private FunctionFieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new FunctionField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Pointer"}, parent="FFI::StructLayout::Field")
    public static final class PointerField
    extends Field {
        public PointerField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, PointerFieldIO.INSTANCE);
        }

        public PointerField(Ruby runtime2, Type.Builtin type2, int offset2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Pointer"), type2, offset2, PointerFieldIO.INSTANCE);
        }
    }

    private static final class PointerFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new PointerFieldAllocator();

        private PointerFieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new PointerField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::String"}, parent="FFI::StructLayout::Field")
    static final class StringField
    extends Field {
        public StringField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, StringFieldIO.INSTANCE);
        }

        public StringField(Ruby runtime2, Type.Builtin type2, int offset2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("String"), type2, offset2, StringFieldIO.INSTANCE);
        }
    }

    private static final class StringFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new StringFieldAllocator();

        private StringFieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StringField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Enum"}, parent="FFI::StructLayout::Field")
    public static final class EnumField
    extends Field {
        public EnumField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, EnumFieldIO.INSTANCE);
        }

        public EnumField(Ruby runtime2, Enum type2, int offset2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Enum"), type2, offset2, EnumFieldIO.INSTANCE);
        }
    }

    private static final class EnumFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new EnumFieldAllocator();

        private EnumFieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new EnumField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Scalar"}, parent="FFI::StructLayout::Field")
    public static final class ScalarField
    extends Field {
        public ScalarField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass);
        }

        public ScalarField(Ruby runtime2, Type.Builtin type2, int offset2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Scalar"), type2, offset2, new ScalarFieldIO(type2));
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject offset2) {
            this.init(type2, offset2, new ScalarFieldIO(this.checkType(type2)));
            return this;
        }
    }

    private static final class ScalarFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new ScalarFieldAllocator();

        private ScalarFieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new ScalarField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Field"}, parent="Object")
    public static class Field
    extends RubyObject {
        FieldIO io;
        private Type type;
        private int offset;

        Field(Ruby runtime2, RubyClass klass) {
            this(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        Field(Ruby runtime2, RubyClass klass, FieldIO io2) {
            this(runtime2, klass, (Type)runtime2.fastGetModule("FFI").fastGetClass("Type").fastGetConstant("VOID"), -1, io2);
        }

        Field(Ruby runtime2, RubyClass klass, Type type2, int offset2, FieldIO io2) {
            super(runtime2, klass);
            this.type = type2;
            this.offset = offset2;
            this.io = io2;
        }

        void init(IRubyObject type2, IRubyObject offset2) {
            this.type = this.checkType(type2);
            this.offset = RubyNumeric.num2int(offset2);
        }

        void init(IRubyObject type2, IRubyObject offset2, FieldIO io2) {
            this.init(type2, offset2);
            this.io = io2;
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject offset2) {
            this.init(type2, offset2);
            return this;
        }

        final Type checkType(IRubyObject type2) {
            if (!(type2 instanceof Type)) {
                throw this.getRuntime().newTypeError(type2, this.getRuntime().fastGetModule("FFI").fastGetClass("Type"));
            }
            return (Type)type2;
        }

        public final int offset() {
            return this.offset;
        }

        public final Type ffiType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            return obj instanceof Field && ((Field)obj).offset == this.offset;
        }

        public int hashCode() {
            return 265 + (this.offset ^ this.offset >>> 32);
        }

        public final boolean isCacheable() {
            return this.io.isCacheable();
        }

        public final boolean isValueReferenceNeeded() {
            return this.io.isValueReferenceNeeded();
        }

        @JRubyMethod
        public final IRubyObject size(ThreadContext context) {
            return context.getRuntime().newFixnum(this.type.getNativeSize());
        }

        @JRubyMethod
        public final IRubyObject alignment(ThreadContext context) {
            return context.getRuntime().newFixnum(this.type.getNativeAlignment());
        }

        @JRubyMethod
        public final IRubyObject offset(ThreadContext context) {
            return context.getRuntime().newFixnum(this.offset);
        }

        @JRubyMethod(name={"type", "ffi_type"})
        public final IRubyObject type(ThreadContext context) {
            return this.type;
        }
    }

    private static final class FieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new FieldAllocator();

        private FieldAllocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new Field(runtime2, klass);
        }
    }

    static final class DefaultFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new DefaultFieldIO();

        DefaultFieldIO() {
        }

        public IRubyObject get(ThreadContext context, Storage cache, Member m, IRubyObject ptr) {
            return m.field.callMethod(context, "get", ptr);
        }

        public void put(ThreadContext context, Storage cache, Member m, IRubyObject ptr, IRubyObject value2) {
            m.field.callMethod(context, "put", new IRubyObject[]{ptr, value2});
        }

        public final boolean isCacheable() {
            return false;
        }

        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static interface FieldIO {
        public void put(ThreadContext var1, Storage var2, Member var3, IRubyObject var4, IRubyObject var5);

        public IRubyObject get(ThreadContext var1, Storage var2, Member var3, IRubyObject var4);

        public boolean isCacheable();

        public boolean isValueReferenceNeeded();
    }

    public static final class Member {
        final FieldIO io;
        final Field field;
        final Type type;
        final int offset;
        final int cacheIndex;
        final int referenceIndex;
        final int index;

        protected Member(Field f, int index2, int cacheIndex, int referenceIndex) {
            this.field = f;
            this.io = f.io;
            this.type = f.type;
            this.offset = f.offset;
            this.index = index2;
            this.cacheIndex = cacheIndex;
            this.referenceIndex = referenceIndex;
        }

        final MemoryIO getMemoryIO(IRubyObject ptr) {
            return ((AbstractMemory)ptr).getMemoryIO();
        }

        final long getOffset(IRubyObject ptr) {
            return this.offset;
        }

        final int getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            return obj instanceof Member && ((Member)obj).offset == this.offset && this.type.equals(((Member)obj).type);
        }

        public int hashCode() {
            return 265 + (this.offset ^ this.offset >>> 32) + 37 * this.type.hashCode();
        }

        public final void put(ThreadContext context, Storage cache, IRubyObject ptr, IRubyObject value2) {
            this.io.put(context, cache, this, ptr, value2);
        }

        public final IRubyObject get(ThreadContext context, Storage cache, IRubyObject ptr) {
            return this.io.get(context, cache, this, ptr);
        }

        public final int offset() {
            return this.offset;
        }

        public final Type type() {
            return this.type;
        }
    }
}

