/*
 * Decompiled with CFR 0.152.
 */
package sun.jkernel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import sun.jkernel.BundleCheck;
import sun.jkernel.DownloadManager;
import sun.jkernel.Mutex;

public class Bundle {
    private static final String BUNDLE_JAR_ENTRY_NAME = "classes.jar";
    protected static final int NOT_DOWNLOADED = 0;
    protected static final int QUEUED = 1;
    protected static final int DOWNLOADED = 2;
    protected static final int INSTALLED = 3;
    private static ExecutorService threadPool;
    static final int THREADS;
    private static Mutex receiptsMutex;
    private static Map<String, Bundle> bundles;
    static Set<String> receipts;
    private static int bytesDownloaded;
    private static File receiptPath;
    private static int receiptsSize;
    private String name;
    private File localPath;
    private File jarPath;
    private File lowJarPath;
    private File lowJavaPath = null;
    protected int state;
    protected boolean deleteOnInstall = true;

    public static native boolean extraCompress(String var0, String var1) throws IOException;

    public static native boolean extraUncompress(String var0, String var1) throws IOException;

    private static Mutex getReceiptsMutex() {
        if (receiptsMutex == null) {
            receiptsMutex = Mutex.create(DownloadManager.MUTEX_PREFIX + "receipts");
        }
        return receiptsMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void loadReceipts() {
        block18: {
            Bundle.getReceiptsMutex().acquire();
            try {
                int n;
                if (!receiptPath.exists() || (n = (int)receiptPath.length()) == receiptsSize) break block18;
                FilterInputStream filterInputStream = null;
                try {
                    receipts.clear();
                    Object object = DownloadManager.getBundleNames();
                    int n2 = ((String[])object).length;
                    for (int i = 0; i < n2; ++i) {
                        String string = object[i];
                        if (!"true".equals(DownloadManager.getBundleProperty(string, "install"))) continue;
                        receipts.add(string);
                    }
                    if (receiptPath.exists()) {
                        filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(receiptPath)));
                        while ((object = ((DataInputStream)filterInputStream).readLine()) != null) {
                            receipts.add(((String)object).trim());
                        }
                    }
                    receiptsSize = n;
                }
                catch (IOException iOException) {
                    DownloadManager.log(iOException);
                }
                finally {
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException) {
                            DownloadManager.log(iOException);
                        }
                    }
                }
            }
            finally {
                Bundle.getReceiptsMutex().release();
            }
        }
    }

    public static synchronized Bundle getBundle(String string) throws IOException {
        Bundle bundle = bundles.get(string);
        if (bundle == null && (string.equals("merged") || Arrays.asList(DownloadManager.getBundleNames()).contains(string))) {
            bundle = new Bundle();
            bundle.name = string;
            if (DownloadManager.isWindowsVista()) {
                bundle.localPath = new File(DownloadManager.getLocalLowTempBundlePath(), string + ".zip");
                bundle.lowJavaPath = new File(DownloadManager.getLocalLowKernelJava() + string);
            } else {
                bundle.localPath = new File(DownloadManager.getBundlePath(), string + ".zip");
            }
            String string2 = DownloadManager.getBundleProperty(string, "jarpath");
            if (string2 != null) {
                if (DownloadManager.isWindowsVista()) {
                    bundle.lowJarPath = new File(DownloadManager.getLocalLowKernelJava() + string, string2);
                }
                bundle.jarPath = new File(DownloadManager.JAVA_HOME, string2);
            } else {
                if (DownloadManager.isWindowsVista()) {
                    bundle.lowJarPath = new File(DownloadManager.getLocalLowKernelJava() + string + "\\lib\\bundles", string + ".jar");
                }
                bundle.jarPath = new File(DownloadManager.getBundlePath(), string + ".jar");
            }
            bundles.put(string, bundle);
        }
        return bundle;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public File getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(File file) {
        this.localPath = file;
    }

    public File getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(File file) {
        this.jarPath = file;
    }

    public int getSize() {
        return Integer.valueOf(DownloadManager.getBundleProperty(this.getName(), "size"));
    }

    public boolean getDeleteOnInstall() {
        return this.deleteOnInstall;
    }

    public void setDeleteOnInstall(boolean bl) {
        this.deleteOnInstall = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateState() {
        Class<Bundle> clazz = Bundle.class;
        synchronized (Bundle.class) {
            Bundle.loadReceipts();
            if (receipts.contains(this.name) || "true".equals(DownloadManager.getBundleProperty(this.name, "install"))) {
                this.state = 3;
            } else if (this.localPath.exists()) {
                this.state = 2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private String getURL(boolean bl) throws IOException {
        Properties properties = DownloadManager.getBundleURLs(bl);
        String string = properties.getProperty(this.name + ".zip");
        if (string == null && (string = properties.getProperty(this.name)) == null) {
            DownloadManager.log("Unable to determine bundle URL for " + this);
            DownloadManager.log("Bundle URLs: " + properties);
            DownloadManager.sendErrorPing(6);
            throw new NullPointerException("Unable to determine URL for bundle: " + this);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(boolean bl) {
        if (DownloadManager.isJREComplete()) {
            return;
        }
        Mutex mutex = Mutex.create(DownloadManager.MUTEX_PREFIX + this.name + ".download");
        mutex.acquire();
        try {
            boolean bl2;
            long l = System.currentTimeMillis();
            do {
                bl2 = false;
                this.updateState();
                if (this.state == 2 || this.state == 3) {
                    return;
                }
                File file = null;
                try {
                    Object object;
                    Object object2;
                    file = new File(this.localPath + ".tmp");
                    if (DownloadManager.getBaseDownloadURL().equals("internal-resource/")) {
                        object2 = "/" + this.name + ".zip";
                        object = this.getClass().getResourceAsStream((String)object2);
                        if (object == null) {
                            throw new IOException("could not locate resource: " + (String)object2);
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        DownloadManager.send((InputStream)object, fileOutputStream);
                        ((InputStream)object).close();
                        fileOutputStream.close();
                    } else {
                        try {
                            object2 = this.getURL(bl);
                            DownloadManager.log("Downloading from: " + (String)object2);
                            DownloadManager.downloadFromURL((String)object2, file, this.name.replace('_', '.'), bl);
                        }
                        catch (HttpRetryException httpRetryException) {
                            DownloadManager.flushBundleURLs();
                            object = this.getURL(bl);
                            DownloadManager.log("Retrying at new URL: " + (String)object);
                            DownloadManager.downloadFromURL((String)object, file, this.name.replace('_', '.'), bl);
                        }
                    }
                    if (!file.exists() || file.length() == 0L) {
                        if (bl) {
                            DownloadManager.complete = true;
                        }
                        DownloadManager.fatalError(0);
                    }
                    object2 = BundleCheck.getInstance(file);
                    object = BundleCheck.getInstance(this.name);
                    if (((BundleCheck)object).equals((BundleCheck)object2)) {
                        long l2 = file.length();
                        this.localPath.delete();
                        File file2 = new File(file.getPath() + ".jar0");
                        if (!Bundle.extraUncompress(file.getPath(), file2.getPath())) {
                            if (DownloadManager.debug) {
                                DownloadManager.log("Uncompressing with GZIP");
                            }
                            GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file), 2048));
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 2048);
                            DownloadManager.send(gZIPInputStream, bufferedOutputStream);
                            gZIPInputStream.close();
                            bufferedOutputStream.close();
                            if (!file2.renameTo(this.localPath)) {
                                throw new IOException("unable to rename " + file2 + " to " + this.localPath);
                            }
                        } else {
                            if (DownloadManager.debug) {
                                DownloadManager.log("Uncompressing with LZMA");
                            }
                            if (!file2.renameTo(this.localPath)) {
                                throw new IOException("unable to rename " + file2 + " to " + this.localPath);
                            }
                        }
                        this.state = 2;
                        bytesDownloaded = (int)((long)bytesDownloaded + l2);
                        long l3 = System.currentTimeMillis() - l;
                        DownloadManager.log("Downloaded " + this.name + " in " + l3 + "ms.  Downloaded " + bytesDownloaded + " bytes this session.");
                    } else {
                        file.delete();
                        DownloadManager.log("DownloadManager: Security check failed for bundle " + this.name);
                        if (bl) {
                            bl2 = DownloadManager.askUserToRetryDownloadOrQuit(0);
                        }
                        if (!bl2) {
                            throw new RuntimeException("Failed bundle security check and user canceled");
                        }
                    }
                }
                catch (IOException iOException) {
                    DownloadManager.log(iOException);
                }
            } while (bl2);
        }
        finally {
            mutex.release();
        }
    }

    void queueDependencies(boolean bl) {
        try {
            String string = DownloadManager.getBundleProperty(this.name, "dependencies");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
                while (stringTokenizer.hasMoreTokens()) {
                    Bundle bundle = Bundle.getBundle(stringTokenizer.nextToken());
                    if (bundle == null || bundle.isInstalled()) continue;
                    if (DownloadManager.debug) {
                        DownloadManager.log("Queueing " + bundle.name + " as a dependency of " + this.name + "...");
                    }
                    bundle.install(bl, true, false);
                }
            }
        }
        catch (IOException iOException) {
            DownloadManager.log(iOException);
        }
    }

    static synchronized ExecutorService getThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newFixedThreadPool(THREADS, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackBundle() throws IOException {
        Object object;
        File file = null;
        if (DownloadManager.isWindowsVista()) {
            file = this.lowJarPath;
            object = file.getParentFile();
            if (object != null) {
                ((File)object).mkdirs();
            }
        } else {
            file = this.jarPath;
        }
        DownloadManager.log("Unpacking " + this + " to " + file);
        object = new FileInputStream(this.localPath);
        JarInputStream jarInputStream = new JarInputStream((InputStream)object){

            @Override
            public void close() throws IOException {
            }
        };
        try {
            JarEntry jarEntry;
            File file2 = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                Object object2;
                File file3;
                String string = jarEntry.getName();
                if (string.equals("classes.pack")) {
                    file3 = new File(file + ".pack");
                    file3.getParentFile().mkdirs();
                    DownloadManager.log("Writing temporary .pack file " + file3);
                    object2 = new FileOutputStream(file3);
                    try {
                        DownloadManager.send(jarInputStream, (OutputStream)object2);
                    }
                    finally {
                        ((OutputStream)object2).close();
                    }
                    file2 = new File(file + ".tmp");
                    DownloadManager.log("Writing temporary .jar file " + file2);
                    Bundle.unpack(file3, file2);
                    file3.delete();
                    continue;
                }
                if (string.startsWith("META-INF")) continue;
                file3 = DownloadManager.isWindowsVista() ? new File(this.lowJavaPath, string.replace('/', File.separatorChar)) : new File(DownloadManager.JAVA_HOME, string.replace('/', File.separatorChar));
                if (string.equals(BUNDLE_JAR_ENTRY_NAME)) {
                    file3 = file;
                }
                object2 = new File(file3 + ".tmp");
                boolean bl = file3.exists();
                if (!bl) {
                    DownloadManager.log(file3 + ".mkdirs()");
                    file3.getParentFile().mkdirs();
                }
                try {
                    DownloadManager.log("Using temporary file " + object2);
                    try (FileOutputStream fileOutputStream = new FileOutputStream((File)object2);){
                        int n;
                        byte[] byArray = new byte[2048];
                        while ((n = jarInputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    if (bl) {
                        file3.delete();
                    }
                    DownloadManager.log("Renaming from " + object2 + " to " + file3);
                    if (((File)object2).renameTo(file3)) continue;
                    throw new IOException("unable to rename " + object2 + " to " + file3);
                }
                catch (IOException iOException) {
                    if (bl) continue;
                    throw iOException;
                }
            }
            if (file2 != null) {
                if (file.exists()) {
                    file2.delete();
                } else if (!file2.renameTo(file)) {
                    throw new IOException("unable to rename " + file2 + " to " + file);
                }
            }
            if (DownloadManager.isWindowsVista()) {
                DownloadManager.log("Using broker to move " + this.name);
                if (!DownloadManager.moveDirWithBroker(DownloadManager.getKernelJREDir() + this.name)) {
                    throw new IOException("unable to create " + this.name);
                }
                DownloadManager.log("Broker finished " + this.name);
            }
            DownloadManager.log("Finished unpacking " + this);
        }
        finally {
            ((InputStream)object).close();
        }
        if (this.deleteOnInstall) {
            this.localPath.delete();
        }
    }

    public static void unpack(File file, File file2) throws IOException {
        Process process = Runtime.getRuntime().exec(DownloadManager.JAVA_HOME + File.separator + "bin" + File.separator + "unpack200 -Hoff \"" + file + "\" \"" + file2 + "\"");
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void install() throws IOException {
        this.install(true, false, true);
    }

    public synchronized void install(final boolean bl, final boolean bl2, boolean bl3) throws IOException {
        if (DownloadManager.isJREComplete()) {
            return;
        }
        if (this.state == 0 || this.state == 1) {
            if (this.state != 1) {
                DownloadManager.addToTotalDownloadSize(this.getSize());
                this.state = 1;
            }
            if (Bundle.getThreadPool().isShutdown()) {
                if (this.state == 0 || this.state == 1) {
                    this.doInstall(bl, bl2);
                }
            } else {
                Future<?> future = Bundle.getThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (Bundle.this.state == 0 || Bundle.this.state == 1 || !bl2 && Bundle.this.state == 2) {
                                Bundle.this.doInstall(bl, bl2);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                this.queueDependencies(bl);
                if (bl3) {
                    try {
                        future.get();
                    }
                    catch (Exception exception) {
                        throw new Error(exception);
                    }
                }
            }
        } else if (this.state == 2 && !bl2) {
            this.doInstall(bl, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInstall(boolean bl, boolean bl2) throws IOException {
        Mutex mutex = Mutex.create(DownloadManager.MUTEX_PREFIX + this.name + ".install");
        DownloadManager.bundleInstallStart();
        try {
            mutex.acquire();
            this.updateState();
            if (this.state == 0 || this.state == 1) {
                this.download(bl);
            }
            if (this.state == 2 && bl2) {
                return;
            }
            if (this.state == 3) {
                return;
            }
            if (this.state != 2) {
                DownloadManager.fatalError(0);
            }
            DownloadManager.log("Calling unpackBundle for " + this);
            this.unpackBundle();
            DownloadManager.log("Writing receipt for " + this);
            this.writeReceipt();
            this.updateState();
            DownloadManager.log("Finished installing " + this + ", state=" + this.state);
        }
        finally {
            if (this.lowJavaPath != null) {
                this.lowJavaPath.delete();
            }
            mutex.release();
            DownloadManager.bundleInstallComplete();
        }
    }

    synchronized void setState(int n) {
        this.state = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstalled() {
        Class<Bundle> clazz = Bundle.class;
        synchronized (Bundle.class) {
            this.updateState();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReceipt() {
        block8: {
            Bundle.getReceiptsMutex().acquire();
            File file = null;
            try {
                try {
                    receipts.add(this.name);
                    if (DownloadManager.isWindowsVista()) {
                        file = new File(DownloadManager.getLocalLowTempBundlePath(), "receipts");
                        if (receiptPath.exists()) {
                            DownloadManager.copyReceiptFile(receiptPath, file);
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(file, receiptPath.exists());
                        fileOutputStream.write((this.name + System.getProperty("line.separator")).getBytes("utf-8"));
                        fileOutputStream.close();
                        if (!DownloadManager.moveFileWithBroker(DownloadManager.getKernelJREDir() + "-bundles" + File.separator + "receipts")) {
                            throw new IOException("failed to write receipts");
                        }
                        break block8;
                    }
                    file = receiptPath;
                    FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                    fileOutputStream.write((this.name + System.getProperty("line.separator")).getBytes("utf-8"));
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DownloadManager.log(iOException);
                }
            }
            finally {
                Bundle.getReceiptsMutex().release();
            }
        }
    }

    public String toString() {
        return "Bundle[" + this.name + "]";
    }

    static {
        String string;
        if (!DownloadManager.jkernelLibLoaded) {
            System.loadLibrary("jkernel");
        }
        THREADS = (string = System.getProperty("kernel.simultaneous.downloads")) != null ? Integer.parseInt(string.trim()) : 1;
        bundles = new HashMap<String, Bundle>();
        receipts = new HashSet<String>();
        receiptPath = new File(DownloadManager.getBundlePath(), "receipts");
    }
}

