/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import sun.security.ssl.CloneableDigest;

final class HandshakeHash {
    private int version = -1;
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private final boolean isServer;
    private MessageDigest md5;
    private MessageDigest sha;
    private final int clonesNeeded;
    private boolean cvAlgDetermined = false;
    private String cvAlg;
    private MessageDigest finMD;

    HandshakeHash(boolean bl, boolean bl2, Set<String> set) {
        this.isServer = bl;
        this.clonesNeeded = bl2 ? 3 : 2;
    }

    void update(byte[] byArray, int n, int n2) {
        switch (this.version) {
            case 1: {
                this.md5.update(byArray, n, n2);
                this.sha.update(byArray, n, n2);
                break;
            }
            default: {
                if (this.finMD != null) {
                    this.finMD.update(byArray, n, n2);
                }
                this.data.write(byArray, n, n2);
            }
        }
    }

    void reset() {
        if (this.version != -1) {
            throw new RuntimeException("reset() can be only be called before protocolDetermined");
        }
        this.data.reset();
    }

    void protocolDetermined(boolean bl) {
        if (this.version != -1) {
            return;
        }
        this.version = bl ? 2 : 1;
        switch (this.version) {
            case 1: {
                try {
                    this.md5 = CloneableDigest.getDigest("MD5", this.clonesNeeded);
                    this.sha = CloneableDigest.getDigest("SHA", this.clonesNeeded);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("Algorithm MD5 or SHA not available", noSuchAlgorithmException);
                }
                byte[] byArray = this.data.toByteArray();
                this.update(byArray, 0, byArray.length);
                break;
            }
        }
    }

    MessageDigest getMD5Clone() {
        if (this.version != 1) {
            throw new RuntimeException("getMD5Clone() can be only be called for TLS 1.1");
        }
        return HandshakeHash.cloneDigest(this.md5);
    }

    MessageDigest getSHAClone() {
        if (this.version != 1) {
            throw new RuntimeException("getSHAClone() can be only be called for TLS 1.1");
        }
        return HandshakeHash.cloneDigest(this.sha);
    }

    private static MessageDigest cloneDigest(MessageDigest messageDigest) {
        try {
            return (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Could not clone digest", cloneNotSupportedException);
        }
    }

    private static String normalizeAlgName(String string) {
        if ((string = string.toUpperCase(Locale.US)).startsWith("SHA")) {
            if (string.length() == 3) {
                return "SHA-1";
            }
            if (string.charAt(3) != '-') {
                return "SHA-" + string.substring(3);
            }
        }
        return string;
    }

    void setFinishedAlg(String string) {
        if (string == null) {
            throw new RuntimeException("setFinishedAlg's argument cannot be null");
        }
        if (this.finMD != null) {
            return;
        }
        try {
            this.finMD = CloneableDigest.getDigest(HandshakeHash.normalizeAlgName(string), 2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        this.finMD.update(this.data.toByteArray());
    }

    void restrictCertificateVerifyAlgs(Set<String> set) {
        if (this.version == 1) {
            throw new RuntimeException("setCertificateVerifyAlg() cannot be called for TLS 1.1");
        }
    }

    void setCertificateVerifyAlg(String string) {
        if (this.cvAlgDetermined) {
            return;
        }
        this.cvAlg = string == null ? null : HandshakeHash.normalizeAlgName(string);
        this.cvAlgDetermined = true;
    }

    byte[] getAllHandshakeMessages() {
        return this.data.toByteArray();
    }

    byte[] getFinishedHash() {
        try {
            return HandshakeHash.cloneDigest(this.finMD).digest();
        }
        catch (Exception exception) {
            throw new Error("BAD");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Test test = new Test();
        test.test(null, "SHA-256");
        test.test("", "SHA-256");
        test.test("SHA-1", "SHA-256");
        test.test("SHA-256", "SHA-256");
        test.test("SHA-384", "SHA-256");
        test.test("SHA-512", "SHA-256");
        test.testSame("sha", "SHA-1");
        test.testSame("SHA", "SHA-1");
        test.testSame("SHA1", "SHA-1");
        test.testSame("SHA-1", "SHA-1");
        test.testSame("SHA256", "SHA-256");
        test.testSame("SHA-256", "SHA-256");
    }

    static class Test {
        Test() {
        }

        void update(HandshakeHash handshakeHash, String string) {
            handshakeHash.update(string.getBytes(), 0, string.length());
        }

        static byte[] digest(String string, String string2) throws Exception {
            return MessageDigest.getInstance(string).digest(string2.getBytes());
        }

        static void equals(byte[] byArray, byte[] byArray2) {
            if (!Arrays.equals(byArray, byArray2)) {
                throw new RuntimeException("Bad");
            }
        }

        void testSame(String string, String string2) {
            System.out.println("testSame: " + string + " " + string2);
            if (!HandshakeHash.normalizeAlgName(string).equals(string2)) {
                throw new RuntimeException("Bad");
            }
        }

        void test(String string, String string2) throws Exception {
            System.out.println("test: " + string + " " + string2);
            byte[] byArray = null;
            HandshakeHash handshakeHash = new HandshakeHash(true, true, null);
            if (string == null) {
                handshakeHash.setCertificateVerifyAlg(string);
            }
            this.update(handshakeHash, "ClientHello,");
            handshakeHash.reset();
            this.update(handshakeHash, "ClientHellov2,");
            handshakeHash.setFinishedAlg(string2);
            handshakeHash.setFinishedAlg("SHA-1");
            handshakeHash.setFinishedAlg("SHA-512");
            this.update(handshakeHash, "More,");
            if (string != null) {
                if (string.isEmpty()) {
                    string = null;
                }
                handshakeHash.setCertificateVerifyAlg(string);
            }
            handshakeHash.setCertificateVerifyAlg("SHA-1");
            handshakeHash.setCertificateVerifyAlg(null);
            handshakeHash.protocolDetermined(true);
            if (string != null) {
                byArray = handshakeHash.getAllHandshakeMessages();
                Test.equals(byArray, "ClientHellov2,More,".getBytes());
            }
            this.update(handshakeHash, "FIN1,");
            byte[] byArray2 = handshakeHash.getFinishedHash();
            Test.equals(byArray2, Test.digest(string2, "ClientHellov2,More,FIN1,"));
            this.update(handshakeHash, "FIN2,");
            byte[] byArray3 = handshakeHash.getFinishedHash();
            Test.equals(byArray3, Test.digest(string2, "ClientHellov2,More,FIN1,FIN2,"));
        }
    }
}

