/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;

public class FullyAutomaticPropertiesPanel
extends JPanel {
    private JTextField tfUserName;
    private JPasswordField tfPassword;
    private UserNameValidator valUserName;
    private JCheckBox cbWriteMapData;
    private JCheckBox cbWriteGpsTraces;
    private JCheckBox cbReadGpsTraces;

    protected JPanel buildUserNamePasswordPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        pnl.add((Component)new JLabel(I18n.tr("Username: ")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfUserName = new JTextField();
        pnl.add((Component)this.tfUserName, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUserName);
        this.valUserName = new UserNameValidator(this.tfUserName);
        this.valUserName.validate();
        gc.anchor = 18;
        gc.fill = 2;
        gc.gridy = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Password: ")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfPassword = new JPasswordField();
        pnl.add((Component)this.tfPassword, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfPassword);
        return pnl;
    }

    public FullyAutomaticPropertiesPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        this.add((Component)this.buildUserNamePasswordPanel(), gc);
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)new JPanel(), gc);
    }

    private static class UserNameValidator
    extends AbstractTextComponentValidator {
        public UserNameValidator(JTextComponent tc) {
            super(tc);
        }

        public boolean isValid() {
            return this.getComponent().getText().trim().length() > 0;
        }

        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter your OSM user name"));
            } else {
                this.feedbackInvalid(I18n.tr("The user name cannot be empty. Please enter your OSM user name"));
            }
        }
    }
}

