/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.tools.ImageProvider;

public class MemberTableLinkedCellRenderer
extends MemberTableCellRenderer {
    static final Image arrowUp = ImageProvider.get("dialogs/relation", "arrowup").getImage();
    static final Image arrowDown = ImageProvider.get("dialogs/relation", "arrowdown").getImage();
    static final Image corners = ImageProvider.get("dialogs/relation", "roundedcorners").getImage();
    static final Image roundabout_right = ImageProvider.get("dialogs/relation", "roundabout_right_tiny").getImage();
    static final Image roundabout_left = ImageProvider.get("dialogs/relation", "roundabout_left_tiny").getImage();
    private WayConnectionType value = new WayConnectionType();

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.reset();
        this.value = (WayConnectionType)value;
        this.renderForeground(isSelected);
        this.setToolTipText(((WayConnectionType)value).getToolTip());
        this.renderBackground(this.getModel(table), null, isSelected);
        return this;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.value == null || !this.value.isValid()) {
            return;
        }
        int ymax = this.getSize().height - 1;
        int xloop = 8;
        int xoff = this.getSize().width / 2;
        if (this.value.isLoop) {
            xoff -= xloop / 2 - 1;
        }
        int w = 2;
        int p = 2 + w + 1;
        int y1 = 0;
        int y2 = 0;
        if (this.value.linkPrev) {
            g.setColor(Color.black);
            g.fillRect(xoff - 1, 0, 3, 1);
            y1 = 0;
        } else if (this.value.isLoop) {
            g.setColor(Color.black);
            y1 = 5;
            g.drawImage(corners, xoff, y1 - 3, xoff + 3, y1, 0, 0, 3, 3, new Color(0, 0, 0, 0), null);
            g.drawImage(corners, xoff + xloop - 2, y1 - 3, xoff + xloop + 1, y1, 2, 0, 5, 3, new Color(0, 0, 0, 0), null);
            g.drawLine(xoff + 3, y1 - 3, xoff + xloop - 3, y1 - 3);
        } else {
            g.setColor(Color.red);
            g.drawRect(xoff - 1, p - 1 - w, w, w);
            y1 = p;
        }
        if (this.value.linkNext) {
            g.setColor(Color.black);
            g.fillRect(xoff - 1, ymax, 3, 1);
            y2 = ymax;
        } else if (this.value.isLoop) {
            g.setColor(Color.black);
            y2 = ymax - 5;
            g.fillRect(xoff - 1, y2 + 2, 3, 3);
            g.drawLine(xoff, y2, xoff, y2 + 2);
            g.drawImage(corners, xoff + xloop - 2, y2 + 1, xoff + xloop + 1, y2 + 4, 2, 2, 5, 5, new Color(0, 0, 0, 0), null);
            g.drawLine(xoff + 3 - 1, y2 + 3, xoff + xloop - 3, y2 + 3);
        } else {
            g.setColor(Color.red);
            g.drawRect(xoff - 1, ymax - p + 1, w, w);
            y2 = ymax - p;
        }
        g.setColor(Color.black);
        g.drawLine(xoff, y1, xoff, y2);
        if (this.value.isLoop) {
            g.drawLine(xoff + xloop, y1, xoff + xloop, y2);
        }
        Image arrow = null;
        switch (this.value.direction) {
            case FORWARD: {
                arrow = arrowDown;
                break;
            }
            case BACKWARD: {
                arrow = arrowUp;
            }
        }
        if (arrow != null && (this.value.linkPrev || this.value.linkNext)) {
            g.drawImage(arrow, xoff - 3, (y1 + y2) / 2 - 2, null);
        } else if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_LEFT) {
            g.drawImage(roundabout_left, xoff - 6, 1, null);
        } else if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_RIGHT) {
            g.drawImage(roundabout_right, xoff - 6, 1, null);
        }
    }
}

