/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected Collection<OsmPrimitive> primitives;
    protected JTextArea textArea;

    public InspectPrimitiveDialog(Collection<OsmPrimitive> primitives) {
        super(Main.parent, I18n.tr("Advanced object info"), new String[]{"Close"});
        this.primitives = primitives;
        this.setPreferredSize(new Dimension(450, 350));
        this.setButtonIcons(new String[]{"ok.png"});
        JPanel p = this.buildPanel();
        this.textArea.setText(this.buildText());
        this.setContent(p, false);
    }

    protected JPanel buildPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Monospaced", this.textArea.getFont().getStyle(), this.textArea.getFont().getSize()));
        this.textArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.textArea);
        p.add((Component)scroll, GBC.std().fill());
        return p;
    }

    protected String buildText() {
        StringBuffer s = new StringBuffer();
        for (Node n : new DatasetCollection(this.primitives, OsmPrimitive.nodePredicate)) {
            s.append("Node id=" + n.getUniqueId());
            if (!this.checkDataSet(n)) {
                s.append(" not in data set");
                continue;
            }
            if (n.isIncomplete()) {
                s.append(" incomplete\n");
                this.addWayReferrer(s, n);
                this.addRelationReferrer(s, n);
                continue;
            }
            s.append(String.format(" lat=%s; lon=%s; ", Double.toString(n.getCoor().lat()), Double.toString(n.getCoor().lon())));
            this.addCommon(s, n);
            this.addAttributes(s, n);
            this.addWayReferrer(s, n);
            this.addRelationReferrer(s, n);
            s.append('\n');
        }
        for (Way w : new DatasetCollection(this.primitives, OsmPrimitive.wayPredicate)) {
            s.append("Way id=" + w.getUniqueId());
            if (!this.checkDataSet(w)) {
                s.append(" not in data set");
                continue;
            }
            if (w.isIncomplete()) {
                s.append(" incomplete\n");
                this.addRelationReferrer(s, w);
                continue;
            }
            s.append(String.format(" %d nodes; ", w.getNodes().size()));
            this.addCommon(s, w);
            this.addAttributes(s, w);
            this.addRelationReferrer(s, w);
            s.append("  nodes:\n");
            for (Node n : w.getNodes()) {
                s.append(String.format("    %d\n", n.getUniqueId()));
            }
            s.append('\n');
        }
        for (Relation r : new DatasetCollection(this.primitives, OsmPrimitive.relationPredicate)) {
            s.append("Relation id=" + r.getUniqueId());
            if (!this.checkDataSet(r)) {
                s.append(" not in data set");
                continue;
            }
            if (r.isIncomplete()) {
                s.append(" incomplete\n");
                this.addRelationReferrer(s, r);
                continue;
            }
            s.append(String.format(" %d members; ", r.getMembersCount()));
            this.addCommon(s, r);
            this.addAttributes(s, r);
            this.addRelationReferrer(s, r);
            s.append("  members:\n");
            for (RelationMember m : r.getMembers()) {
                s.append(String.format("    %d %s\n", m.getMember().getUniqueId(), m.getRole()));
            }
            s.append('\n');
        }
        return s.toString().trim();
    }

    protected void addCommon(StringBuffer s, OsmPrimitive o) {
        s.append(String.format("Data set: %X; User: [%s]; ChangeSet id: %H; Timestamp: %s, Version: %d", o.getDataSet().hashCode(), this.userString(o.getUser()), o.getChangesetId(), DateUtils.fromDate(o.getTimestamp()), o.getVersion()));
        if (o.isDeleted()) {
            s.append("; deleted");
        }
        if (!o.isVisible()) {
            s.append("; deleted-on-server");
        }
        if (o.isModified()) {
            s.append("; modified");
        }
        if (o.isDisabledAndHidden()) {
            s.append("; filtered/hidden");
        }
        if (o.isDisabled()) {
            s.append("; filtered/disabled");
        }
        if (o.hasDirectionKeys()) {
            s.append("; has direction keys");
            if (o.reversedDirection()) {
                s.append(" (reversed)");
            }
        }
        s.append("\n");
    }

    protected void addAttributes(StringBuffer s, OsmPrimitive o) {
        if (o.hasKeys()) {
            s.append("  tags:\n");
            for (String key : o.keySet()) {
                s.append(String.format("    \"%s\"=\"%s\"\n", key, o.get(key)));
            }
        }
    }

    protected void addWayReferrer(StringBuffer s, Node n) {
        List<OsmPrimitive> refs = n.getReferrers();
        DatasetCollection wayRefs = new DatasetCollection(refs, OsmPrimitive.wayPredicate);
        if (wayRefs.size() > 0) {
            s.append("  way referrer:\n");
            for (Way w : wayRefs) {
                s.append("    " + w.getUniqueId() + "\n");
            }
        }
    }

    protected void addRelationReferrer(StringBuffer s, OsmPrimitive o) {
        List<OsmPrimitive> refs = o.getReferrers();
        DatasetCollection relRefs = new DatasetCollection(refs, OsmPrimitive.relationPredicate);
        if (relRefs.size() > 0) {
            s.append("  relation referrer:\n");
            for (Relation r : relRefs) {
                s.append("    " + r.getUniqueId() + "\n");
            }
        }
    }

    protected boolean checkDataSet(OsmPrimitive o) {
        DataSet ds = o.getDataSet();
        if (ds == null) {
            return false;
        }
        return ds.getPrimitiveById(o) != null;
    }

    protected String userString(User user) {
        if (user == null) {
            return "<null>";
        }
        ArrayList<String> names = user.getNames();
        StringBuffer us = new StringBuffer();
        us.append("id:" + user.getId());
        if (names.size() == 1) {
            us.append(" name:" + user.getName());
        } else if (names.size() > 1) {
            us.append(String.format(" %d names:%s", names.size(), user.getName()));
        }
        return us.toString();
    }
}

