/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TagMergeItem {
    private String key = null;
    private String myTagValue = null;
    private String theirTagValue = null;
    private MergeDecisionType mergeDecision = MergeDecisionType.UNDECIDED;

    public TagMergeItem(String key, String myTagValue, String theirTagValue) {
        CheckParameterUtil.ensureParameterNotNull(key, "key");
        this.key = key;
        this.myTagValue = myTagValue;
        this.theirTagValue = theirTagValue;
        this.mergeDecision = MergeDecisionType.UNDECIDED;
    }

    public TagMergeItem(String key, OsmPrimitive my, OsmPrimitive their) {
        CheckParameterUtil.ensureParameterNotNull(key, "key");
        CheckParameterUtil.ensureParameterNotNull(my, "my");
        CheckParameterUtil.ensureParameterNotNull(their, "their");
        this.key = key;
        this.myTagValue = my.get(key);
        this.theirTagValue = their.get(key);
    }

    public void decide(MergeDecisionType decision) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)decision, "decision");
        this.mergeDecision = decision;
    }

    public String getKey() {
        return this.key;
    }

    public String getMyTagValue() {
        return this.myTagValue;
    }

    public String getTheirTagValue() {
        return this.theirTagValue;
    }

    public MergeDecisionType getMergeDecision() {
        return this.mergeDecision;
    }

    public void applyToMyPrimitive(OsmPrimitive primitive) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(primitive, "primitive");
        if (this.mergeDecision == MergeDecisionType.UNDECIDED) {
            throw new IllegalStateException(I18n.tr("Cannot apply undecided tag merge item."));
        }
        if (this.mergeDecision == MergeDecisionType.KEEP_THEIR) {
            if (this.theirTagValue == null) {
                primitive.remove(this.key);
            } else if (this.theirTagValue != null) {
                primitive.put(this.key, this.theirTagValue);
            }
        } else if (this.mergeDecision == MergeDecisionType.KEEP_MINE) {
            if (this.myTagValue == null) {
                primitive.remove(this.key);
            } else if (this.myTagValue != null) {
                primitive.put(this.key, this.myTagValue);
            }
        }
    }
}

