/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class HistoryDataSet
implements MapView.LayerChangeListener {
    private static HistoryDataSet historyDataSet;
    private HashMap<PrimitiveId, ArrayList<HistoryOsmPrimitive>> data = new HashMap();
    private CopyOnWriteArrayList<HistoryDataSetListener> listeners = new CopyOnWriteArrayList();

    public static HistoryDataSet getInstance() {
        if (historyDataSet == null) {
            historyDataSet = new HistoryDataSet();
            MapView.addLayerChangeListener(historyDataSet);
        }
        return historyDataSet;
    }

    public void addHistoryDataSetListener(HistoryDataSetListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeHistoryDataSetListener(HistoryDataSetListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireHistoryUpdated(PrimitiveId id) {
        for (HistoryDataSetListener l : this.listeners) {
            l.historyUpdated(this, id);
        }
    }

    protected void fireCacheCleared() {
        for (HistoryDataSetListener l : this.listeners) {
            l.historyDataSetCleared(this);
        }
    }

    public HistoryOsmPrimitive get(long id, OsmPrimitiveType type, long version) {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        if (version <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "version", version));
        }
        SimplePrimitiveId pid = new SimplePrimitiveId(id, type);
        ArrayList<HistoryOsmPrimitive> versions = this.data.get(pid);
        if (versions == null) {
            return null;
        }
        for (HistoryOsmPrimitive primitive : versions) {
            if (!primitive.matches(id, version)) continue;
            return primitive;
        }
        return null;
    }

    public void put(HistoryOsmPrimitive primitive) {
        SimplePrimitiveId id = new SimplePrimitiveId(primitive.getId(), primitive.getType());
        if (this.data.get(id) == null) {
            this.data.put(id, new ArrayList());
        }
        this.data.get(id).add(primitive);
        this.fireHistoryUpdated(id);
    }

    public History getHistory(long id, OsmPrimitiveType type) throws IllegalArgumentException {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        SimplePrimitiveId pid = new SimplePrimitiveId(id, type);
        return this.getHistory(pid);
    }

    public History getHistory(PrimitiveId pid) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(pid, "pid");
        ArrayList<HistoryOsmPrimitive> versions = this.data.get(pid);
        if (versions == null) {
            return null;
        }
        return new History(pid.getUniqueId(), pid.getType(), versions);
    }

    public void mergeInto(HistoryDataSet other) {
        if (other == null) {
            return;
        }
        for (PrimitiveId id : other.data.keySet()) {
            this.data.put(id, other.data.get(id));
        }
        this.fireHistoryUpdated(null);
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        if (Main.map.mapView.getNumLayers() == 0) {
            this.data.clear();
            this.fireCacheCleared();
        }
    }
}

