/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class DataSetMerger {
    private final ConflictCollection conflicts;
    private final DataSet targetDataSet;
    private final DataSet sourceDataSet;
    private final Map<PrimitiveId, PrimitiveId> mergedMap;
    private final Set<PrimitiveId> objectsWithChildrenToMerge;
    private final Set<OsmPrimitive> objectsToDelete;

    public DataSetMerger(DataSet targetDataSet, DataSet sourceDataSet) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(targetDataSet, "targetDataSet");
        this.targetDataSet = targetDataSet;
        this.sourceDataSet = sourceDataSet;
        this.conflicts = new ConflictCollection();
        this.mergedMap = new HashMap<PrimitiveId, PrimitiveId>();
        this.objectsWithChildrenToMerge = new HashSet<PrimitiveId>();
        this.objectsToDelete = new HashSet<OsmPrimitive>();
    }

    protected void mergePrimitive(OsmPrimitive source) {
        if (!source.isNew()) {
            if (this.mergeById(source)) {
                return;
            }
        } else {
            if (source.isDeleted()) {
                return;
            }
            Collection<OsmPrimitive> candidates = null;
            switch (source.getType()) {
                case NODE: {
                    candidates = this.targetDataSet.getNodes();
                    break;
                }
                case WAY: {
                    candidates = this.targetDataSet.getWays();
                    break;
                }
                case RELATION: {
                    candidates = this.targetDataSet.getRelations();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            for (OsmPrimitive target : candidates) {
                if (!target.isNew() || target.isDeleted() || !target.hasEqualSemanticAttributes(source)) continue;
                this.mergedMap.put(source.getPrimitiveId(), target.getPrimitiveId());
                target.setVisible(source.isVisible());
                target.setUser(source.getUser());
                target.setTimestamp(source.getTimestamp());
                target.setModified(source.isModified());
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
                return;
            }
        }
        OsmPrimitive target = null;
        switch (source.getType()) {
            case NODE: {
                target = source.isNew() ? new Node() : new Node(source.getId());
                break;
            }
            case WAY: {
                target = source.isNew() ? new Way() : new Way(source.getId());
                break;
            }
            case RELATION: {
                target = source.isNew() ? new Relation() : new Relation(source.getId());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        target.mergeFrom(source);
        this.targetDataSet.addPrimitive(target);
        this.mergedMap.put(source.getPrimitiveId(), target.getPrimitiveId());
        this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
    }

    protected OsmPrimitive getMergeTarget(OsmPrimitive mergeSource) throws IllegalStateException {
        PrimitiveId targetId = this.mergedMap.get(mergeSource.getPrimitiveId());
        if (targetId == null) {
            return null;
        }
        return this.targetDataSet.getPrimitiveById(targetId);
    }

    protected void fixIncomplete(Way other) {
        Way myWay = (Way)this.getMergeTarget(other);
        if (myWay == null) {
            throw new RuntimeException(I18n.tr("Missing merge target for way with id {0}", other.getUniqueId()));
        }
    }

    public void fixReferences() {
        for (Way w : this.sourceDataSet.getWays()) {
            if (this.conflicts.hasConflictForTheir(w) || !this.objectsWithChildrenToMerge.contains(w.getPrimitiveId())) continue;
            this.mergeNodeList(w);
            this.fixIncomplete(w);
        }
        for (Relation r : this.sourceDataSet.getRelations()) {
            if (this.conflicts.hasConflictForTheir(r) || !this.objectsWithChildrenToMerge.contains(r.getPrimitiveId())) continue;
            this.mergeRelationMembers(r);
        }
        this.deleteMarkedObjects();
    }

    protected void deleteMarkedObjects() {
        boolean flag;
        do {
            flag = false;
            Iterator<OsmPrimitive> it = this.objectsToDelete.iterator();
            block1: while (it.hasNext()) {
                OsmPrimitive target = it.next();
                OsmPrimitive source = this.sourceDataSet.getPrimitiveById(target.getPrimitiveId());
                if (source == null) {
                    throw new RuntimeException(I18n.tr("Object of type {0} with id {1} was marked to be deleted, but it's missing in the source dataset", new Object[]{target.getType(), target.getUniqueId()}));
                }
                List<OsmPrimitive> referrers = target.getReferrers();
                if (referrers.isEmpty()) {
                    target.setDeleted(true);
                    target.mergeFrom(source);
                    it.remove();
                    flag = true;
                    continue;
                }
                for (OsmPrimitive referrer : referrers) {
                    if (this.objectsToDelete.contains(referrer)) continue;
                    this.conflicts.add(target, source);
                    it.remove();
                    flag = true;
                    continue block1;
                }
            }
        } while (flag);
        if (!this.objectsToDelete.isEmpty()) {
            for (OsmPrimitive osm : this.objectsToDelete) {
                if (osm instanceof Way) {
                    ((Way)osm).setNodes(null);
                    continue;
                }
                if (!(osm instanceof Relation)) continue;
                ((Relation)osm).setMembers(null);
            }
            for (OsmPrimitive osm : this.objectsToDelete) {
                osm.setDeleted(true);
                osm.mergeFrom(this.sourceDataSet.getPrimitiveById(osm.getPrimitiveId()));
            }
        }
    }

    private void mergeNodeList(Way source) throws IllegalStateException {
        Way target = (Way)this.getMergeTarget(source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr("Missing merge target for way with id {0}", source.getUniqueId()));
        }
        ArrayList<Node> newNodes = new ArrayList<Node>(source.getNodesCount());
        for (Node sourceNode : source.getNodes()) {
            Node targetNode = (Node)this.getMergeTarget(sourceNode);
            if (targetNode != null) {
                newNodes.add(targetNode);
                if (!targetNode.isDeleted() || this.conflicts.hasConflictForMy(targetNode)) continue;
                this.conflicts.add(new Conflict<Node>(targetNode, sourceNode, true));
                targetNode.setDeleted(false);
                continue;
            }
            throw new IllegalStateException(I18n.tr("Missing merge target for node with id {0}", sourceNode.getUniqueId()));
        }
        target.setNodes(newNodes);
    }

    private void mergeRelationMembers(Relation source) throws IllegalStateException {
        Relation target = (Relation)this.getMergeTarget(source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr("Missing merge target for relation with id {0}", source.getUniqueId()));
        }
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember sourceMember : source.getMembers()) {
            OsmPrimitive targetMember = this.getMergeTarget(sourceMember.getMember());
            if (targetMember == null) {
                throw new IllegalStateException(I18n.tr("Missing merge target of type {0} with id {1}", new Object[]{sourceMember.getType(), sourceMember.getUniqueId()}));
            }
            RelationMember newMember = new RelationMember(sourceMember.getRole(), targetMember);
            newMembers.add(newMember);
            if (!targetMember.isDeleted() || this.conflicts.hasConflictForMy(targetMember)) continue;
            this.conflicts.add(new Conflict<OsmPrimitive>(targetMember, sourceMember.getMember(), true));
            targetMember.setDeleted(false);
        }
        target.setMembers(newMembers);
    }

    private boolean mergeById(OsmPrimitive source) {
        OsmPrimitive target = this.targetDataSet.getPrimitiveById(source.getId(), source.getType());
        if (target == null) {
            return false;
        }
        this.mergedMap.put(source.getPrimitiveId(), target.getPrimitiveId());
        if (target.getVersion() > source.getVersion()) {
            return true;
        }
        if (target.isIncomplete() && !source.isIncomplete()) {
            target.mergeFrom(source);
            this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
        } else if (!(!target.isIncomplete() && source.isIncomplete() || target.isIncomplete() && source.isIncomplete())) {
            if (target.isVisible() != source.isVisible() && target.getVersion() == source.getVersion()) {
                throw new DataIntegrityProblemException(I18n.tr("Conflict in 'visible' attribute for object of type {0} with id {1}", new Object[]{target.getType(), target.getId()}));
            }
            if (target.isDeleted() && !source.isDeleted() && target.getVersion() == source.getVersion()) {
                for (OsmPrimitive referrer : source.getReferrers()) {
                    if (this.targetDataSet.getPrimitiveById(referrer.getPrimitiveId()) != null) continue;
                    this.conflicts.add(new Conflict<OsmPrimitive>(target, source, true));
                    target.setDeleted(false);
                    break;
                }
            } else if (!target.isModified() && source.isDeleted()) {
                this.objectsToDelete.add(target);
            } else if (!target.isModified() && source.isModified()) {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            } else if (!target.isModified() && !source.isModified() && target.getVersion() == source.getVersion()) {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            } else if (!target.isModified() && !source.isModified() && target.getVersion() < source.getVersion()) {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            } else if (target.isModified() && !source.isModified() && target.getVersion() == source.getVersion()) {
                if (target.hasEqualSemanticAttributes(source)) {
                    target.setModified(false);
                }
            } else if (source.isDeleted() != target.isDeleted()) {
                this.conflicts.add(target, source);
            } else if (!target.hasEqualSemanticAttributes(source)) {
                this.conflicts.add(target, source);
            } else {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() {
        if (this.sourceDataSet == null) {
            return;
        }
        this.targetDataSet.beginUpdate();
        try {
            for (Node node : this.sourceDataSet.getNodes()) {
                this.mergePrimitive(node);
            }
            for (Way way : this.sourceDataSet.getWays()) {
                this.mergePrimitive(way);
            }
            for (Relation relation : this.sourceDataSet.getRelations()) {
                this.mergePrimitive(relation);
            }
            this.fixReferences();
        }
        finally {
            this.targetDataSet.endUpdate();
        }
    }

    public DataSet getTargetDataSet() {
        return this.targetDataSet;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

