/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBox {
    private double xmin = Double.POSITIVE_INFINITY;
    private double xmax = Double.NEGATIVE_INFINITY;
    private double ymin = Double.POSITIVE_INFINITY;
    private double ymax = Double.NEGATIVE_INFINITY;

    public BBox(Bounds bounds) {
        this.add(bounds.getMin());
        this.add(bounds.getMax());
    }

    public BBox(LatLon a, LatLon b) {
        this.add(a);
        this.add(b);
    }

    public BBox(BBox copy) {
        this.xmin = copy.xmin;
        this.xmax = copy.xmax;
        this.ymin = copy.ymin;
        this.ymax = copy.ymax;
    }

    public BBox(double a_x, double a_y, double b_x, double b_y) {
        this.xmin = Math.min(a_x, b_x);
        this.xmax = Math.max(a_x, b_x);
        this.ymin = Math.min(a_y, b_y);
        this.ymax = Math.max(a_y, b_y);
        this.sanity();
    }

    public BBox(Way w) {
        for (Node n : w.getNodes()) {
            LatLon coor = n.getCoor();
            if (coor == null) continue;
            this.add(coor);
        }
    }

    public BBox(Node n) {
        LatLon coor = n.getCoor();
        if (coor == null) {
            this.ymax = 0.0;
            this.ymin = 0.0;
            this.xmax = 0.0;
            this.xmin = 0.0;
        } else {
            this.xmin = this.xmax = coor.lon();
            this.ymin = this.ymax = coor.lat();
        }
    }

    private void sanity() {
        if (this.xmin < -180.0) {
            this.xmin = -180.0;
        }
        if (this.xmax > 180.0) {
            this.xmax = 180.0;
        }
        if (this.ymin < -90.0) {
            this.ymin = -90.0;
        }
        if (this.ymax > 90.0) {
            this.ymax = 90.0;
        }
    }

    public void add(LatLon c) {
        this.add(c.lon(), c.lat());
    }

    public void add(double x, double y) {
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        this.sanity();
    }

    public void add(BBox box) {
        this.add(box.getTopLeft());
        this.add(box.getBottomRight());
    }

    public void addPrimitive(OsmPrimitive primitive, double extraSpace) {
        BBox primBbox = primitive.getBBox();
        this.add(primBbox.xmin - extraSpace, primBbox.ymin - extraSpace);
        this.add(primBbox.xmax + extraSpace, primBbox.ymax + extraSpace);
    }

    public double height() {
        return this.ymax - this.ymin;
    }

    public double width() {
        return this.xmax - this.xmin;
    }

    public boolean bounds(BBox b) {
        return this.xmin <= b.xmin && this.xmax >= b.xmax && this.ymin <= b.ymin && this.ymax >= b.ymax;
    }

    public boolean bounds(LatLon c) {
        return this.xmin <= c.lon() && this.xmax >= c.lon() && this.ymin <= c.lat() && this.ymax >= c.lat();
    }

    public boolean intersects(BBox b) {
        if (this.xmin > b.xmax) {
            return false;
        }
        if (this.xmax < b.xmin) {
            return false;
        }
        if (this.ymin > b.ymax) {
            return false;
        }
        return !(this.ymax < b.ymin);
    }

    public List<LatLon> points() {
        LatLon p1 = new LatLon(this.ymin, this.xmin);
        LatLon p2 = new LatLon(this.ymin, this.xmax);
        LatLon p3 = new LatLon(this.ymax, this.xmin);
        LatLon p4 = new LatLon(this.ymax, this.xmax);
        ArrayList<LatLon> ret = new ArrayList<LatLon>(4);
        ret.add(p1);
        ret.add(p2);
        ret.add(p3);
        ret.add(p4);
        return ret;
    }

    public LatLon getTopLeft() {
        return new LatLon(this.ymax, this.xmin);
    }

    public LatLon getBottomRight() {
        return new LatLon(this.ymin, this.xmax);
    }

    public int hashCode() {
        return (int)(this.ymin * this.xmin);
    }

    public boolean equals(Object o) {
        if (o instanceof BBox) {
            BBox b = (BBox)o;
            return b.xmax == this.xmax && b.ymax == this.ymax && b.xmin == this.xmin && b.ymin == this.ymin;
        }
        return false;
    }

    public String toString() {
        return "[ x: " + this.xmin + " -> " + this.xmax + ", y: " + this.ymin + " -> " + this.ymax + " ]";
    }
}

