/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private File preferencesDirFile = null;
    private final CopyOnWriteArrayList<PreferenceChangedListener> listeners = new CopyOnWriteArrayList();
    protected final SortedMap<String, String> properties = new TreeMap<String, String>();
    protected final SortedMap<String, String> defaults = new TreeMap<String, String>();
    private static final String[] DEFAULT_PLUGIN_SITE = new String[]{"http://josm.openstreetmap.de/plugin%<?plugins=>"};

    public void addPreferenceChangeListener(PreferenceChangedListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removePreferenceChangeListener(PreferenceChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePreferenceChanged(String key, String oldValue, String newValue) {
        DefaultPreferenceChangeEvent evt = new DefaultPreferenceChangeEvent(key, oldValue, newValue);
        for (PreferenceChangedListener l : this.listeners) {
            l.preferenceChanged(evt);
        }
    }

    public String getPreferencesDir() {
        String path = this.getPreferencesDirFile().getPath();
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public File getPreferencesDirFile() {
        if (this.preferencesDirFile != null) {
            return this.preferencesDirFile;
        }
        String path = System.getProperty("josm.home");
        this.preferencesDirFile = path != null ? new File(path) : ((path = System.getenv("APPDATA")) != null ? new File(path, "JOSM") : new File(System.getProperty("user.home"), ".josm"));
        return this.preferencesDirFile;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirFile(), "preferences");
    }

    public File getPluginsDirectory() {
        return new File(this.getPreferencesDirFile(), "plugins");
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        LinkedList<String> locations = new LinkedList<String>();
        locations.add(Main.pref.getPreferencesDir());
        String s = System.getenv("JOSM_RESOURCES");
        if (s != null) {
            if (!s.endsWith(File.separator)) {
                s = s + File.separator;
            }
            locations.add(s);
        }
        if ((s = System.getProperty("josm.resources")) != null) {
            if (!s.endsWith(File.separator)) {
                s = s + File.separator;
            }
            locations.add(s);
        }
        String appdata = System.getenv("APPDATA");
        if (System.getenv("ALLUSERSPROFILE") != null && appdata != null && appdata.lastIndexOf(File.separator) != -1) {
            appdata = appdata.substring(appdata.lastIndexOf(File.separator));
            locations.add(new File(new File(System.getenv("ALLUSERSPROFILE"), appdata), "JOSM").getPath());
        }
        locations.add("/usr/local/share/josm/");
        locations.add("/usr/local/lib/josm/");
        locations.add("/usr/share/josm/");
        locations.add("/usr/lib/josm/");
        return locations;
    }

    public synchronized boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public synchronized String get(String key) {
        this.putDefault(key, null);
        if (!this.properties.containsKey(key)) {
            return "";
        }
        return (String)this.properties.get(key);
    }

    public synchronized String get(String key, String def) {
        this.putDefault(key, def);
        String prop = (String)this.properties.get(key);
        if (prop == null || prop.equals("")) {
            return def;
        }
        return prop;
    }

    public synchronized Map<String, String> getAllPrefix(String prefix) {
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            if (!e.getKey().startsWith(prefix)) continue;
            all.put(e.getKey(), e.getValue());
        }
        return all;
    }

    private synchronized Map<String, String> getAllPrefixDefault(String prefix) {
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, String> e : this.defaults.entrySet()) {
            if (!e.getKey().startsWith(prefix)) continue;
            all.put(e.getKey(), e.getValue());
        }
        return all;
    }

    public synchronized TreeMap<String, String> getAllColors() {
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, String> e : this.defaults.entrySet()) {
            if (!e.getKey().startsWith("color.") || e.getValue() == null) continue;
            all.put(e.getKey().substring(6), e.getValue());
        }
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            if (!e.getKey().startsWith("color.")) continue;
            all.put(e.getKey().substring(6), e.getValue());
        }
        return all;
    }

    public synchronized Map<String, String> getDefaults() {
        return this.defaults;
    }

    public synchronized void putDefault(String key, String def) {
        if (!this.defaults.containsKey(key) || this.defaults.get(key) == null) {
            this.defaults.put(key, def);
        } else if (def != null && !((String)this.defaults.get(key)).equals(def)) {
            System.out.println("Defaults for " + key + " differ: " + def + " != " + (String)this.defaults.get(key));
        }
    }

    public synchronized boolean getBoolean(String key) {
        this.putDefault(key, null);
        return this.properties.containsKey(key) ? Boolean.parseBoolean((String)this.properties.get(key)) : false;
    }

    public synchronized boolean getBoolean(String key, boolean def) {
        this.putDefault(key, Boolean.toString(def));
        return this.properties.containsKey(key) ? Boolean.parseBoolean((String)this.properties.get(key)) : def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String key, String value) {
        boolean changed = false;
        String oldValue = null;
        Preferences preferences = this;
        synchronized (preferences) {
            oldValue = (String)this.properties.get(key);
            if (value != null && value.length() == 0) {
                value = null;
            }
            if (!(oldValue == null && (value == null || value.equals(this.defaults.get(key))) || value != null && oldValue != null && oldValue.equals(value))) {
                if (value == null) {
                    this.properties.remove(key);
                } else {
                    this.properties.put(key, value);
                }
                try {
                    this.save();
                }
                catch (IOException e) {
                    System.out.println(I18n.tr("Warning: failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
                }
                changed = true;
            }
        }
        if (changed) {
            this.firePreferenceChanged(key, oldValue, value);
        }
        return changed;
    }

    public synchronized boolean put(String key, boolean value) {
        return this.put(key, Boolean.toString(value));
    }

    public synchronized boolean putInteger(String key, Integer value) {
        return this.put(key, Integer.toString(value));
    }

    public synchronized boolean putDouble(String key, Double value) {
        return this.put(key, Double.toString(value));
    }

    public synchronized boolean putLong(String key, Long value) {
        return this.put(key, Long.toString(value));
    }

    public void save() throws IOException {
        this.putInteger("josm.version", Version.getInstance().getVersion());
        this.updateSystemProperties();
        if (Main.applet) {
            return;
        }
        File prefFile = new File(this.getPreferencesDirFile(), "preferences");
        if (prefFile.exists()) {
            Preferences.copyFile(prefFile, new File(prefFile + "_backup"));
        }
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(prefFile + "_tmp"), "utf-8"), false);
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            String s = (String)this.defaults.get(e.getKey());
            if (s != null && s.equals(e.getValue())) continue;
            out.println(e.getKey() + "=" + e.getValue());
        }
        out.close();
        File tmpFile = new File(prefFile + "_tmp");
        Preferences.copyFile(tmpFile, prefFile);
        tmpFile.delete();
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public void load() throws IOException {
        this.properties.clear();
        if (!Main.applet) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getPreferencesDir() + "preferences"), "utf-8"));
            int lineNumber = 0;
            ArrayList<Integer> errLines = new ArrayList<Integer>();
            String line = in.readLine();
            while (line != null) {
                int i = line.indexOf(61);
                if (i == -1 || i == 0) {
                    errLines.add(lineNumber);
                } else {
                    this.properties.put(line.substring(0, i), line.substring(i + 1));
                }
                line = in.readLine();
                ++lineNumber;
            }
            if (!errLines.isEmpty()) {
                throw new IOException(I18n.tr("Malformed config file at lines {0}", errLines));
            }
        }
        this.updateSystemProperties();
    }

    public void init(boolean reset) {
        if (Main.applet) {
            return;
        }
        File prefDir = this.getPreferencesDirFile();
        if (prefDir.exists()) {
            if (!prefDir.isDirectory()) {
                System.err.println(I18n.tr("Warning: Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", prefDir.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", prefDir.getAbsoluteFile()), I18n.tr("Error"), 0);
                return;
            }
        } else if (!prefDir.mkdirs()) {
            System.err.println(I18n.tr("Warning: Failed to initialize preferences. Failed to create missing preference directory: {0}", prefDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", prefDir.getAbsoluteFile()), I18n.tr("Error"), 0);
            return;
        }
        File preferenceFile = this.getPreferenceFile();
        try {
            if (!preferenceFile.exists()) {
                System.out.println(I18n.tr("Warning: Missing preference file ''{0}''. Creating a default preference file.", preferenceFile.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            } else if (reset) {
                System.out.println(I18n.tr("Warning: Replacing existing preference file ''{0}'' with default preference file.", preferenceFile.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error"), 0);
            return;
        }
        try {
            this.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            File backupFile = new File(prefDir, "preferences.bak");
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", backupFile.getAbsoluteFile()), I18n.tr("Error"), 0);
            preferenceFile.renameTo(backupFile);
            try {
                this.resetToDefault();
                this.save();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                System.err.println(I18n.tr("Warning: Failed to initialize preferences.Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
    }

    public final void resetToDefault() {
        this.properties.clear();
    }

    public synchronized Color getColor(String colName, Color def) {
        return this.getColor(colName, null, def);
    }

    public Color getColor(ColorKey key) {
        return this.getColor(key.getColorName(), key.getSpecialName(), key.getDefault());
    }

    public synchronized Color getColor(String colName, String specName, Color def) {
        String colStr;
        this.putDefault("color." + colName, ColorHelper.color2html(def));
        String string = colStr = specName != null ? this.get("color." + specName) : "";
        if (colStr.equals("")) {
            colStr = this.get("color." + colName);
        }
        return colStr.equals("") ? def : ColorHelper.html2color(colStr);
    }

    public synchronized Color getDefaultColor(String colName) {
        String colStr = (String)this.defaults.get("color." + colName);
        return colStr == null || "".equals(colStr) ? null : ColorHelper.html2color(colStr);
    }

    public synchronized boolean putColor(String colName, Color val) {
        return this.put("color." + colName, val != null ? ColorHelper.color2html(val) : null);
    }

    public synchronized int getInteger(String key, int def) {
        this.putDefault(key, Integer.toString(def));
        String v = this.get(key);
        if (null == v) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public synchronized long getLong(String key, long def) {
        this.putDefault(key, Long.toString(def));
        String v = this.get(key);
        if (null == v) {
            return def;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public synchronized double getDouble(String key, double def) {
        this.putDefault(key, Double.toString(def));
        String v = this.get(key);
        if (null == v) {
            return def;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public synchronized double getDouble(String key, String def) {
        this.putDefault(key, def);
        String v = this.get(key);
        if (v != null && v.length() != 0) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            return Double.parseDouble(def);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public synchronized String getCollectionAsString(String key) {
        String s = this.get(key);
        if (s != null && s.length() != 0) {
            s = s.replaceAll("\u001e", ",");
        }
        return s;
    }

    public boolean isCollection(String key, boolean def) {
        String s = this.get(key);
        if (s != null && s.length() != 0) {
            return s.indexOf("\u001e") >= 0;
        }
        return def;
    }

    public synchronized Collection<String> getCollection(String key, Collection<String> def) {
        String s = this.get(key);
        if (def != null) {
            this.putCollectionDefault(key, def);
        }
        if (s != null && s.length() != 0) {
            return Arrays.asList(s.split("\u001e"));
        }
        return def;
    }

    public synchronized void removeFromCollection(String key, String value) {
        ArrayList<String> a = new ArrayList<String>(this.getCollection(key, Collections.<String>emptyList()));
        a.remove(value);
        this.putCollection(key, a);
    }

    public synchronized boolean putCollection(String key, Collection<String> val) {
        String s = null;
        if (val != null) {
            for (String a : val) {
                if (a == null) {
                    a = "";
                }
                if (s != null) {
                    s = s + "\u001e" + a;
                    continue;
                }
                s = a;
            }
        }
        return this.put(key, s);
    }

    private synchronized void putCollectionDefault(String key, Collection<String> val) {
        String s = null;
        for (String a : val) {
            if (s != null) {
                s = s + "\u001e" + a;
                continue;
            }
            s = a;
        }
        this.putDefault(key, s);
    }

    public synchronized Collection<Collection<String>> getArray(String key, Collection<Collection<String>> def) {
        if (def != null) {
            this.putArrayDefault(key, def);
        }
        key = key + ".";
        int num = 0;
        LinkedList<Collection<String>> col = new LinkedList<Collection<String>>();
        while (this.properties.containsKey(key + num)) {
            col.add(this.getCollection(key + num++, null));
        }
        return num == 0 && def != null ? def : col;
    }

    public synchronized boolean putArray(String key, Collection<Collection<String>> val) {
        boolean changed = false;
        key = key + ".";
        Set<String> keys = this.getAllPrefix(key).keySet();
        if (val != null) {
            int num = 0;
            for (Collection<String> c : val) {
                keys.remove(key + num);
                changed |= this.putCollection(key + num++, c);
            }
        }
        int l = key.length();
        for (String k : keys) {
            try {
                Integer.valueOf(k.substring(l));
                changed |= this.put(k, null);
            }
            catch (NumberFormatException e) {}
        }
        return changed;
    }

    private synchronized void putArrayDefault(String key, Collection<Collection<String>> val) {
        key = key + ".";
        Set<String> keys = this.getAllPrefixDefault(key).keySet();
        int num = 0;
        for (Collection<String> c : val) {
            keys.remove(key + num);
            this.putCollectionDefault(key + num++, c);
        }
        int l = key.length();
        for (String k : keys) {
            try {
                Integer.valueOf(k.substring(l));
                this.defaults.remove(k);
            }
            catch (Exception e) {}
        }
    }

    public void updateSystemProperties() {
        Properties sysProp = System.getProperties();
        sysProp.put("http.agent", Version.getInstance().getAgentString());
        System.setProperties(sysProp);
    }

    public Collection<String> getPluginSites() {
        return this.getCollection("pluginmanager.sites", Arrays.asList(DEFAULT_PLUGIN_SITE));
    }

    public void setPluginSites(Collection<String> sites) {
        this.putCollection("pluginmanager.sites", sites);
    }

    public static interface ColorKey {
        public String getColorName();

        public String getSpecialName();

        public Color getDefault();
    }

    private static class DefaultPreferenceChangeEvent
    implements PreferenceChangeEvent {
        private final String key;
        private final String oldValue;
        private final String newValue;

        public DefaultPreferenceChangeEvent(String key, String oldValue, String newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String getNewValue() {
            return this.newValue;
        }
    }

    public static interface PreferenceChangedListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    public static interface PreferenceChangeEvent {
        public String getKey();

        public String getOldValue();

        public String getNewValue();
    }
}

