/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.PushbackReader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class SearchCompiler {
    private boolean caseSensitive = false;
    private boolean regexSearch = false;
    private static String rxErrorMsg = I18n.marktr("The regex \"{0}\" had a parse error at offset {1}, full error:\n\n{2}");
    private static String rxErrorMsgNoPos = I18n.marktr("The regex \"{0}\" had a parse error, full error:\n\n{1}");
    private PushbackTokenizer tokenizer;

    public SearchCompiler(boolean caseSensitive, boolean regexSearch, PushbackTokenizer tokenizer) {
        this.caseSensitive = caseSensitive;
        this.regexSearch = regexSearch;
        this.tokenizer = tokenizer;
    }

    public static Match compile(String searchStr, boolean caseSensitive, boolean regexSearch) throws ParseError {
        return new SearchCompiler(caseSensitive, regexSearch, new PushbackTokenizer(new PushbackReader(new StringReader(searchStr)))).parse();
    }

    public Match parse() throws ParseError {
        Match m = this.parseExpression();
        if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.EOF)) {
            throw new ParseError(I18n.tr("Unexpected token: {0}", new Object[]{this.tokenizer.nextToken()}));
        }
        if (m == null) {
            return new Always();
        }
        return m;
    }

    private Match parseExpression() throws ParseError {
        Match factor = this.parseFactor();
        if (factor == null) {
            return null;
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.OR)) {
            return new Or(factor, this.parseExpression(I18n.tr("Missing parameter for OR")));
        }
        Match expression = this.parseExpression();
        if (expression == null) {
            return factor;
        }
        return new And(factor, expression);
    }

    private Match parseExpression(String errorMessage) throws ParseError {
        Match expression = this.parseExpression();
        if (expression == null) {
            throw new ParseError(errorMessage);
        }
        return expression;
    }

    private Match parseFactor() throws ParseError {
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.LEFT_PARENT)) {
            Match expression = this.parseExpression();
            if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.RIGHT_PARENT)) {
                throw new ParseError(PushbackTokenizer.Token.RIGHT_PARENT, this.tokenizer.nextToken());
            }
            return expression;
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.NOT)) {
            return new Not(this.parseFactor(I18n.tr("Missing operator for NOT")));
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.KEY)) {
            String key = this.tokenizer.getText();
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.EQUALS)) {
                return new ExactKeyValue(this.regexSearch, key, this.tokenizer.readTextOrNumber());
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.COLON)) {
                if ("id".equals(key)) {
                    return new Id(this.tokenizer.readNumber(I18n.tr("Primitive id expected")));
                }
                if ("tags".equals(key)) {
                    PushbackTokenizer.Range range = this.tokenizer.readRange(I18n.tr("Range of numbers expected"));
                    return new TagCountRange((int)range.getStart(), (int)range.getEnd());
                }
                if ("nodes".equals(key)) {
                    PushbackTokenizer.Range range = this.tokenizer.readRange(I18n.tr("Range of numbers expected"));
                    return new NodeCountRange((int)range.getStart(), (int)range.getEnd());
                }
                if ("changeset".equals(key)) {
                    return new ChangesetId(this.tokenizer.readNumber(I18n.tr("Changeset id expected")));
                }
                if ("version".equals(key)) {
                    return new Version(this.tokenizer.readNumber(I18n.tr("Version expected")));
                }
                return this.parseKV(key, this.tokenizer.readTextOrNumber());
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.QUESTION_MARK)) {
                return new BooleanMatch(key, false);
            }
            if ("modified".equals(key)) {
                return new Modified();
            }
            if ("incomplete".equals(key)) {
                return new Incomplete();
            }
            if ("untagged".equals(key)) {
                return new Untagged();
            }
            if ("selected".equals(key)) {
                return new Selected();
            }
            if ("child".equals(key)) {
                return new Child(this.parseFactor());
            }
            if ("parent".equals(key)) {
                return new Parent(this.parseFactor());
            }
            return new Any(key, this.regexSearch, this.caseSensitive);
        }
        return null;
    }

    private Match parseFactor(String errorMessage) throws ParseError {
        Match fact = this.parseFactor();
        if (fact == null) {
            throw new ParseError(errorMessage);
        }
        return fact;
    }

    private Match parseKV(String key, String value) throws ParseError {
        if (value == null) {
            value = "";
        }
        if (key.equals("type")) {
            return new ExactType(value);
        }
        if (key.equals("user")) {
            return new UserMatch(value);
        }
        if (key.equals("role")) {
            return new RoleMatch(value);
        }
        return new KeyValue(key, value, this.regexSearch, this.caseSensitive);
    }

    private static int regexFlags(boolean caseSensitive) {
        int searchFlags = 0;
        searchFlags |= 0x80;
        searchFlags |= 0x20;
        if (!caseSensitive) {
            searchFlags |= 0x42;
        }
        return searchFlags;
    }

    public static class ParseError
    extends Exception {
        public ParseError(String msg) {
            super(msg);
        }

        public ParseError(PushbackTokenizer.Token expected, PushbackTokenizer.Token found) {
            this(I18n.tr("Unexpected token. Expected {0}, found {1}", new Object[]{expected, found}));
        }
    }

    private static class Child
    extends Match {
        private final Match parent;

        public Child(Match m) {
            this.parent = m == null ? new Always() : m;
        }

        public boolean match(OsmPrimitive osm) {
            boolean isChild = false;
            for (OsmPrimitive p : osm.getReferrers()) {
                isChild |= this.parent.match(p);
            }
            return isChild;
        }

        public String toString() {
            return "child(" + this.parent + ")";
        }
    }

    private static class Parent
    extends Match {
        private Match child;

        public Parent(Match m) {
            this.child = m;
        }

        public boolean match(OsmPrimitive osm) {
            boolean isParent;
            block4: {
                block3: {
                    isParent = false;
                    if (this.child == null) {
                        this.child = new Always();
                    }
                    if (!(osm instanceof Way)) break block3;
                    for (Node n : ((Way)osm).getNodes()) {
                        isParent |= this.child.match(n);
                    }
                    break block4;
                }
                if (!(osm instanceof Relation)) break block4;
                for (RelationMember member : ((Relation)osm).getMembers()) {
                    isParent |= this.child.match(member.getMember());
                }
            }
            return isParent;
        }

        public String toString() {
            return "parent(" + this.child + ")";
        }
    }

    private static class Untagged
    extends Match {
        private Untagged() {
        }

        public boolean match(OsmPrimitive osm) {
            return !osm.isTagged() && !osm.isIncomplete();
        }

        public String toString() {
            return "untagged";
        }
    }

    private static class Incomplete
    extends Match {
        private Incomplete() {
        }

        public boolean match(OsmPrimitive osm) {
            return osm.isIncomplete();
        }

        public String toString() {
            return "incomplete";
        }
    }

    private static class Selected
    extends Match {
        private Selected() {
        }

        public boolean match(OsmPrimitive osm) {
            return Main.main.getCurrentDataSet().isSelected(osm);
        }

        public String toString() {
            return "selected";
        }
    }

    private static class Modified
    extends Match {
        private Modified() {
        }

        public boolean match(OsmPrimitive osm) {
            return osm.isModified() || osm.isNewOrUndeleted();
        }

        public String toString() {
            return "modified";
        }
    }

    private static class TagCountRange
    extends Match {
        private int minCount;
        private int maxCount;

        public TagCountRange(int minCount, int maxCount) {
            if (maxCount < minCount) {
                this.minCount = maxCount;
                this.maxCount = minCount;
            } else {
                this.minCount = minCount;
                this.maxCount = maxCount;
            }
        }

        public boolean match(OsmPrimitive osm) {
            int size = osm.getKeys().size();
            return size >= this.minCount && size <= this.maxCount;
        }

        public String toString() {
            return "tags=" + this.minCount + "-" + this.maxCount;
        }
    }

    private static class NodeCountRange
    extends Match {
        private int minCount;
        private int maxCount;

        public NodeCountRange(int minCount, int maxCount) {
            if (maxCount < minCount) {
                this.minCount = maxCount;
                this.maxCount = minCount;
            } else {
                this.minCount = minCount;
                this.maxCount = maxCount;
            }
        }

        public boolean match(OsmPrimitive osm) {
            if (!(osm instanceof Way)) {
                return false;
            }
            int size = ((Way)osm).getNodesCount();
            return size >= this.minCount && size <= this.maxCount;
        }

        public String toString() {
            return "nodes=" + this.minCount + "-" + this.maxCount;
        }
    }

    private static class RoleMatch
    extends Match {
        private String role;

        public RoleMatch(String role) {
            this.role = role == null ? "" : role;
        }

        public boolean match(OsmPrimitive osm) {
            for (OsmPrimitive ref : osm.getReferrers()) {
                if (!(ref instanceof Relation) || ref.isIncomplete() || ref.isDeleted()) continue;
                for (RelationMember m : ((Relation)ref).getMembers()) {
                    String testRole;
                    if (m.getMember() != osm || !this.role.equals((testRole = m.getRole()) == null ? "" : testRole)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "role=" + this.role;
        }
    }

    private static class UserMatch
    extends Match {
        private String user;

        public UserMatch(String user) {
            this.user = user.equals("anonymous") ? null : user;
        }

        public boolean match(OsmPrimitive osm) {
            if (osm.getUser() == null) {
                return this.user == null;
            }
            return osm.getUser().hasName(this.user);
        }

        public String toString() {
            return "user=" + this.user == null ? "" : this.user;
        }
    }

    private static class ExactType
    extends Match {
        private final Class<?> type;

        public ExactType(String type) throws ParseError {
            if ("node".equals(type)) {
                this.type = Node.class;
            } else if ("way".equals(type)) {
                this.type = Way.class;
            } else if ("relation".equals(type)) {
                this.type = Relation.class;
            } else {
                throw new ParseError(I18n.tr("Unknown primitive type: {0}. Allowed values are node, way or relation", type));
            }
        }

        public boolean match(OsmPrimitive osm) {
            return osm.getClass() == this.type;
        }

        public String toString() {
            return "type=" + this.type;
        }
    }

    private static class Any
    extends Match {
        private final String search;
        private final Pattern searchRegex;
        private final boolean caseSensitive;

        public Any(String s, boolean regexSearch, boolean caseSensitive) throws ParseError {
            s = Normalizer.normalize(s, Normalizer.Form.NFC);
            this.caseSensitive = caseSensitive;
            if (regexSearch) {
                try {
                    this.searchRegex = Pattern.compile(s, SearchCompiler.regexFlags(caseSensitive));
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr(rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()));
                }
                catch (Exception e) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, s, e.getMessage()));
                }
                this.search = s;
            } else if (caseSensitive) {
                this.search = s;
                this.searchRegex = null;
            } else {
                this.search = s.toLowerCase();
                this.searchRegex = null;
            }
        }

        public boolean match(OsmPrimitive osm) {
            if (!osm.hasKeys() && osm.getUser() == null) {
                return this.search.equals("");
            }
            for (String key : osm.keySet()) {
                String value = osm.get(key);
                if (this.searchRegex != null) {
                    value = Normalizer.normalize(value, Normalizer.Form.NFC);
                    Matcher keyMatcher = this.searchRegex.matcher(key);
                    Matcher valMatcher = this.searchRegex.matcher(value);
                    boolean keyMatchFound = keyMatcher.find();
                    boolean valMatchFound = valMatcher.find();
                    if (!keyMatchFound && !valMatchFound) continue;
                    return true;
                }
                if (!this.caseSensitive) {
                    key = key.toLowerCase();
                    value = value.toLowerCase();
                }
                value = Normalizer.normalize(value, Normalizer.Form.NFC);
                if (key.indexOf(this.search) == -1 && value.indexOf(this.search) == -1) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.search;
        }
    }

    public static class ExactKeyValue
    extends Match {
        private final String key;
        private final String value;
        private final Pattern keyPattern;
        private final Pattern valuePattern;
        private final Mode mode;

        public ExactKeyValue(boolean regexp, String key, String value) throws ParseError {
            if ("".equals(key)) {
                throw new ParseError(I18n.tr("Key cannot be empty when tag operator is used. Sample use: key=value"));
            }
            this.key = key;
            String string = this.value = value == null ? "" : value;
            this.mode = "".equals(this.value) && "*".equals(key) ? Mode.NONE : ("".equals(this.value) ? (regexp ? Mode.MISSING_KEY_REGEXP : Mode.MISSING_KEY) : ("*".equals(key) && "*".equals(this.value) ? Mode.ANY : ("*".equals(key) ? (regexp ? Mode.ANY_KEY_REGEXP : Mode.ANY_KEY) : ("*".equals(this.value) ? (regexp ? Mode.ANY_VALUE_REGEXP : Mode.ANY_VALUE) : (regexp ? Mode.EXACT_REGEXP : Mode.EXACT)))));
            if (regexp && key.length() > 0 && !key.equals("*")) {
                try {
                    this.keyPattern = Pattern.compile(key, SearchCompiler.regexFlags(false));
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr(rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()));
                }
                catch (Exception e) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, key, e.getMessage()));
                }
            } else {
                this.keyPattern = null;
            }
            if (regexp && this.value.length() > 0 && !this.value.equals("*")) {
                try {
                    this.valuePattern = Pattern.compile(this.value, SearchCompiler.regexFlags(false));
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr(rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()));
                }
                catch (Exception e) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, value, e.getMessage()));
                }
            } else {
                this.valuePattern = null;
            }
        }

        public boolean match(OsmPrimitive osm) {
            if (!osm.hasKeys()) {
                return this.mode == Mode.NONE;
            }
            switch (this.mode) {
                case NONE: {
                    return false;
                }
                case MISSING_KEY: {
                    return osm.get(this.key) == null;
                }
                case ANY: {
                    return true;
                }
                case ANY_VALUE: {
                    return osm.get(this.key) != null;
                }
                case ANY_KEY: {
                    for (String v : osm.getKeys().values()) {
                        if (!v.equals(this.value)) continue;
                        return true;
                    }
                    return false;
                }
                case EXACT: {
                    return this.value.equals(osm.get(this.key));
                }
                case ANY_KEY_REGEXP: {
                    for (String v : osm.getKeys().values()) {
                        if (!this.valuePattern.matcher(v).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case ANY_VALUE_REGEXP: 
                case EXACT_REGEXP: {
                    for (String key : osm.keySet()) {
                        if (!this.keyPattern.matcher(key).matches() || this.mode != Mode.ANY_VALUE_REGEXP && !this.valuePattern.matcher(osm.get(key)).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case MISSING_KEY_REGEXP: {
                    for (String k : osm.keySet()) {
                        if (!this.keyPattern.matcher(k).matches()) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new AssertionError((Object)"Missed state");
        }

        public String toString() {
            return this.key + '=' + this.value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Mode {
            ANY,
            ANY_KEY,
            ANY_VALUE,
            EXACT,
            NONE,
            MISSING_KEY,
            ANY_KEY_REGEXP,
            ANY_VALUE_REGEXP,
            EXACT_REGEXP,
            MISSING_KEY_REGEXP;

        }
    }

    private static class KeyValue
    extends Match {
        private final String key;
        private final Pattern keyPattern;
        private final String value;
        private final Pattern valuePattern;
        private final boolean caseSensitive;

        public KeyValue(String key, String value, boolean regexSearch, boolean caseSensitive) throws ParseError {
            this.caseSensitive = caseSensitive;
            if (regexSearch) {
                int searchFlags = SearchCompiler.regexFlags(caseSensitive);
                try {
                    this.keyPattern = Pattern.compile(key, searchFlags);
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr(rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()));
                }
                catch (Exception e) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, key, e.getMessage()));
                }
                try {
                    this.valuePattern = Pattern.compile(value, searchFlags);
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr(rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()));
                }
                catch (Exception e) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, value, e.getMessage()));
                }
                this.key = key;
                this.value = value;
            } else if (caseSensitive) {
                this.key = key;
                this.value = value;
                this.keyPattern = null;
                this.valuePattern = null;
            } else {
                this.key = key.toLowerCase();
                this.value = value;
                this.keyPattern = null;
                this.valuePattern = null;
            }
        }

        public boolean match(OsmPrimitive osm) {
            if (this.keyPattern != null) {
                if (!osm.hasKeys()) {
                    return false;
                }
                for (String k : osm.keySet()) {
                    Matcher matcherValue;
                    boolean matchedValue;
                    String v = osm.get(k);
                    Matcher matcherKey = this.keyPattern.matcher(k);
                    boolean matchedKey = matcherKey.find();
                    if (!matchedKey || !(matchedValue = (matcherValue = this.valuePattern.matcher(v)).find())) continue;
                    return true;
                }
            } else {
                String mv = null;
                mv = this.key.equals("timestamp") ? DateUtils.fromDate(osm.getTimestamp()) : osm.get(this.key);
                if (mv == null) {
                    return false;
                }
                String v1 = this.caseSensitive ? mv : mv.toLowerCase();
                String v2 = this.caseSensitive ? this.value : this.value.toLowerCase();
                v1 = Normalizer.normalize(v1, Normalizer.Form.NFC);
                v2 = Normalizer.normalize(v2, Normalizer.Form.NFC);
                return v1.indexOf(v2) != -1;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class Version
    extends Match {
        private long version;

        public Version(long version) {
            this.version = version;
        }

        public boolean match(OsmPrimitive osm) {
            return osm.getVersion() == this.version;
        }

        public String toString() {
            return "version=" + this.version;
        }
    }

    private static class ChangesetId
    extends Match {
        private long changesetid;

        public ChangesetId(long changesetid) {
            this.changesetid = changesetid;
        }

        public boolean match(OsmPrimitive osm) {
            return (long)osm.getChangesetId() == this.changesetid;
        }

        public String toString() {
            return "changeset=" + this.changesetid;
        }
    }

    private static class Id
    extends Match {
        private long id;

        public Id(long id) {
            this.id = id;
        }

        public boolean match(OsmPrimitive osm) {
            return this.id == 0L ? osm.isNew() : osm.getUniqueId() == this.id;
        }

        public String toString() {
            return "id=" + this.id;
        }
    }

    private static class Or
    extends Match {
        private Match lhs;
        private Match rhs;

        public Or(Match lhs, Match rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public boolean match(OsmPrimitive osm) {
            return this.lhs.match(osm) || this.rhs.match(osm);
        }

        public String toString() {
            return this.lhs + " || " + this.rhs;
        }
    }

    private static class And
    extends Match {
        private Match lhs;
        private Match rhs;

        public And(Match lhs, Match rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public boolean match(OsmPrimitive osm) {
            return this.lhs.match(osm) && this.rhs.match(osm);
        }

        public String toString() {
            return this.lhs + " && " + this.rhs;
        }
    }

    private static class BooleanMatch
    extends Match {
        private final String key;
        private final boolean defaultValue;

        public BooleanMatch(String key, boolean defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public boolean match(OsmPrimitive osm) {
            Boolean ret = OsmUtils.getOsmBoolean(osm.get(this.key));
            if (ret == null) {
                return this.defaultValue;
            }
            return ret;
        }
    }

    public static class Not
    extends Match {
        private final Match match;

        public Not(Match match) {
            this.match = match;
        }

        public boolean match(OsmPrimitive osm) {
            return !this.match.match(osm);
        }

        public String toString() {
            return "!" + this.match;
        }
    }

    public static class Never
    extends Match {
        public boolean match(OsmPrimitive osm) {
            return false;
        }
    }

    public static class Always
    extends Match {
        public static Always INSTANCE = new Always();

        public boolean match(OsmPrimitive osm) {
            return true;
        }
    }

    public static abstract class Match {
        public abstract boolean match(OsmPrimitive var1);
    }
}

