/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle"), "aligncircle", I18n.tr("Move the selected nodes into a circle."), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle")), 79, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInCircle"));
    }

    public double distance(EastNorth n, EastNorth m) {
        double easd = n.east() - m.east();
        double nord = n.north() - m.north();
        return Math.sqrt(easd * easd + nord * nord);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PolarCoor pc;
        BigDecimal north;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList<Way> ways = new LinkedList<Way>();
        EastNorth center = null;
        double radius = 0.0;
        boolean regular = false;
        for (OsmPrimitive osm : sel) {
            if (osm instanceof Node) {
                nodes.add((Node)osm);
                continue;
            }
            if (!(osm instanceof Way)) continue;
            ways.add((Way)osm);
        }
        if (nodes.size() <= 2 && ways.size() == 1) {
            Way way = (Way)ways.get(0);
            if (nodes.size() > 0) {
                if (nodes.size() == 1 && way.containsNode((Node)nodes.get(0))) {
                    regular = true;
                } else {
                    center = ((Node)nodes.get(way.containsNode((Node)nodes.get(0)) ? 1 : 0)).getEastNorth();
                    if (nodes.size() == 2) {
                        radius = this.distance(((Node)nodes.get(0)).getEastNorth(), ((Node)nodes.get(1)).getEastNorth());
                    }
                }
                nodes = new LinkedList();
            }
            for (Node n : way.getNodes()) {
                if (nodes.contains(n)) continue;
                nodes.add(n);
            }
        }
        if (nodes.size() < 4) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least four nodes."), I18n.tr("Information"), 1);
            return;
        }
        if (ways.size() != 1) {
            BigDecimal east = new BigDecimal(0);
            north = new BigDecimal(0);
            for (Node n : nodes) {
                BigDecimal x = new BigDecimal(n.getEastNorth().east());
                BigDecimal y = new BigDecimal(n.getEastNorth().north());
                east = east.add(x, MathContext.DECIMAL128);
                north = north.add(y, MathContext.DECIMAL128);
            }
            BigDecimal nodesSize = new BigDecimal(nodes.size());
            east = east.divide(nodesSize, MathContext.DECIMAL128);
            north = north.divide(nodesSize, MathContext.DECIMAL128);
            EastNorth average = new EastNorth(east.doubleValue(), north.doubleValue());
            LinkedList<Node> newNodes = new LinkedList<Node>();
            while (!nodes.isEmpty()) {
                double maxHeading = -1.0;
                Node maxNode = null;
                for (Node n : nodes) {
                    double heading = average.heading(n.getEastNorth());
                    if (!(heading > maxHeading)) continue;
                    maxHeading = heading;
                    maxNode = n;
                }
                newNodes.add(maxNode);
                nodes.remove(maxNode);
            }
            nodes = newNodes;
        }
        if (center == null) {
            BigDecimal area = new BigDecimal(0);
            north = new BigDecimal(0);
            BigDecimal east = new BigDecimal(0);
            for (int i = 0; i < nodes.size(); ++i) {
                EastNorth n0 = ((Node)nodes.get(i)).getEastNorth();
                EastNorth n1 = ((Node)nodes.get((i + 1) % nodes.size())).getEastNorth();
                BigDecimal x0 = new BigDecimal(n0.east());
                BigDecimal y0 = new BigDecimal(n0.north());
                BigDecimal x1 = new BigDecimal(n1.east());
                BigDecimal y1 = new BigDecimal(n1.north());
                BigDecimal k = x0.multiply(y1, MathContext.DECIMAL128).subtract(y0.multiply(x1, MathContext.DECIMAL128));
                area = area.add(k, MathContext.DECIMAL128);
                east = east.add(k.multiply(x0.add(x1, MathContext.DECIMAL128), MathContext.DECIMAL128));
                north = north.add(k.multiply(y0.add(y1, MathContext.DECIMAL128), MathContext.DECIMAL128));
            }
            BigDecimal d = new BigDecimal(3, MathContext.DECIMAL128);
            area = area.multiply(d, MathContext.DECIMAL128);
            north = north.divide(area, MathContext.DECIMAL128);
            east = east.divide(area, MathContext.DECIMAL128);
            center = new EastNorth(east.doubleValue(), north.doubleValue());
        }
        if (radius == 0.0) {
            for (Node n : nodes) {
                radius += this.distance(center, n.getEastNorth());
            }
            radius /= (double)nodes.size();
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        if (regular) {
            double angle = Math.PI * 2 / (double)nodes.size();
            pc = new PolarCoor(((Node)nodes.get(0)).getEastNorth(), center, 0.0);
            PolarCoor polarCoor = new PolarCoor(((Node)nodes.get(1)).getEastNorth(), center, 0.0);
            if (pc.angle > polarCoor.angle) {
                angle *= -1.0;
            }
            pc.radius = radius;
            for (Node n : nodes) {
                EastNorth no = pc.toEastNorth();
                cmds.add(new MoveCommand(n, no.east() - n.getEastNorth().east(), no.north() - n.getEastNorth().north()));
                pc.angle += angle;
            }
        } else {
            for (Node n : nodes) {
                pc = new PolarCoor(n.getEastNorth(), center, 0.0);
                pc.radius = radius;
                EastNorth no = pc.toEastNorth();
                cmds.add(new MoveCommand(n, no.east() - n.getEastNorth().east(), no.north() - n.getEastNorth().north()));
            }
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Circle"), cmds));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    public class PolarCoor {
        double radius;
        double angle;
        EastNorth origin = new EastNorth(0.0, 0.0);
        double azimuth = 0.0;

        PolarCoor(double radius, double angle) {
            this(radius, angle, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(double radius, double angle, EastNorth origin, double azimuth) {
            this.radius = radius;
            this.angle = angle;
            this.origin = origin;
            this.azimuth = azimuth;
        }

        PolarCoor(EastNorth en) {
            this(en, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(EastNorth en, EastNorth origin, double azimuth) {
            this.radius = AlignInCircleAction.this.distance(en, origin);
            this.angle = Math.atan2(en.north() - origin.north(), en.east() - origin.east());
            this.origin = origin;
            this.azimuth = azimuth;
        }

        public EastNorth toEastNorth() {
            return new EastNorth(this.radius * Math.cos(this.angle - this.azimuth) + this.origin.east(), this.radius * Math.sin(this.angle - this.azimuth) + this.origin.north());
        }
    }
}

