/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmTileSource {
    public static final String MAP_MAPNIK = "http://tile.openstreetmap.org";
    public static final String MAP_OSMA = "http://tah.openstreetmap.org/Tiles";

    public static class Maplint
    extends OsmaSource {
        public Maplint() {
            super("Maplint", "maplint");
        }
    }

    public static class TilesAtHome
    extends OsmaSource {
        public TilesAtHome() {
            super("TilesAtHome", "tile");
        }
    }

    public static abstract class OsmaSource
    extends AbstractOsmTileSource {
        String osmaSuffix;

        public OsmaSource(String name, String osmaSuffix) {
            super(name, OsmTileSource.MAP_OSMA);
            this.osmaSuffix = osmaSuffix;
        }

        public int getMaxZoom() {
            return 17;
        }

        public String getBaseUrl() {
            return "http://tah.openstreetmap.org/Tiles/" + this.osmaSuffix;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfModifiedSince;
        }
    }

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.tile.opencyclemap.org/cycle";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int SERVER_NUM = 0;

        public CycleMap() {
            super("OSM Cycle Map", PATTERN);
        }

        public String getBaseUrl() {
            String url = String.format(this.BASE_URL, SERVER[this.SERVER_NUM]);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return url;
        }

        public int getMaxZoom() {
            return 17;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.LastModified;
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        public Mapnik() {
            super("Mapnik", OsmTileSource.MAP_MAPNIK);
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static abstract class AbstractOsmTileSource
    implements TileSource {
        protected String NAME;
        protected String BASE_URL;

        public AbstractOsmTileSource(String name, String base_url) {
            this.NAME = name;
            this.BASE_URL = base_url;
        }

        public String getName() {
            return this.NAME;
        }

        public int getMaxZoom() {
            return 18;
        }

        public int getMinZoom() {
            return 0;
        }

        public String getExtension() {
            return "png";
        }

        public String getTilePath(int zoom, int tilex, int tiley) {
            return "/" + zoom + "/" + tilex + "/" + tiley + "." + this.getExtension();
        }

        public String getBaseUrl() {
            return this.BASE_URL;
        }

        public String getTileUrl(int zoom, int tilex, int tiley) {
            return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley);
        }

        public String toString() {
            return this.getName();
        }

        public String getTileType() {
            return "png";
        }

        public int getTileSize() {
            return 256;
        }
    }
}

