/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.soql.DefaultScriptObject;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaHeap;
import sun.jvm.hotspot.utilities.soql.JSList;
import sun.jvm.hotspot.utilities.soql.JSMap;

public class JSJavaVM
extends DefaultScriptObject {
    private static final int FIELD_ADDRESS_SIZE = 0;
    private static final int FIELD_BUILD_INFO = 1;
    private static final int FIELD_CPU = 2;
    private static final int FIELD_FLAGS = 3;
    private static final int FIELD_HEAP = 4;
    private static final int FIELD_OS = 5;
    private static final int FIELD_SYS_PROPS = 6;
    private static final int FIELD_THREADS = 7;
    private static final int FIELD_TYPE = 8;
    private static final int FIELD_VERSION = 9;
    private static final int FIELD_CLASS_PATH = 10;
    private static final int FIELD_BOOT_CLASS_PATH = 11;
    private static final int FIELD_USER_DIR = 12;
    private static final int FIELD_UNDEFINED = -1;
    private static Map fields = new HashMap();
    private JSMap flagsCache;
    private JSJavaHeap heapCache;
    private JSMap sysPropsCache;
    private JSList threadsCache;
    private final JSJavaFactory factory;
    private final VM vm;

    public JSJavaVM(JSJavaFactory factory) {
        this.factory = factory;
        this.vm = VM.getVM();
    }

    public Object get(String name) {
        int fieldID = JSJavaVM.getFieldID(name);
        switch (fieldID) {
            case 0: {
                return new Long(this.getVMBit());
            }
            case 1: {
                return this.vm.getVMInternalInfo();
            }
            case 2: {
                return this.vm.getCPU();
            }
            case 3: {
                return this.getFlags();
            }
            case 4: {
                return this.getHeap();
            }
            case 5: {
                return this.vm.getOS();
            }
            case 6: {
                return this.getSysProps();
            }
            case 7: {
                return this.getThreads();
            }
            case 8: {
                return this.getType();
            }
            case 9: {
                return this.vm.getVMRelease();
            }
            case 10: {
                return this.getClassPath();
            }
            case 11: {
                return this.getBootClassPath();
            }
            case 12: {
                return this.getUserDir();
            }
        }
        return super.get(name);
    }

    public Object[] getIds() {
        Object[] superIds = super.getIds();
        Object[] tmp = fields.keySet().toArray();
        Object[] res = new Object[superIds.length + tmp.length];
        System.arraycopy(tmp, 0, res, 0, tmp.length);
        System.arraycopy(superIds, 0, res, tmp.length, superIds.length);
        return res;
    }

    public boolean has(String name) {
        if (JSJavaVM.getFieldID(name) != -1) {
            return true;
        }
        return super.has(name);
    }

    public void put(String name, Object value) {
        if (JSJavaVM.getFieldID(name) == -1) {
            super.put(name, value);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Java Hotspot ");
        buf.append(this.getType());
        buf.append(' ');
        buf.append(this.getVMBit());
        buf.append(" bit VM (build ");
        buf.append(this.vm.getVMRelease());
        buf.append(")");
        return buf.toString();
    }

    private static void addField(String name, int fieldId) {
        fields.put(name, new Integer(fieldId));
    }

    private static int getFieldID(String name) {
        Integer res = (Integer)fields.get(name);
        return res != null ? res : -1;
    }

    private long getVMBit() {
        return this.vm.getAddressSize() * 8L;
    }

    private synchronized JSMap getFlags() {
        if (this.flagsCache == null) {
            VM.Flag[] flags = this.vm.getCommandLineFlags();
            HashMap<String, String> map = new HashMap<String, String>();
            if (flags != null) {
                for (int f = 0; f < flags.length; ++f) {
                    VM.Flag flag = flags[f];
                    map.put(flag.getName(), flag.getValue());
                }
            }
            this.flagsCache = this.factory.newJSMap(map);
        }
        return this.flagsCache;
    }

    private synchronized JSJavaHeap getHeap() {
        if (this.heapCache == null) {
            this.heapCache = this.factory.newJSJavaHeap();
        }
        return this.heapCache;
    }

    private synchronized JSMap getSysProps() {
        if (this.sysPropsCache == null) {
            Properties props = this.vm.getSystemProperties();
            HashMap<String, String> map = new HashMap<String, String>();
            if (props != null) {
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    map.put(key, props.getProperty(key));
                }
            }
            this.sysPropsCache = this.factory.newJSMap(map);
        }
        return this.sysPropsCache;
    }

    private synchronized JSList getThreads() {
        if (this.threadsCache == null) {
            ArrayList<JavaThread> threads = new ArrayList<JavaThread>(0);
            this.threadsCache = this.factory.newJSList(threads);
            for (JavaThread jthread = this.vm.getThreads().first(); jthread != null; jthread = jthread.next()) {
                threads.add(jthread);
            }
        }
        return this.threadsCache;
    }

    private String getType() {
        if (this.vm.isClientCompiler()) {
            return "Client";
        }
        if (this.vm.isServerCompiler()) {
            return "Server";
        }
        return "Core";
    }

    private String getClassPath() {
        return this.vm.getSystemProperty("java.class.path");
    }

    private String getBootClassPath() {
        return this.vm.getSystemProperty("sun.boot.class.path");
    }

    private String getUserDir() {
        return this.vm.getSystemProperty("user.dir");
    }

    static {
        JSJavaVM.addField("addressSize", 0);
        JSJavaVM.addField("buildInfo", 1);
        JSJavaVM.addField("cpu", 2);
        JSJavaVM.addField("flags", 3);
        JSJavaVM.addField("heap", 4);
        JSJavaVM.addField("os", 5);
        JSJavaVM.addField("sysProps", 6);
        JSJavaVM.addField("threads", 7);
        JSJavaVM.addField("type", 8);
        JSJavaVM.addField("version", 9);
        JSJavaVM.addField("classPath", 10);
        JSJavaVM.addField("bootClassPath", 11);
        JSJavaVM.addField("userDir", 12);
    }
}

