/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.VariableGridLayout;

public class BorderedComponent
extends JPanel
implements ActionListener {
    JButton moreOrLessButton;
    String valueLabelStr;
    JLabel label;
    JComponent comp;
    boolean collapsed = false;
    private JPopupMenu popupMenu;
    private Icon collapseIcon;
    private Icon expandIcon;

    private static Image getImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        string = "resources/" + string + ".png";
        return toolkit.getImage(BorderedComponent.class.getResource(string));
    }

    public BorderedComponent(String string) {
        this(string, null, false);
    }

    public BorderedComponent(String string, JComponent jComponent) {
        this(string, jComponent, false);
    }

    public BorderedComponent(String string, JComponent jComponent, boolean bl) {
        super(null);
        this.comp = jComponent;
        if (string != null) {
            TitledBorder titledBorder;
            if (bl) {
                final JLabel jLabel = new JLabel(string);
                JPanel jPanel = new JPanel(new FlowLayout(0, 2, 0)){

                    @Override
                    public int getBaseline(int n, int n2) {
                        Dimension dimension = jLabel.getPreferredSize();
                        return jLabel.getBaseline(dimension.width, dimension.height) + jLabel.getY();
                    }
                };
                jPanel.add(jLabel);
                titledBorder = new LabeledBorder(jPanel);
                jLabel.setForeground(titledBorder.getTitleColor());
                if (JConsole.IS_WIN) {
                    this.collapseIcon = new ImageIcon(BorderedComponent.getImage("collapse-winlf"));
                    this.expandIcon = new ImageIcon(BorderedComponent.getImage("expand-winlf"));
                } else {
                    this.collapseIcon = new ArrowIcon(5, jLabel);
                    this.expandIcon = new ArrowIcon(3, jLabel);
                }
                this.moreOrLessButton = new JButton(this.collapseIcon);
                this.moreOrLessButton.setContentAreaFilled(false);
                this.moreOrLessButton.setBorderPainted(false);
                this.moreOrLessButton.setMargin(new Insets(0, 0, 0, 0));
                this.moreOrLessButton.addActionListener(this);
                String string2 = Resources.getText("BorderedComponent.moreOrLessButton.toolTip", new Object[0]);
                this.moreOrLessButton.setToolTipText(string2);
                jPanel.add(this.moreOrLessButton);
                jPanel.setSize(jPanel.getPreferredSize());
                this.add(jPanel);
            } else {
                titledBorder = new TitledBorder(string);
            }
            this.setBorder(new CompoundBorder(new FocusBorder(this), titledBorder));
        } else {
            this.setBorder(new FocusBorder(this));
        }
        if (jComponent != null) {
            this.add(jComponent);
        }
    }

    public void setComponent(JComponent jComponent) {
        if (this.comp != null) {
            this.remove(this.comp);
        }
        this.comp = jComponent;
        if (!this.collapsed) {
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof BorderLayout) {
                this.add((Component)jComponent, "Center");
            } else {
                this.add(jComponent);
            }
        }
        this.revalidate();
    }

    public void setValueLabel(String string) {
        this.valueLabelStr = string;
        if (this.label != null) {
            this.label.setText(Resources.getText("Current value", this.valueLabelStr));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.collapsed) {
            if (this.label != null) {
                this.remove(this.label);
            }
            this.add(this.comp);
            this.moreOrLessButton.setIcon(this.collapseIcon);
        } else {
            this.remove(this.comp);
            if (this.valueLabelStr != null) {
                if (this.label == null) {
                    this.label = new JLabel(Resources.getText("Current value", this.valueLabelStr));
                }
                this.add(this.label);
            }
            this.moreOrLessButton.setIcon(this.expandIcon);
        }
        this.collapsed = !this.collapsed;
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent != null && jComponent.getLayout() instanceof VariableGridLayout) {
            ((VariableGridLayout)jComponent.getLayout()).setFillRow(this, !this.collapsed);
            jComponent.revalidate();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.getLayout() != null) {
            return super.getMinimumSize();
        }
        if (this.moreOrLessButton != null) {
            Dimension dimension = this.moreOrLessButton.getMinimumSize();
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
        return super.getMinimumSize();
    }

    @Override
    public void doLayout() {
        if (this.getLayout() != null) {
            super.doLayout();
            return;
        }
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        if (this.collapsed) {
            if (this.label != null) {
                Dimension dimension2 = this.label.getPreferredSize();
                this.label.setBounds(insets.left, insets.top + (dimension.height - insets.top - insets.bottom - dimension2.height) / 2, dimension2.width, dimension2.height);
            }
        } else if (this.comp != null) {
            this.comp.setBounds(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        }
    }

    protected static class FocusBorder
    extends AbstractBorder
    implements FocusListener {
        private Component comp;
        private Color focusColor;
        private boolean focusLostTemporarily = false;

        public FocusBorder(Component component) {
            this.comp = component;
            component.addFocusListener(this);
            this.focusColor = UIManager.getColor("TabbedPane.focus");
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.comp.hasFocus() || this.focusLostTemporarily) {
                Color color = graphics.getColor();
                graphics.setColor(this.focusColor);
                BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
                graphics.setColor(color);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(2, 2, 2, 2);
            return insets;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.comp.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusLostTemporarily = focusEvent.isTemporary();
            if (!this.focusLostTemporarily) {
                this.comp.repaint();
            }
        }
    }

    protected static class LabeledBorder
    extends TitledBorder {
        protected JComponent label;
        private Point compLoc = new Point();

        public LabeledBorder(JComponent jComponent) {
            this(null, jComponent);
        }

        public LabeledBorder(Border border) {
            this(border, (JComponent)null);
        }

        public LabeledBorder(Border border, JComponent jComponent) {
            super(border);
            this.label = jComponent;
            if (jComponent instanceof JLabel && jComponent.getForeground() instanceof ColorUIResource) {
                jComponent.setForeground(this.getTitleColor());
            }
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Border border = this.getBorder();
            if (this.label == null) {
                if (border != null) {
                    border.paintBorder(component, graphics, n, n2, n3, n4);
                }
                return;
            }
            Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
            Dimension dimension = this.label.getPreferredSize();
            int n5 = this.label.getBaseline(dimension.width, dimension.height);
            int n6 = Math.max(0, n5);
            int n7 = dimension.height - n6;
            Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
            int n8 = Math.max(0, n6 / 2 + 2 - 2);
            rectangle.y += n8;
            rectangle.height -= n8;
            this.compLoc.y = rectangle.y + insets.top / 2 - (n6 + n7) / 2 - 1;
            int n9 = component.getComponentOrientation().isLeftToRight() ? 1 : 3;
            switch (n9) {
                case 1: {
                    this.compLoc.x = rectangle.x + 5 + insets.left;
                    break;
                }
                case 3: {
                    this.compLoc.x = rectangle.x + rectangle.width - (dimension.width + 5 + insets.right);
                }
            }
            if (border != null) {
                if (rectangle.y > this.compLoc.y - n6) {
                    Rectangle rectangle2 = new Rectangle();
                    Rectangle rectangle3 = graphics.getClipBounds();
                    rectangle2.setBounds(rectangle3);
                    if (LabeledBorder.computeIntersection(rectangle2, n, n2, this.compLoc.x - 1 - n, n4)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    rectangle2.setBounds(rectangle3);
                    if (LabeledBorder.computeIntersection(rectangle2, this.compLoc.x + dimension.width + 1, n2, n + n3 - (this.compLoc.x + dimension.width + 1), n4)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    rectangle2.setBounds(rectangle3);
                    if (LabeledBorder.computeIntersection(rectangle2, this.compLoc.x - 1, this.compLoc.y + n6 + n7, dimension.width + 2, n2 + n4 - this.compLoc.y - n6 - n7)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    graphics.setClip(rectangle3);
                } else {
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.label.setLocation(this.compLoc);
                this.label.setSize(dimension);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            int n = 16;
            Border border = this.getBorder();
            if (border != null) {
                if (border instanceof AbstractBorder) {
                    ((AbstractBorder)border).getBorderInsets(component, insets);
                } else {
                    Insets insets2 = border.getBorderInsets(component);
                    insets.top = insets2.top;
                    insets.right = insets2.right;
                    insets.bottom = insets2.bottom;
                    insets.left = insets2.left;
                }
            } else {
                insets.bottom = 0;
                insets.right = 0;
                insets.top = 0;
                insets.left = 0;
            }
            insets.left += 4;
            insets.right += 4;
            insets.top += 4;
            insets.bottom += 4;
            if (component == null || this.label == null) {
                return insets;
            }
            insets.top += this.label.getHeight();
            return insets;
        }

        public JComponent getLabel() {
            return this.label;
        }

        public void setLabel(JComponent jComponent) {
            this.label = jComponent;
        }

        @Override
        public Dimension getMinimumSize(Component component) {
            Insets insets = this.getBorderInsets(component);
            Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
            dimension.width += this.label.getWidth();
            return dimension;
        }

        private static boolean computeIntersection(Rectangle rectangle, int n, int n2, int n3, int n4) {
            int n5 = Math.max(n, rectangle.x);
            int n6 = Math.min(n + n3, rectangle.x + rectangle.width);
            int n7 = Math.max(n2, rectangle.y);
            int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height);
            rectangle.x = n5;
            rectangle.y = n7;
            rectangle.width = n6 - n5;
            rectangle.height = n8 - n7;
            return rectangle.width > 0 && rectangle.height > 0;
        }
    }

    private static class ArrowIcon
    implements Icon {
        private int direction;
        private JLabel textLabel;

        public ArrowIcon(int n, JLabel jLabel) {
            this.direction = n;
            this.textLabel = jLabel;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            int n4 = n3 = this.getIconWidth();
            Polygon polygon = new Polygon();
            switch (this.direction) {
                case 3: {
                    polygon.addPoint(n + 2, n2);
                    polygon.addPoint(n + n3 - 2, n2 + n4 / 2);
                    polygon.addPoint(n + 2, n2 + n4 - 1);
                    break;
                }
                case 5: {
                    polygon.addPoint(n, n2 + 2);
                    polygon.addPoint(n + n3 / 2, n2 + n4 - 2);
                    polygon.addPoint(n + n3 - 1, n2 + 2);
                }
            }
            graphics.fillPolygon(polygon);
        }

        @Override
        public int getIconWidth() {
            return this.getIconHeight();
        }

        @Override
        public int getIconHeight() {
            Graphics graphics = this.textLabel.getGraphics();
            if (graphics != null) {
                int n = graphics.getFontMetrics(this.textLabel.getFont()).getAscent() * 6 / 10;
                if (n % 2 == 0) {
                    ++n;
                }
                return n;
            }
            return 7;
        }
    }
}

