/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipConstants;
import com.sun.nio.zipfs.ZipFileSystem;
import com.sun.nio.zipfs.ZipFileSystemProvider;
import com.sun.nio.zipfs.ZipUtils;
import java.nio.file.FileRef;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;

public class ZipInfo {
    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length < 1) {
            ZipInfo.print("Usage: java ZipInfo zfname", new Object[0]);
        } else {
            Map map = Collections.emptyMap();
            ZipFileSystem zipFileSystem = (ZipFileSystem)new ZipFileSystemProvider().newFileSystem((FileRef)Paths.get((String)stringArray[0]), map);
            byte[] byArray = zipFileSystem.cen;
            if (byArray == null) {
                ZipInfo.print("zip file is empty%n", new Object[0]);
                return;
            }
            int n = 0;
            byte[] byArray2 = new byte[1024];
            int n2 = 1;
            while (n + 46 < byArray.length) {
                ZipInfo.print("----------------#%d--------------------%n", n2++);
                ZipInfo.printCEN(byArray, n);
                long l = 30 + ZipConstants.CENNAM(byArray, n) + ZipConstants.CENEXT(byArray, n) + 46;
                if (zipFileSystem.readFullyAt(byArray2, 0, l, ZipInfo.locoff(byArray, n)) != l) {
                    ZipFileSystem.zerror("read loc header failed");
                }
                if (ZipConstants.LOCEXT(byArray2) > ZipConstants.CENEXT(byArray, n) + 46 && zipFileSystem.readFullyAt(byArray2, 0, l = (long)(30 + ZipConstants.LOCNAM(byArray2) + ZipConstants.LOCEXT(byArray2)), ZipInfo.locoff(byArray, n)) != l) {
                    ZipFileSystem.zerror("read loc header failed");
                }
                ZipInfo.printLOC(byArray2);
                n += 46 + ZipConstants.CENNAM(byArray, n) + ZipConstants.CENEXT(byArray, n) + ZipConstants.CENCOM(byArray, n);
            }
            zipFileSystem.close();
        }
    }

    static void print(String string, Object ... objectArray) {
        System.out.printf(string, objectArray);
    }

    static void printLOC(byte[] byArray) {
        ZipInfo.print("%n", new Object[0]);
        ZipInfo.print("[Local File Header]%n", new Object[0]);
        ZipInfo.print("    Signature   :   %#010x%n", ZipConstants.LOCSIG(byArray));
        if (ZipConstants.LOCSIG(byArray) != ZipConstants.LOCSIG) {
            ZipInfo.print("    Wrong signature!", new Object[0]);
            return;
        }
        ZipInfo.print("    Version     :       %#6x    [%d.%d]%n", ZipConstants.LOCVER(byArray), ZipConstants.LOCVER(byArray) / 10, ZipConstants.LOCVER(byArray) % 10);
        ZipInfo.print("    Flag        :       %#6x%n", ZipConstants.LOCFLG(byArray));
        ZipInfo.print("    Method      :       %#6x%n", ZipConstants.LOCHOW(byArray));
        ZipInfo.print("    LastMTime   :   %#10x    [%tc]%n", ZipConstants.LOCTIM(byArray), ZipUtils.dosToJavaTime(ZipConstants.LOCTIM(byArray)));
        ZipInfo.print("    CRC         :   %#10x%n", ZipConstants.LOCCRC(byArray));
        ZipInfo.print("    CSize       :   %#10x%n", ZipConstants.LOCSIZ(byArray));
        ZipInfo.print("    Size        :   %#10x%n", ZipConstants.LOCLEN(byArray));
        ZipInfo.print("    NameLength  :       %#6x    [%s]%n", ZipConstants.LOCNAM(byArray), new String(byArray, 30, ZipConstants.LOCNAM(byArray)));
        ZipInfo.print("    ExtraLength :       %#6x%n", ZipConstants.LOCEXT(byArray));
        if (ZipConstants.LOCEXT(byArray) != 0) {
            ZipInfo.printExtra(byArray, 30 + ZipConstants.LOCNAM(byArray), ZipConstants.LOCEXT(byArray));
        }
    }

    static void printCEN(byte[] byArray, int n) {
        ZipInfo.print("[Central Directory Header]%n", new Object[0]);
        ZipInfo.print("    Signature   :   %#010x%n", ZipConstants.CENSIG(byArray, n));
        if (ZipConstants.CENSIG(byArray, n) != ZipConstants.CENSIG) {
            ZipInfo.print("    Wrong signature!", new Object[0]);
            return;
        }
        ZipInfo.print("    VerMadeby   :       %#6x    [%d, %d.%d]%n", ZipConstants.CENVEM(byArray, n), ZipConstants.CENVEM(byArray, n) >> 8, (ZipConstants.CENVEM(byArray, n) & 0xFF) / 10, (ZipConstants.CENVEM(byArray, n) & 0xFF) % 10);
        ZipInfo.print("    VerExtract  :       %#6x    [%d.%d]%n", ZipConstants.CENVER(byArray, n), ZipConstants.CENVER(byArray, n) / 10, ZipConstants.CENVER(byArray, n) % 10);
        ZipInfo.print("    Flag        :       %#6x%n", ZipConstants.CENFLG(byArray, n));
        ZipInfo.print("    Method      :       %#6x%n", ZipConstants.CENHOW(byArray, n));
        ZipInfo.print("    LastMTime   :   %#10x    [%tc]%n", ZipConstants.CENTIM(byArray, n), ZipUtils.dosToJavaTime(ZipConstants.CENTIM(byArray, n)));
        ZipInfo.print("    CRC         :   %#10x%n", ZipConstants.CENCRC(byArray, n));
        ZipInfo.print("    CSize       :   %#10x%n", ZipConstants.CENSIZ(byArray, n));
        ZipInfo.print("    Size        :   %#10x%n", ZipConstants.CENLEN(byArray, n));
        ZipInfo.print("    NameLen     :       %#6x    [%s]%n", ZipConstants.CENNAM(byArray, n), new String(byArray, n + 46, ZipConstants.CENNAM(byArray, n)));
        ZipInfo.print("    ExtraLen    :       %#6x%n", ZipConstants.CENEXT(byArray, n));
        if (ZipConstants.CENEXT(byArray, n) != 0) {
            ZipInfo.printExtra(byArray, n + 46 + ZipConstants.CENNAM(byArray, n), ZipConstants.CENEXT(byArray, n));
        }
        ZipInfo.print("    CommentLen  :       %#6x%n", ZipConstants.CENCOM(byArray, n));
        ZipInfo.print("    DiskStart   :       %#6x%n", ZipConstants.CENDSK(byArray, n));
        ZipInfo.print("    Attrs       :       %#6x%n", ZipConstants.CENATT(byArray, n));
        ZipInfo.print("    AttrsEx     :   %#10x%n", ZipConstants.CENATX(byArray, n));
        ZipInfo.print("    LocOff      :   %#10x%n", ZipConstants.CENOFF(byArray, n));
    }

    static long locoff(byte[] byArray, int n) {
        long l = ZipConstants.CENOFF(byArray, n);
        if (l == 0xFFFFFFFFL) {
            int n2 = n + 46 + ZipConstants.CENNAM(byArray, n);
            int n3 = n2 + ZipConstants.CENEXT(byArray, n);
            while (n2 + 4 < n3) {
                int n4 = ZipConstants.SH(byArray, n2);
                int n5 = ZipConstants.SH(byArray, n2 + 2);
                if (n4 != 1) {
                    n2 += 4 + n5;
                    continue;
                }
                n2 += 4;
                if (ZipConstants.CENLEN(byArray, n) == 0xFFFFFFFFL) {
                    n2 += 8;
                }
                if (ZipConstants.CENSIZ(byArray, n) == 0xFFFFFFFFL) {
                    n2 += 8;
                }
                return ZipConstants.LL(byArray, n2);
            }
        }
        return l;
    }

    static void printExtra(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n + 4 < n3) {
            int n4;
            int n5 = ZipConstants.SH(byArray, n);
            int n6 = ZipConstants.SH(byArray, n + 2);
            ZipInfo.print("        [tag=0x%04x, sz=%d, data= ", n5, n6);
            if (n + n6 > n3) {
                ZipInfo.print("    Error: Invalid extra data, beyond extra length", new Object[0]);
                break;
            }
            n += 4;
            for (n4 = 0; n4 < n6; ++n4) {
                ZipInfo.print("%02x ", byArray[n + n4]);
            }
            ZipInfo.print("]%n", new Object[0]);
            switch (n5) {
                case 1: {
                    ZipInfo.print("         ->ZIP64: ", new Object[0]);
                    n4 = n;
                    while (n4 + 8 <= n + n6) {
                        ZipInfo.print(" *0x%x ", ZipConstants.LL(byArray, n4));
                        n4 += 8;
                    }
                    ZipInfo.print("%n", new Object[0]);
                    break;
                }
                case 10: {
                    ZipInfo.print("         ->PKWare NTFS%n", new Object[0]);
                    if (ZipConstants.SH(byArray, n + 4) != 1 || ZipConstants.SH(byArray, n + 6) != 24) {
                        ZipInfo.print("    Error: Invalid NTFS sub-tag or subsz", new Object[0]);
                    }
                    ZipInfo.print("            mtime:%tc%n", ZipUtils.winToJavaTime(ZipConstants.LL(byArray, n + 8)));
                    ZipInfo.print("            atime:%tc%n", ZipUtils.winToJavaTime(ZipConstants.LL(byArray, n + 16)));
                    ZipInfo.print("            ctime:%tc%n", ZipUtils.winToJavaTime(ZipConstants.LL(byArray, n + 24)));
                    break;
                }
                case 21589: {
                    ZipInfo.print("         ->Inof-ZIP Extended Timestamp: flag=%x%n", byArray[n]);
                    n4 = n + 1;
                    while (n4 + 4 <= n + n6) {
                        ZipInfo.print("            *%tc%n", ZipUtils.unixToJavaTime(ZipConstants.LG(byArray, n4)));
                        n4 += 4;
                    }
                    break;
                }
            }
            n += n6;
        }
    }
}

